/*
 * Decompiled with CFR 0.152.
 */
package com.rosymaple.hitindication.event;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3d;
import com.mojang.math.Vector3f;
import com.rosymaple.hitindication.capability.latesthits.ClientLatestHits;
import com.rosymaple.hitindication.capability.latesthits.Hit;
import com.rosymaple.hitindication.capability.latesthits.Indicator;
import com.rosymaple.hitindication.config.HitIndicatorClientConfigs;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="hitindication", value={Dist.CLIENT})
public class RenderEvents {
    private static final ResourceLocation INDICATOR_RED = new ResourceLocation("hitindication", "textures/hit/indicator_red.png");
    private static final ResourceLocation INDICATOR_BLUE = new ResourceLocation("hitindication", "textures/hit/indicator_blue.png");
    private static final int textureWidth = 42;
    private static final int textureHeight = 13;

    @SubscribeEvent
    public static void onRender(RenderGameOverlayEvent.Post event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        int screenMiddleX = event.getWindow().m_85445_() / 2;
        int screenMiddleY = event.getWindow().m_85446_() / 2;
        Vec2 lookVec = new Vec2((float)mc.f_91074_.m_20154_().f_82479_, (float)mc.f_91074_.m_20154_().f_82481_);
        Vec2 playerPos = new Vec2((float)mc.f_91074_.m_20185_(), (float)mc.f_91074_.m_20189_());
        for (Hit hit : ClientLatestHits.latestHits) {
            RenderEvents.drawIndicator(event.getMatrixStack(), hit, screenMiddleX, screenMiddleY, playerPos, lookVec);
        }
    }

    private static void drawIndicator(PoseStack stack, Hit hit, int screenMiddleX, int screenMiddleY, Vec2 playerPos, Vec2 lookVec) {
        Vector3d sourceVec3d = hit.getLocation();
        Vec2 diff = new Vec2((float)(sourceVec3d.f_86214_ - (double)playerPos.f_82470_), (float)(sourceVec3d.f_86216_ - (double)playerPos.f_82471_));
        double angleBetween = RenderEvents.angleBetween(lookVec, diff);
        float opacity = hit.getLifeTime() >= 25 ? (float)((Integer)HitIndicatorClientConfigs.IndicatorOpacity.get()).intValue() : (float)((Integer)HitIndicatorClientConfigs.IndicatorOpacity.get() * hit.getLifeTime()) / 25.0f;
        opacity /= 100.0f;
        float defaultScale = 1.0f + (float)((Integer)HitIndicatorClientConfigs.IndicatorDefaultScale.get()).intValue() / 100.0f;
        int scaledTextureWidth = (int)Math.floor(42.0f * defaultScale);
        int scaledTextureHeight = (int)Math.floor(13.0f * defaultScale);
        if (((Boolean)HitIndicatorClientConfigs.SizeDependsOnDamage.get()).booleanValue()) {
            float scale = Mth.m_14036_((float)(hit.getDamagePercent() > 30 ? 1.0f + (float)hit.getDamagePercent() / 125.0f : 1.0f), (float)0.0f, (float)3.0f);
            scaledTextureWidth = (int)Math.floor((float)scaledTextureWidth * scale);
            scaledTextureHeight = (int)Math.floor((float)scaledTextureHeight * scale);
        }
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderEvents.bindIndicatorTexture(hit.getIndicator());
        stack.m_85836_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)opacity);
        stack.m_85837_((double)screenMiddleX, (double)screenMiddleY, 0.0);
        stack.m_85845_(Vector3f.f_122227_.m_122240_((float)angleBetween));
        stack.m_85837_((double)(-screenMiddleX), (double)(-screenMiddleY), 0.0);
        Gui.m_93133_((PoseStack)stack, (int)(screenMiddleX - scaledTextureWidth / 2), (int)(screenMiddleY - scaledTextureHeight / 2 - 30), (float)0.0f, (float)0.0f, (int)scaledTextureWidth, (int)scaledTextureHeight, (int)scaledTextureWidth, (int)scaledTextureHeight);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        stack.m_85849_();
    }

    private static void bindIndicatorTexture(Indicator type) {
        switch (type) {
            case BLUE: {
                RenderSystem.m_157456_((int)0, (ResourceLocation)INDICATOR_BLUE);
                break;
            }
            default: {
                RenderSystem.m_157456_((int)0, (ResourceLocation)INDICATOR_RED);
            }
        }
    }

    private static double angleBetween(Vec2 first, Vec2 second) {
        double dot = first.f_82470_ * second.f_82470_ + first.f_82471_ * second.f_82471_;
        double cross = first.f_82470_ * second.f_82471_ - second.f_82470_ * first.f_82471_;
        double res = Math.atan2(cross, dot) * 180.0 / Math.PI;
        return res;
    }

    private static Vec2 getLookVec(LocalPlayer player) {
        Vec2 vec = new Vec2((float)(-Math.sin((double)(-player.m_146908_()) * Math.PI / 180.0 - Math.PI)), (float)(-Math.cos((double)(-player.m_146908_()) * Math.PI / 180.0 - Math.PI)));
        return vec;
    }
}

