/*
 * Decompiled with CFR 0.152.
 */
package com.cartoonishvillain.incapacitated;

import com.cartoonishvillain.incapacitated.capability.PlayerCapability;
import com.cartoonishvillain.incapacitated.config.CommonConfig;
import com.cartoonishvillain.incapacitated.config.ConfigHelper;
import com.cartoonishvillain.incapacitated.networking.incapacitationMessenger;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ResourceLocationException;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="incapacitated")
public class Incapacitated {
    public static final String MODID = "incapacitated";
    private static final Logger LOGGER = LogManager.getLogger();
    public static CommonConfig config;
    public static ArrayList<ResourceLocation> ReviveFoods;
    public static ArrayList<ResourceLocation> HealingFoods;
    public static ArrayList<String> instantKillDamageSourcesMessageID;

    public Incapacitated() {
        incapacitationMessenger.register();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuff);
        config = ConfigHelper.register(ModConfig.Type.COMMON, CommonConfig::new);
        instantKillDamageSourcesMessageID = new ArrayList<String>(Arrays.asList("bleedout", DamageSource.field_76380_i.field_76373_n, DamageSource.field_76371_c.field_76373_n, DamageSource.field_82727_n.field_76373_n));
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void setup(FMLCommonSetupEvent event) {
        HealingFoods = this.getFoodForHealing();
        ReviveFoods = this.getFoodForReviving();
        PlayerCapability.register();
    }

    private void doClientStuff(FMLClientSetupEvent event) {
    }

    private ArrayList<ResourceLocation> getFoodForReviving() {
        String FoodList = Incapacitated.config.REVIVEFOODS.get();
        String[] reviveFoods = FoodList.split(",");
        ArrayList<ResourceLocation> reviveFoodList = new ArrayList<ResourceLocation>();
        try {
            for (String string : reviveFoods) {
                ResourceLocation food = new ResourceLocation(string);
                reviveFoodList.add(food);
            }
        }
        catch (ResourceLocationException e) {
            LOGGER.error("Incapacitation: Revive foods not parsed. Non [a-z0-9_.-] character in config! Using default...");
            ArrayList<ResourceLocation> errorReturnList = new ArrayList<ResourceLocation>();
            errorReturnList.add(new ResourceLocation("enchanted_golden_apple"));
            return errorReturnList;
        }
        return reviveFoodList;
    }

    private ArrayList<ResourceLocation> getFoodForHealing() {
        String FoodList = Incapacitated.config.HEALINGFOODS.get();
        String[] healFoods = FoodList.split(",");
        ArrayList<ResourceLocation> healFoodList = new ArrayList<ResourceLocation>();
        try {
            for (String string : healFoods) {
                ResourceLocation food = new ResourceLocation(string);
                healFoodList.add(food);
            }
        }
        catch (ResourceLocationException e) {
            LOGGER.error("Incapacitation: Healing foods not parsed. Non [a-z0-9_.-] character in config! Using default...");
            ArrayList<ResourceLocation> errorReturnList = new ArrayList<ResourceLocation>();
            errorReturnList.add(new ResourceLocation("golden_apple"));
            return errorReturnList;
        }
        return healFoodList;
    }
}

