/*
 * Decompiled with CFR 0.152.
 */
package com.cartoonishvillain.incapacitated.components;

import com.cartoonishvillain.incapacitated.BleedOutDamage;
import com.cartoonishvillain.incapacitated.Incapacitated;
import com.cartoonishvillain.incapacitated.components.ComponentStarter;
import com.cartoonishvillain.incapacitated.components.PlayerComponent;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2556;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public class IncapacitationWorker {
    public static void deathEvent(class_1282 damageSource, class_1657 player, CallbackInfo ci) {
        PlayerComponent h = (PlayerComponent)ComponentStarter.PLAYERCOMPONENTINSTANCE.get((Object)player);
        if (!(h.getIsIncapacitated() || Incapacitated.config.config.SOMEINSTANTKILLS && Incapacitated.instantKillDamageSourcesMessageID.contains(damageSource.method_5525()))) {
            h.setDownsUntilDeath(h.getDownsUntilDeath() - 1);
            if (h.getDownsUntilDeath() > -1) {
                h.setIsIncapacitated(true);
                ci.cancel();
                player.method_6033(player.method_6063());
                if (Incapacitated.config.config.GLOWING) {
                    player.method_6092(new class_1293(class_1294.field_5912, Integer.MAX_VALUE, 0));
                }
                if (Incapacitated.config.config.GLOBALINCAPMESSAGES) {
                    IncapacitationWorker.broadcast(player.method_5682(), new class_2585(player.method_5820() + " is incapacitated!"));
                } else {
                    ArrayList playerEntities = (ArrayList)player.field_6002.method_18467(class_1657.class, player.method_5829().method_1014(50.0));
                    for (class_1657 players : playerEntities) {
                        players.method_7353((class_2561)new class_2585(player.method_5820() + " is incapacitated!"), false);
                    }
                }
            }
        }
    }

    public static void tick(class_1657 player) {
        PlayerComponent h = (PlayerComponent)ComponentStarter.PLAYERCOMPONENTINSTANCE.get((Object)player);
        if (!player.field_6002.method_8608() && h.getIsIncapacitated()) {
            if (h.getJumpDelay() > 0) {
                h.setJumpDelay(h.getJumpDelay() - 1);
            } else if (h.getJumpDelay() < 0) {
                h.setJumpDelay(0);
            }
            ArrayList playerEntities = (ArrayList)player.field_6002.method_18467(class_1657.class, player.method_5829().method_1014(3.0));
            boolean reviving = false;
            class_1657 revivingPlayer = null;
            for (class_1657 players : playerEntities) {
                PlayerComponent y = (PlayerComponent)ComponentStarter.PLAYERCOMPONENTINSTANCE.get((Object)players);
                if (!players.method_18276() || y.getIsIncapacitated()) continue;
                reviving = true;
                revivingPlayer = players;
                break;
            }
            if (reviving) {
                if (h.downReviveCount()) {
                    h.setIsIncapacitated(false);
                    h.setReviveCount(Incapacitated.config.config.REVIVETICKS);
                    h.resetGiveUpJumps();
                    player.method_6016(class_1294.field_5912);
                    player.method_6033(player.method_6063() / 3.0f);
                    player.field_6002.method_8465(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14622, class_3419.field_15248, 1.0f, 1.0f);
                } else {
                    player.method_7353((class_2561)new class_2585("You are being revived! " + h.getReviveCount() / 20 + " seconds..").method_27692(class_124.field_1060), true);
                    revivingPlayer.method_7353((class_2561)new class_2585("Reviving " + player.method_5820() + " " + h.getReviveCount() / 20 + " seconds...").method_27692(class_124.field_1060), true);
                }
            } else {
                if (h.countTicksUntilDeath()) {
                    player.method_5643(BleedOutDamage.playerOutOfTime((class_1297)player), player.method_6063() * 10.0f);
                    h.setReviveCount(Incapacitated.config.config.REVIVETICKS);
                    h.resetGiveUpJumps();
                    player.method_6016(class_1294.field_5912);
                    h.setIsIncapacitated(false);
                } else if (h.getTicksUntilDeath() % 20 == 0) {
                    player.method_7353((class_2561)new class_2585("Incapacitated! Call for help or jump " + h.getJumpCount() + " times to give up! " + (float)h.getTicksUntilDeath() / 20.0f + " seconds left!").method_27692(class_124.field_1061), true);
                }
                if (h.getReviveCount() != Incapacitated.config.config.REVIVETICKS) {
                    h.setReviveCount(Incapacitated.config.config.REVIVETICKS);
                }
            }
        }
    }

    public static void jump(class_1657 player) {
        PlayerComponent h = (PlayerComponent)ComponentStarter.PLAYERCOMPONENTINSTANCE.get((Object)player);
        if (h.getIsIncapacitated() && h.getJumpDelay() == 0 && h.giveUpJumpCount()) {
            player.method_5643(BleedOutDamage.playerOutOfTime((class_1297)player), player.method_6063() * 10.0f);
            h.setReviveCount(Incapacitated.config.config.DOWNCOUNT);
            h.resetGiveUpJumps();
            h.setIsIncapacitated(false);
            player.method_6016(class_1294.field_5912);
        }
    }

    public static void hurt(class_1657 player, class_1282 damageSource, CallbackInfoReturnable<Boolean> cir) {
        PlayerComponent h = (PlayerComponent)ComponentStarter.PLAYERCOMPONENTINSTANCE.get((Object)player);
        if (h.getIsIncapacitated() && Incapacitated.config.config.INVINCIBLEDOWN && !damageSource.method_5525().equals("bleedout")) {
            cir.cancel();
            return;
        }
        h.setJumpDelay(20);
    }

    public static void eat(class_1309 entity, class_1799 itemStack) {
        class_1309 class_13092 = entity;
        if (class_13092 instanceof class_1657) {
            class_1657 player = (class_1657)class_13092;
            if (!entity.field_6002.method_8608()) {
                class_1792 item = itemStack.method_7909();
                PlayerComponent h = (PlayerComponent)ComponentStarter.PLAYERCOMPONENTINSTANCE.get((Object)player);
                if (Incapacitated.HealingFoods.contains(item.toString())) {
                    h.setDownsUntilDeath(Incapacitated.config.config.DOWNCOUNT);
                    h.setTicksUntilDeath(Incapacitated.config.config.DOWNTICKS);
                }
                if (h.getIsIncapacitated()) {
                    if (Incapacitated.ReviveFoods.contains(item.toString())) {
                        h.setIsIncapacitated(false);
                        h.setReviveCount(Incapacitated.config.config.REVIVETICKS);
                        h.resetGiveUpJumps();
                        h.setDownsUntilDeath(Incapacitated.config.config.DOWNCOUNT);
                        player.method_6016(class_1294.field_5912);
                        h.setTicksUntilDeath(Incapacitated.config.config.DOWNTICKS);
                        player.method_6033(player.method_6063() / 3.0f);
                        player.field_6002.method_8465(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14622, class_3419.field_15248, 1.0f, 1.0f);
                    }
                } else if (Incapacitated.ReviveFoods.contains(item.toString())) {
                    h.setDownsUntilDeath(Incapacitated.config.config.DOWNCOUNT);
                    h.setTicksUntilDeath(Incapacitated.config.config.DOWNTICKS);
                }
            }
        }
    }

    private static void broadcast(MinecraftServer server, class_2585 translationTextComponent) {
        server.method_3760().method_14616((class_2561)translationTextComponent, class_2556.field_11737, UUID.randomUUID());
    }
}

