/*
 * Decompiled with CFR 0.152.
 */
package com.cartoonishvillain.incapacitated;

import com.cartoonishvillain.incapacitated.config.CommonConfig;
import com.cartoonishvillain.incapacitated.config.ConfigHelper;
import com.cartoonishvillain.incapacitated.networking.IncapacitationMessenger;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ResourceLocationException;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="incapacitated")
public class Incapacitated {
    public static final String MODID = "incapacitated";
    private static final Logger LOGGER = LogManager.getLogger();
    public static CommonConfig config;
    public static ArrayList<ResourceLocation> ReviveFoods;
    public static ArrayList<ResourceLocation> HealingFoods;
    public static ArrayList<String> instantKillDamageSourcesMessageID;

    public Incapacitated() {
        IncapacitationMessenger.register();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuff);
        config = ConfigHelper.register(ModConfig.Type.COMMON, CommonConfig::new);
        instantKillDamageSourcesMessageID = new ArrayList<String>(List.of("bleedout", DamageSource.f_19317_.f_19326_, DamageSource.f_19308_.f_19326_, DamageSource.f_19320_.f_19326_));
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void setup(FMLCommonSetupEvent event) {
        HealingFoods = this.getFoodForHealing();
        ReviveFoods = this.getFoodForReviving();
    }

    private void doClientStuff(FMLClientSetupEvent event) {
    }

    private ArrayList<ResourceLocation> getFoodForReviving() {
        String FoodList = Incapacitated.config.REVIVEFOODS.get();
        String[] reviveFoods = FoodList.split(",");
        ArrayList<ResourceLocation> reviveFoodList = new ArrayList<ResourceLocation>();
        try {
            for (String string : reviveFoods) {
                ResourceLocation food = new ResourceLocation(string);
                reviveFoodList.add(food);
            }
        }
        catch (ResourceLocationException e) {
            LOGGER.error("Incapacitation: Revive foods not parsed. Non [a-z0-9_.-] character in config! Using default...");
            return new ArrayList<ResourceLocation>(List.of(new ResourceLocation("enchanted_golden_apple")));
        }
        return reviveFoodList;
    }

    private ArrayList<ResourceLocation> getFoodForHealing() {
        String FoodList = Incapacitated.config.HEALINGFOODS.get();
        String[] healFoods = FoodList.split(",");
        ArrayList<ResourceLocation> healFoodList = new ArrayList<ResourceLocation>();
        try {
            for (String string : healFoods) {
                ResourceLocation food = new ResourceLocation(string);
                healFoodList.add(food);
            }
        }
        catch (ResourceLocationException e) {
            LOGGER.error("Incapacitation: Healing foods not parsed. Non [a-z0-9_.-] character in config! Using default...");
            return new ArrayList<ResourceLocation>(List.of(new ResourceLocation("golden_apple")));
        }
        return healFoodList;
    }
}

