/*
 * Decompiled with CFR 0.152.
 */
package com.cartoonishvillain.incapacitated.networking;

import com.cartoonishvillain.incapacitated.capability.PlayerCapability;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.fmllegacy.network.NetworkEvent;

public class IncapPacket {
    private int ID;
    private Boolean isIncapacitated;

    public IncapPacket(int id, boolean isIncapacitated) {
        this.ID = id;
        this.isIncapacitated = isIncapacitated;
    }

    public IncapPacket(FriendlyByteBuf packetBuffer) {
        this.ID = packetBuffer.readInt();
        this.isIncapacitated = packetBuffer.readBoolean();
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.ID);
        buffer.writeBoolean(this.isIncapacitated.booleanValue());
    }

    public static IncapPacket decode(FriendlyByteBuf buf) {
        return new IncapPacket(buf);
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            Entity entity = Minecraft.m_91087_().f_91073_.m_6815_(this.ID);
            if (entity != null) {
                entity.getCapability(PlayerCapability.INSTANCE).ifPresent(h -> h.setIsIncapacitated(this.isIncapacitated));
            }
        });
        context.setPacketHandled(true);
    }
}

