/*
 * Decompiled with CFR 0.152.
 */
package com.cartoonishvillain.incapacitated.events;

import com.cartoonishvillain.incapacitated.Incapacitated;
import com.cartoonishvillain.incapacitated.capability.PlayerCapability;
import com.cartoonishvillain.incapacitated.capability.PlayerCapabilityManager;
import com.cartoonishvillain.incapacitated.networking.IncapPacket;
import com.cartoonishvillain.incapacitated.networking.IncapacitationMessenger;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="incapacitated", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ForgeEvents {
    @SubscribeEvent
    public static void playerRegister(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player) {
            PlayerCapabilityManager provider = new PlayerCapabilityManager();
            event.addCapability(new ResourceLocation("incapacitated", "incapacitated"), (ICapabilityProvider)provider);
        }
    }

    @SubscribeEvent
    public static void playerDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntityLiving();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (!event.isCanceled()) {
                player.getCapability(PlayerCapability.INSTANCE).ifPresent(h -> {
                    if (!(h.getIsIncapacitated() || Incapacitated.config.SOMEINSTANTKILLS.get().booleanValue() && Incapacitated.instantKillDamageSourcesMessageID.contains(event.getSource().m_19385_()))) {
                        h.setDownsUntilDeath(h.getDownsUntilDeath() - 1);
                        if (h.getDownsUntilDeath() > -1) {
                            h.setIsIncapacitated(true);
                            h.setSourceOfDeath(event.getSource());
                            event.setCanceled(true);
                            player.m_21153_(player.m_21233_());
                            if (Incapacitated.config.GLOWING.get().booleanValue()) {
                                player.m_7292_(new MobEffectInstance(MobEffects.f_19619_, Integer.MAX_VALUE, 0));
                            }
                            IncapacitationMessenger.sendTo(new IncapPacket(player.m_142049_(), true), player);
                            if (Incapacitated.config.GLOBALINCAPMESSAGES.get().booleanValue()) {
                                ForgeEvents.broadcast(player.m_20194_(), new TextComponent(player.m_6302_() + " is incapacitated!"));
                            } else {
                                ArrayList playerEntities = (ArrayList)player.f_19853_.m_45976_(Player.class, player.m_142469_().m_82400_(50.0));
                                for (Player players : playerEntities) {
                                    players.m_5661_((Component)new TextComponent(player.m_6302_() + " is incapacitated!"), false);
                                }
                            }
                        }
                    }
                });
            }
        }
    }

    @SubscribeEvent
    public static void playerCloneEvent(PlayerEvent.Clone event) {
        if (!event.isWasDeath()) {
            Player originalPlayer = event.getOriginal();
            Player newPlayer = event.getPlayer();
            AtomicBoolean incapacitated = new AtomicBoolean(false);
            AtomicInteger ticksUntilDeath = new AtomicInteger(Integer.MAX_VALUE);
            AtomicInteger downsUntilDeath = new AtomicInteger(Integer.MAX_VALUE);
            originalPlayer.revive();
            originalPlayer.getCapability(PlayerCapability.INSTANCE).ifPresent(h -> {
                incapacitated.set(h.getIsIncapacitated());
                ticksUntilDeath.set(h.getTicksUntilDeath());
                downsUntilDeath.set(h.getDownsUntilDeath());
            });
            originalPlayer.m_6074_();
            newPlayer.getCapability(PlayerCapability.INSTANCE).ifPresent(h -> {
                h.setIsIncapacitated(incapacitated.get());
                h.setTicksUntilDeath(ticksUntilDeath.get());
                h.setDownsUntilDeath(downsUntilDeath.get());
            });
        }
    }

    @SubscribeEvent
    public static void PlayerJoinEvent(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof Player && !event.getWorld().m_5776_()) {
            Player player = (Player)event.getEntity();
            player.getCapability(PlayerCapability.INSTANCE).ifPresent(h -> IncapacitationMessenger.sendTo(new IncapPacket(player.m_142049_(), h.getIsIncapacitated()), player));
        }
    }

    @SubscribeEvent
    public static void playerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            event.player.getCapability(PlayerCapability.INSTANCE).ifPresent(h -> {
                h.countDelay();
                if (h.getIsIncapacitated()) {
                    if (event.player.getForcedPose() == null) {
                        event.player.setForcedPose(Pose.SWIMMING);
                    }
                    if (!event.player.f_19853_.m_5776_()) {
                        ArrayList playerEntities = (ArrayList)event.player.f_19853_.m_45976_(Player.class, event.player.m_142469_().m_82400_(3.0));
                        boolean reviving = false;
                        Player revivingPlayer = null;
                        for (Player player : playerEntities) {
                            AtomicBoolean isdown = new AtomicBoolean(false);
                            AtomicBoolean targetIsDown = new AtomicBoolean(false);
                            player.getCapability(PlayerCapability.INSTANCE).ifPresent(j -> isdown.set(j.getIsIncapacitated()));
                            event.player.getCapability(PlayerCapability.INSTANCE).ifPresent(j -> targetIsDown.set(j.getIsIncapacitated()));
                            if (!player.m_6047_() || !targetIsDown.get() || isdown.get()) continue;
                            reviving = true;
                            revivingPlayer = player;
                            break;
                        }
                        if (reviving) {
                            if (h.downReviveCount()) {
                                h.setIsIncapacitated(false);
                                event.player.setForcedPose(null);
                                h.setReviveCount(Incapacitated.config.REVIVETICKS.get());
                                h.resetGiveUpJumps();
                                event.player.m_21195_(MobEffects.f_19619_);
                                IncapacitationMessenger.sendTo(new IncapPacket(event.player.m_142049_(), false), event.player);
                                event.player.m_21153_(event.player.m_21233_() / 3.0f);
                                event.player.f_19853_.m_6263_(null, event.player.m_20185_(), event.player.m_20186_(), event.player.m_20189_(), SoundEvents.f_12216_, SoundSource.PLAYERS, 1.0f, 1.0f);
                            } else {
                                event.player.m_5661_((Component)new TextComponent("You are being revived! " + h.getReviveCount() / 20 + " seconds..").m_130940_(ChatFormatting.GREEN), true);
                                revivingPlayer.m_5661_((Component)new TextComponent("Reviving " + event.player.m_6302_() + " " + h.getReviveCount() / 20 + " seconds...").m_130940_(ChatFormatting.GREEN), true);
                            }
                        } else {
                            if (h.countTicksUntilDeath()) {
                                event.player.m_6469_(h.getSourceOfDeath(), event.player.m_21233_() * 10.0f);
                                event.player.setForcedPose(null);
                                h.setReviveCount(Incapacitated.config.REVIVETICKS.get());
                                h.resetGiveUpJumps();
                                event.player.m_21195_(MobEffects.f_19619_);
                                h.setIsIncapacitated(false);
                                IncapacitationMessenger.sendTo(new IncapPacket(event.player.m_142049_(), false), event.player);
                            } else if (h.getTicksUntilDeath() % 20 == 0) {
                                event.player.m_5661_((Component)new TextComponent("Incapacitated! Call for help or jump " + h.getJumpCount() + " times to give up! " + (float)h.getTicksUntilDeath() / 20.0f + " seconds left!").m_130940_(ChatFormatting.RED), true);
                            }
                            if (h.getReviveCount() != Incapacitated.config.REVIVETICKS.get().intValue()) {
                                h.setReviveCount(Incapacitated.config.REVIVETICKS.get());
                            }
                        }
                    }
                } else if (event.player.getForcedPose() != null) {
                    event.player.setForcedPose(null);
                }
            });
        }
    }

    @SubscribeEvent
    public static void playerJump(LivingEvent.LivingJumpEvent event) {
        if (event.getEntityLiving() instanceof Player && !event.getEntityLiving().f_19853_.m_5776_()) {
            Player player = (Player)event.getEntityLiving();
            player.getCapability(PlayerCapability.INSTANCE).ifPresent(h -> {
                if (h.getIsIncapacitated() && h.getJumpDelay() == 0 && h.giveUpJumpCount()) {
                    player.m_6469_(h.getSourceOfDeath(), player.m_21233_() * 10.0f);
                    player.setForcedPose(null);
                    h.setReviveCount(Incapacitated.config.DOWNCOUNT.get());
                    h.resetGiveUpJumps();
                    h.setIsIncapacitated(false);
                    player.m_21195_(MobEffects.f_19619_);
                    IncapacitationMessenger.sendTo(new IncapPacket(player.m_142049_(), false), player);
                }
            });
        }
    }

    @SubscribeEvent
    public static void playerInjured(LivingHurtEvent event) {
        if (event.getEntityLiving() instanceof Player) {
            Player player = (Player)event.getEntityLiving();
            player.getCapability(PlayerCapability.INSTANCE).ifPresent(h -> {
                if (h.getIsIncapacitated() && Incapacitated.config.INVINCIBLEDOWN.get().booleanValue() && !event.getSource().m_19385_().equals("bleedout")) {
                    event.setCanceled(true);
                    return;
                }
                h.setJumpDelay(20);
            });
        }
    }

    @SubscribeEvent
    public static void playerEat(LivingEntityUseItemEvent.Finish event) {
        if (event.getEntityLiving() instanceof Player && !event.getEntityLiving().f_19853_.m_5776_()) {
            Item item = event.getItem().m_41720_();
            Player player = (Player)event.getEntityLiving();
            player.getCapability(PlayerCapability.INSTANCE).ifPresent(h -> {
                if (Incapacitated.HealingFoods.contains(item.getRegistryName())) {
                    h.setDownsUntilDeath(Incapacitated.config.DOWNCOUNT.get());
                    h.setTicksUntilDeath(Incapacitated.config.DOWNTICKS.get());
                }
                if (h.getIsIncapacitated()) {
                    if (Incapacitated.ReviveFoods.contains(item.getRegistryName())) {
                        h.setIsIncapacitated(false);
                        player.setForcedPose(null);
                        h.setReviveCount(Incapacitated.config.REVIVETICKS.get());
                        h.resetGiveUpJumps();
                        h.setDownsUntilDeath(Incapacitated.config.DOWNCOUNT.get());
                        player.m_21195_(MobEffects.f_19619_);
                        h.setTicksUntilDeath(Incapacitated.config.DOWNTICKS.get());
                        IncapacitationMessenger.sendTo(new IncapPacket(player.m_142049_(), false), player);
                        player.m_21153_(player.m_21233_() / 3.0f);
                        player.f_19853_.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12216_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    }
                } else if (Incapacitated.ReviveFoods.contains(item.getRegistryName())) {
                    h.setDownsUntilDeath(Incapacitated.config.DOWNCOUNT.get());
                    h.setTicksUntilDeath(Incapacitated.config.DOWNTICKS.get());
                }
            });
        }
    }

    private static void broadcast(MinecraftServer server, TextComponent translationTextComponent) {
        server.m_6846_().m_11264_((Component)translationTextComponent, ChatType.CHAT, UUID.randomUUID());
    }
}

