/*
 * Decompiled with CFR 0.152.
 */
package com.cartoonishvillain.incapacitated.capability;

import com.cartoonishvillain.incapacitated.Incapacitated;
import com.cartoonishvillain.incapacitated.capability.IPlayerCapability;
import com.cartoonishvillain.incapacitated.capability.PlayerCapability;
import com.cartoonishvillain.incapacitated.events.BleedOutDamage;
import com.cartoonishvillain.incapacitated.events.IncapacitatedDamageSources;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;

public class PlayerCapabilityManager
implements IPlayerCapability,
ICapabilityProvider,
INBTSerializable<CompoundTag> {
    protected boolean incapacitated = false;
    protected int ticksUntilDeath;
    protected int downsUntilDeath;
    protected int giveUpJumps;
    protected int reviveCounter;
    protected int jumpDelay;
    public final LazyOptional<IPlayerCapability> holder;
    private DamageSource originalSource;

    public PlayerCapabilityManager() {
        this.ticksUntilDeath = Incapacitated.config.DOWNTICKS.get();
        this.downsUntilDeath = Incapacitated.config.DOWNCOUNT.get();
        this.giveUpJumps = 3;
        this.reviveCounter = Incapacitated.config.REVIVETICKS.get();
        this.jumpDelay = 0;
        this.holder = LazyOptional.of(() -> this);
    }

    @Override
    public boolean getIsIncapacitated() {
        return this.incapacitated;
    }

    @Override
    public void setIsIncapacitated(boolean isIncapacitated) {
        this.incapacitated = isIncapacitated;
    }

    @Override
    public int getTicksUntilDeath() {
        return this.ticksUntilDeath;
    }

    @Override
    public boolean countTicksUntilDeath() {
        --this.ticksUntilDeath;
        return this.ticksUntilDeath <= 0;
    }

    @Override
    public void setTicksUntilDeath(int ticks) {
        this.ticksUntilDeath = ticks;
    }

    @Override
    public int getDownsUntilDeath() {
        return this.downsUntilDeath;
    }

    @Override
    public void setDownsUntilDeath(int downs) {
        this.downsUntilDeath = downs;
    }

    @Override
    public boolean giveUpJumpCount() {
        --this.giveUpJumps;
        return this.giveUpJumps <= 0;
    }

    @Override
    public void resetGiveUpJumps() {
        this.giveUpJumps = 3;
    }

    @Override
    public int getJumpCount() {
        return this.giveUpJumps;
    }

    @Override
    public void setJumpCount(int jumps) {
        this.giveUpJumps = jumps;
    }

    @Override
    public boolean downReviveCount() {
        --this.reviveCounter;
        return this.reviveCounter <= 0;
    }

    @Override
    public int getReviveCount() {
        return this.reviveCounter;
    }

    @Override
    public void setReviveCount(int count) {
        this.reviveCounter = count;
    }

    @Override
    public int getJumpDelay() {
        return this.jumpDelay;
    }

    @Override
    public void setJumpDelay(int delay) {
        this.jumpDelay = delay;
    }

    @Override
    public void countDelay() {
        if (this.jumpDelay > 0) {
            --this.jumpDelay;
        } else if (this.jumpDelay < 0) {
            this.jumpDelay = 0;
        }
    }

    @Override
    public DamageSource getSourceOfDeath(Level level) {
        Holder.Reference damageType = level.m_9598_().m_175515_(Registries.f_268580_).m_246971_(IncapacitatedDamageSources.BLEEDOUT);
        Holder.Reference fallOutOfWorld = level.m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268724_);
        return this.originalSource != null ? this.originalSource : new BleedOutDamage((Holder<DamageType>)damageType, new DamageSource((Holder)fallOutOfWorld));
    }

    @Override
    public void setSourceOfDeath(Level level, DamageSource causeOfDeath) {
        Holder.Reference damageType = level.m_9598_().m_175515_(Registries.f_268580_).m_246971_(IncapacitatedDamageSources.BLEEDOUT);
        this.originalSource = new BleedOutDamage((Holder<DamageType>)damageType, causeOfDeath);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == PlayerCapability.INSTANCE) {
            return PlayerCapability.INSTANCE.orEmpty(cap, this.holder);
        }
        return LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128379_("incapacitation", this.incapacitated);
        tag.m_128405_("incapTimer", this.ticksUntilDeath);
        tag.m_128405_("incapCounter", this.downsUntilDeath);
        tag.m_128405_("jumpCounter", this.giveUpJumps);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.incapacitated = tag.m_128471_("incapacitation");
        this.ticksUntilDeath = tag.m_128451_("incapTimer");
        this.downsUntilDeath = tag.m_128451_("incapCounter");
        this.giveUpJumps = tag.m_128451_("jumpCounter");
    }
}

