/*
 * Decompiled with CFR 0.152.
 */
package com.cartoonishvillain.incapacitated.events;

import com.cartoonishvillain.incapacitated.IncapEffects;
import com.cartoonishvillain.incapacitated.Incapacitated;
import com.cartoonishvillain.incapacitated.capability.PlayerCapability;
import com.cartoonishvillain.incapacitated.events.ForgeEvents;
import com.cartoonishvillain.incapacitated.networking.IncapPacket;
import com.cartoonishvillain.incapacitated.networking.IncapacitationMessenger;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingDeathEvent;

public class AbstractedIncapacitation {
    public static void downOrKill(Player player) {
        player.getCapability(PlayerCapability.INSTANCE).ifPresent(h -> {
            if (!h.getIsIncapacitated()) {
                if (!Incapacitated.unlimitedDowns.booleanValue()) {
                    h.setDownsUntilDeath(h.getDownsUntilDeath() - 1);
                }
                if (h.getDownsUntilDeath() > -1) {
                    h.setIsIncapacitated(true);
                    player.m_21153_(player.m_21233_());
                    if (Incapacitated.config.GLOWING.get().booleanValue()) {
                        player.m_7292_(new MobEffectInstance(MobEffects.f_19619_, Integer.MAX_VALUE, 0, true, false));
                    }
                    IncapacitationMessenger.sendTo(new IncapPacket(player.m_19879_(), true, (short)h.getDownsUntilDeath()), player);
                    if (Incapacitated.slow.booleanValue()) {
                        player.m_7292_(new MobEffectInstance(IncapEffects.incapSlow, Integer.MAX_VALUE, 6, true, false));
                    }
                    if (Incapacitated.weakened.booleanValue()) {
                        player.m_7292_(new MobEffectInstance(IncapEffects.incapWeak, Integer.MAX_VALUE, 100, true, false));
                    }
                    if (Incapacitated.config.GLOBALINCAPMESSAGES.get().booleanValue()) {
                        ForgeEvents.broadcast(player.m_20194_(), (Component)Component.m_237110_((String)"message.incap.message", (Object[])new Object[]{player.m_6302_()}));
                    } else {
                        ArrayList playerEntities = (ArrayList)player.f_19853_.m_45976_(Player.class, player.m_20191_().m_82400_(50.0));
                        for (Player players : playerEntities) {
                            players.m_5661_((Component)Component.m_237110_((String)"message.incap.message", (Object[])new Object[]{player.m_6302_()}), false);
                        }
                    }
                } else {
                    player.m_6074_();
                }
            }
        });
    }

    public static void downOrKill(Player player, LivingDeathEvent event) {
        player.getCapability(PlayerCapability.INSTANCE).ifPresent(h -> {
            block19: {
                block18: {
                    if (h.getIsIncapacitated() || Incapacitated.config.SOMEINSTANTKILLS.get().booleanValue()) break block18;
                    if (!Incapacitated.unlimitedDowns.booleanValue()) {
                        h.setDownsUntilDeath(h.getDownsUntilDeath() - 1);
                    }
                    if (h.getDownsUntilDeath() <= -1) break block19;
                    h.setIsIncapacitated(true);
                    h.setSourceOfDeath(player.f_19853_, event.getSource());
                    event.setCanceled(true);
                    player.m_21153_(player.m_21233_());
                    if (Incapacitated.config.GLOWING.get().booleanValue()) {
                        player.m_7292_(new MobEffectInstance(MobEffects.f_19619_, Integer.MAX_VALUE, 0, true, false));
                    }
                    IncapacitationMessenger.sendTo(new IncapPacket(player.m_19879_(), true, (short)h.getDownsUntilDeath()), player);
                    if (Incapacitated.slow.booleanValue()) {
                        player.m_7292_(new MobEffectInstance(IncapEffects.incapSlow, Integer.MAX_VALUE, 6, true, false));
                    }
                    if (Incapacitated.weakened.booleanValue()) {
                        player.m_7292_(new MobEffectInstance(IncapEffects.incapWeak, Integer.MAX_VALUE, 100, true, false));
                    }
                    if (Incapacitated.config.GLOBALINCAPMESSAGES.get().booleanValue()) {
                        ForgeEvents.broadcast(player.m_20194_(), (Component)Component.m_237110_((String)"message.incap.message", (Object[])new Object[]{player.m_6302_()}));
                    } else {
                        ArrayList playerEntities = (ArrayList)player.f_19853_.m_45976_(Player.class, player.m_20191_().m_82400_(50.0));
                        for (Player players : playerEntities) {
                            players.m_5661_((Component)Component.m_237110_((String)"message.incap.message", (Object[])new Object[]{player.m_6302_()}), false);
                        }
                    }
                    break block19;
                }
                if (!h.getIsIncapacitated() && Incapacitated.config.SOMEINSTANTKILLS.get().booleanValue()) {
                    boolean notInstantKill = true;
                    for (String damageType : Incapacitated.instantKillDamageSourcesMessageID) {
                        if (!damageType.contains(event.getSource().m_19385_())) continue;
                        notInstantKill = false;
                    }
                    if (notInstantKill) {
                        if (!Incapacitated.unlimitedDowns.booleanValue()) {
                            h.setDownsUntilDeath(h.getDownsUntilDeath() - 1);
                        }
                        if (h.getDownsUntilDeath() > -1) {
                            h.setIsIncapacitated(true);
                            h.setSourceOfDeath(player.f_19853_, event.getSource());
                            event.setCanceled(true);
                            player.m_21153_(player.m_21233_());
                            if (Incapacitated.config.GLOWING.get().booleanValue()) {
                                player.m_7292_(new MobEffectInstance(MobEffects.f_19619_, Integer.MAX_VALUE, 0, true, false));
                            }
                            IncapacitationMessenger.sendTo(new IncapPacket(player.m_19879_(), true, (short)h.getDownsUntilDeath()), player);
                            if (Incapacitated.slow.booleanValue()) {
                                player.m_7292_(new MobEffectInstance(IncapEffects.incapSlow, Integer.MAX_VALUE, 6, true, false));
                            }
                            if (Incapacitated.weakened.booleanValue()) {
                                player.m_7292_(new MobEffectInstance(IncapEffects.incapWeak, Integer.MAX_VALUE, 100, true, false));
                            }
                            if (Incapacitated.config.GLOBALINCAPMESSAGES.get().booleanValue()) {
                                ForgeEvents.broadcast(player.m_20194_(), (Component)Component.m_237110_((String)"message.incap.message", (Object[])new Object[]{player.m_6302_()}));
                            } else {
                                ArrayList playerEntities = (ArrayList)player.f_19853_.m_45976_(Player.class, player.m_20191_().m_82400_(50.0));
                                for (Player players : playerEntities) {
                                    players.m_5661_((Component)Component.m_237110_((String)"message.incap.message", (Object[])new Object[]{player.m_6302_()}), false);
                                }
                            }
                        }
                    }
                }
            }
        });
    }

    public static void revive(Player player) {
        player.getCapability(PlayerCapability.INSTANCE).ifPresent(h -> {
            h.setIsIncapacitated(false);
            player.setForcedPose(null);
            h.setReviveCount(Incapacitated.config.REVIVETICKS.get());
            h.resetGiveUpJumps();
            player.m_21195_(MobEffects.f_19619_);
            player.m_21195_(IncapEffects.incapSlow);
            player.m_21195_(IncapEffects.incapWeak);
            IncapacitationMessenger.sendTo(new IncapPacket(player.m_19879_(), false, (short)h.getDownsUntilDeath()), player);
            player.m_21153_(player.m_21233_() / 3.0f);
            player.f_19853_.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)SoundEvents.f_12216_.m_203334_(), SoundSource.PLAYERS, 1.0f, 1.0f);
            if (Incapacitated.config.GLOBALREVIVEMESSAGES.get().booleanValue()) {
                ForgeEvents.broadcast(player.m_20194_(), (Component)Component.m_237110_((String)"message.revive.message", (Object[])new Object[]{player.m_6302_()}));
            } else {
                ArrayList playerEntities = (ArrayList)player.f_19853_.m_45976_(Player.class, player.m_20191_().m_82400_(50.0));
                for (Player players : playerEntities) {
                    players.m_5661_((Component)Component.m_237110_((String)"message.revive.message", (Object[])new Object[]{player.m_6302_()}), false);
                }
            }
            if (Incapacitated.config.REVIVE_MESSAGE.get().booleanValue() && !Incapacitated.unlimitedDowns.booleanValue()) {
                if (h.getDownsUntilDeath() > 1) {
                    player.m_5661_((Component)Component.m_237110_((String)"message.revivecount.normal", (Object[])new Object[]{h.getDownsUntilDeath()}), false);
                } else if (h.getDownsUntilDeath() == 1) {
                    player.m_5661_((Component)Component.m_237115_((String)"message.revivecount.one"), false);
                } else {
                    player.m_5661_((Component)Component.m_237115_((String)"message.revivecount.zero"), false);
                }
            }
        });
    }

    public static void setDownCount(Player player, short value) {
        player.getCapability(PlayerCapability.INSTANCE).ifPresent(h -> {
            h.setDownsUntilDeath(value);
            IncapacitationMessenger.sendTo(new IncapPacket(player.m_19879_(), h.getIsIncapacitated(), (short)h.getDownsUntilDeath()), player);
        });
    }

    public static short getDownCount(Player player) {
        AtomicInteger integer = new AtomicInteger(0);
        player.getCapability(PlayerCapability.INSTANCE).ifPresent(h -> integer.set(h.getDownsUntilDeath()));
        return (short)integer.get();
    }
}

