/*
 * Decompiled with CFR 0.152.
 */
package com.cartoonishvillain.incapacitated.events;

import com.cartoonishvillain.incapacitated.Incapacitated;
import com.cartoonishvillain.incapacitated.capability.PlayerCapability;
import com.cartoonishvillain.incapacitated.capability.PlayerCapabilityManager;
import com.cartoonishvillain.incapacitated.commands.GetDownCount;
import com.cartoonishvillain.incapacitated.commands.IncapDevMode;
import com.cartoonishvillain.incapacitated.commands.KillPlayer;
import com.cartoonishvillain.incapacitated.commands.SetDownCount;
import com.cartoonishvillain.incapacitated.commands.SetIncapacitatedCommand;
import com.cartoonishvillain.incapacitated.events.AbstractedIncapacitation;
import com.cartoonishvillain.incapacitated.networking.IncapPacket;
import com.cartoonishvillain.incapacitated.networking.IncapacitationMessenger;
import com.mojang.brigadier.CommandDispatcher;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLLoader;

@Mod.EventBusSubscriber(modid="incapacitated", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ForgeEvents {
    @SubscribeEvent
    public static void serverLoad(RegisterCommandsEvent event) {
        SetIncapacitatedCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        SetDownCount.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        GetDownCount.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        KillPlayer.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        if (!FMLLoader.isProduction()) {
            IncapDevMode.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        }
    }

    @SubscribeEvent
    public static void playerRegister(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player) {
            PlayerCapabilityManager provider = new PlayerCapabilityManager();
            event.addCapability(new ResourceLocation("incapacitated", "incapacitated"), (ICapabilityProvider)provider);
        }
    }

    @SubscribeEvent
    public static void playerHurtCheck(LivingHurtEvent event) {
        if (event.getEntity() instanceof ServerPlayer) {
            event.getEntity().getCapability(PlayerCapability.INSTANCE).ifPresent(h -> {
                if (h.getIsIncapacitated() && Incapacitated.merciful.booleanValue() && !event.getSource().m_19385_().equals("bleedout")) {
                    event.setAmount(0.0f);
                }
            });
        }
    }

    @SubscribeEvent
    public static void playerKillCheck(LivingDeathEvent event) {
        if (event.getSource().m_7639_() instanceof ServerPlayer && !(event.getEntity() instanceof Player)) {
            event.getSource().m_7639_().getCapability(PlayerCapability.INSTANCE).ifPresent(h -> {
                if (h.getIsIncapacitated()) {
                    AbstractedIncapacitation.revive((Player)event.getSource().m_7639_());
                }
            });
        }
    }

    @SubscribeEvent
    public static void playerDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (!event.isCanceled()) {
                AbstractedIncapacitation.downOrKill(player, event);
            }
        }
    }

    @SubscribeEvent
    public static void playerLogoutEvent(PlayerEvent.PlayerLoggedOutEvent event) {
        if (Incapacitated.downLogging.booleanValue() && event.getEntity() instanceof ServerPlayer) {
            event.getEntity().getCapability(PlayerCapability.INSTANCE).ifPresent(h -> {
                if (h.getIsIncapacitated()) {
                    event.getEntity().m_6074_();
                }
            });
        }
    }

    @SubscribeEvent
    public static void playerCloneEvent(PlayerEvent.Clone event) {
        if (!event.isWasDeath()) {
            Player originalPlayer = event.getOriginal();
            Player newPlayer = event.getEntity();
            AtomicBoolean incapacitated = new AtomicBoolean(false);
            AtomicInteger ticksUntilDeath = new AtomicInteger(Integer.MAX_VALUE);
            AtomicInteger downsUntilDeath = new AtomicInteger(Integer.MAX_VALUE);
            originalPlayer.revive();
            originalPlayer.getCapability(PlayerCapability.INSTANCE).ifPresent(h -> {
                incapacitated.set(h.getIsIncapacitated());
                ticksUntilDeath.set(h.getTicksUntilDeath());
                downsUntilDeath.set(h.getDownsUntilDeath());
            });
            originalPlayer.m_6074_();
            newPlayer.getCapability(PlayerCapability.INSTANCE).ifPresent(h -> {
                h.setIsIncapacitated(incapacitated.get());
                h.setTicksUntilDeath(ticksUntilDeath.get());
                h.setDownsUntilDeath(downsUntilDeath.get());
            });
        }
    }

    @SubscribeEvent
    public static void PlayerJoinEvent(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!event.getLevel().m_5776_()) {
                player.getCapability(PlayerCapability.INSTANCE).ifPresent(h -> IncapacitationMessenger.sendTo(new IncapPacket(player.m_19879_(), h.getIsIncapacitated(), (short)h.getDownsUntilDeath()), player));
            }
        }
    }

    @SubscribeEvent
    public static void playerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            event.player.getCapability(PlayerCapability.INSTANCE).ifPresent(h -> {
                h.countDelay();
                if (h.getIsIncapacitated()) {
                    if (event.player.getForcedPose() == null) {
                        event.player.setForcedPose(Pose.SWIMMING);
                    }
                    if (!event.player.f_19853_.m_5776_()) {
                        if (Incapacitated.devMode) {
                            if (h.getJumpCount() == 2) {
                                AbstractedIncapacitation.revive(event.player);
                            }
                        } else {
                            ArrayList playerEntities = (ArrayList)event.player.f_19853_.m_45976_(Player.class, event.player.m_20191_().m_82400_(3.0));
                            boolean reviving = false;
                            Player revivingPlayer = null;
                            for (Player player : playerEntities) {
                                AtomicBoolean isdown = new AtomicBoolean(false);
                                AtomicBoolean targetIsDown = new AtomicBoolean(false);
                                player.getCapability(PlayerCapability.INSTANCE).ifPresent(j -> isdown.set(j.getIsIncapacitated()));
                                event.player.getCapability(PlayerCapability.INSTANCE).ifPresent(j -> targetIsDown.set(j.getIsIncapacitated()));
                                if (!player.m_6047_() || !targetIsDown.get() || isdown.get()) continue;
                                reviving = true;
                                revivingPlayer = player;
                                break;
                            }
                            if (reviving) {
                                if (h.downReviveCount()) {
                                    AbstractedIncapacitation.revive(event.player);
                                } else {
                                    event.player.m_5661_((Component)Component.m_237110_((String)"message.downindicator.reviving", (Object[])new Object[]{h.getReviveCount() / 20}).m_130940_(ChatFormatting.GREEN), true);
                                    revivingPlayer.m_5661_((Component)Component.m_237110_((String)"message.reviveindicator.reviving", (Object[])new Object[]{event.player.m_6302_(), h.getReviveCount() / 20}).m_130940_(ChatFormatting.GREEN), true);
                                }
                            } else {
                                if (h.countTicksUntilDeath()) {
                                    event.player.m_6469_(h.getSourceOfDeath(event.player.f_19853_), event.player.m_21233_() * 10.0f);
                                    event.player.setForcedPose(null);
                                    h.setReviveCount(Incapacitated.config.REVIVETICKS.get());
                                    h.resetGiveUpJumps();
                                    event.player.m_21195_(MobEffects.f_19619_);
                                    h.setIsIncapacitated(false);
                                    IncapacitationMessenger.sendTo(new IncapPacket(event.player.m_19879_(), false, (short)h.getDownsUntilDeath()), event.player);
                                } else if (h.getTicksUntilDeath() % 20 == 0) {
                                    event.player.m_5661_((Component)Component.m_237110_((String)"message.downindicator.norevive", (Object[])new Object[]{"/incap die", Float.valueOf((float)h.getTicksUntilDeath() / 20.0f)}).m_130940_(ChatFormatting.RED), true);
                                }
                                if (h.getReviveCount() != Incapacitated.config.REVIVETICKS.get().intValue()) {
                                    h.setReviveCount(Incapacitated.config.REVIVETICKS.get());
                                }
                            }
                        }
                    }
                } else if (event.player.getForcedPose() != null) {
                    event.player.setForcedPose(null);
                }
            });
        }
    }

    @SubscribeEvent
    public static void playerRested(PlayerWakeUpEvent event) {
        if (!event.updateLevel() && !event.wakeImmediately() && Incapacitated.regenerating.booleanValue()) {
            event.getEntity().getCapability(PlayerCapability.INSTANCE).ifPresent(h -> {
                if (h.getDownsUntilDeath() < Incapacitated.config.DOWNCOUNT.get()) {
                    AbstractedIncapacitation.setDownCount(event.getEntity(), (short)(h.getDownsUntilDeath() + 1));
                }
            });
        }
    }

    @SubscribeEvent
    public static void playerEat(LivingEntityUseItemEvent.Finish event) {
        if (event.getEntity() instanceof Player && !event.getEntity().f_19853_.m_5776_()) {
            Item item = event.getItem().m_41720_();
            Player player = (Player)event.getEntity();
            player.getCapability(PlayerCapability.INSTANCE).ifPresent(h -> {
                if (Incapacitated.HealingFoods.contains(item.toString())) {
                    h.setDownsUntilDeath(Incapacitated.config.DOWNCOUNT.get());
                    h.setTicksUntilDeath(Incapacitated.config.DOWNTICKS.get());
                    IncapacitationMessenger.sendTo(new IncapPacket(player.m_19879_(), h.getIsIncapacitated(), (short)h.getDownsUntilDeath()), player);
                }
                if (h.getIsIncapacitated()) {
                    if (Incapacitated.ReviveFoods.contains(item.toString())) {
                        h.setIsIncapacitated(false);
                        player.setForcedPose(null);
                        h.setReviveCount(Incapacitated.config.REVIVETICKS.get());
                        h.resetGiveUpJumps();
                        h.setDownsUntilDeath(Incapacitated.config.DOWNCOUNT.get());
                        player.m_21195_(MobEffects.f_19619_);
                        h.setTicksUntilDeath(Incapacitated.config.DOWNTICKS.get());
                        IncapacitationMessenger.sendTo(new IncapPacket(player.m_19879_(), false, (short)h.getDownsUntilDeath()), player);
                        player.m_21153_(player.m_21233_() / 3.0f);
                        player.f_19853_.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)SoundEvents.f_12216_.m_203334_(), SoundSource.PLAYERS, 1.0f, 1.0f);
                    }
                } else if (Incapacitated.ReviveFoods.contains(item.toString())) {
                    h.setDownsUntilDeath(Incapacitated.config.DOWNCOUNT.get());
                    h.setTicksUntilDeath(Incapacitated.config.DOWNTICKS.get());
                }
            });
        }
    }

    public static void broadcast(MinecraftServer server, Component translationTextComponent) {
        server.m_6846_().m_240416_(translationTextComponent, false);
    }
}

