/*
 * Decompiled with CFR 0.152.
 */
package com.cartoonishvillain.incapacitated.components;

import com.cartoonishvillain.incapacitated.BleedOutDamage;
import com.cartoonishvillain.incapacitated.Incapacitated;
import com.cartoonishvillain.incapacitated.components.ComponentStarter;
import com.cartoonishvillain.incapacitated.mixin.DamageSourceInvoker;
import dev.onyxstudios.cca.api.v3.component.ComponentV3;
import dev.onyxstudios.cca.api.v3.component.sync.AutoSyncedComponent;
import net.minecraft.class_1282;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_3222;

public class PlayerComponent
implements ComponentV3,
AutoSyncedComponent {
    private final Object provider;
    protected boolean incapacitated = false;
    protected int ticksUntilDeath;
    protected int downsUntilDeath;
    protected int giveUpJumps;
    protected int reviveCounter;
    protected int jumpDelay;
    private class_1282 originalSource;

    public PlayerComponent(Object provider) {
        this.ticksUntilDeath = Incapacitated.config.config.DOWNTICKS;
        this.downsUntilDeath = Incapacitated.config.config.DOWNCOUNT;
        this.giveUpJumps = 3;
        this.reviveCounter = Incapacitated.config.config.REVIVETICKS;
        this.jumpDelay = 0;
        this.provider = provider;
    }

    public boolean getIsIncapacitated() {
        return this.incapacitated;
    }

    public void setIsIncapacitated(boolean isIncapacitated) {
        this.incapacitated = isIncapacitated;
        ComponentStarter.PLAYERCOMPONENTINSTANCE.sync(this.provider);
    }

    public void sync() {
        ComponentStarter.PLAYERCOMPONENTINSTANCE.sync(this.provider);
    }

    public int getTicksUntilDeath() {
        return this.ticksUntilDeath;
    }

    public boolean countTicksUntilDeath() {
        --this.ticksUntilDeath;
        return this.ticksUntilDeath <= 0;
    }

    public void setTicksUntilDeath(int ticks) {
        this.ticksUntilDeath = ticks;
    }

    public int getDownsUntilDeath() {
        return this.downsUntilDeath;
    }

    public void setDownsUntilDeath(int downs) {
        this.downsUntilDeath = downs;
    }

    public boolean giveUpJumpCount() {
        --this.giveUpJumps;
        return this.giveUpJumps <= 0;
    }

    public void resetGiveUpJumps() {
        this.giveUpJumps = 3;
    }

    public int getJumpCount() {
        return this.giveUpJumps;
    }

    public void setJumpCount(int jumps) {
        this.giveUpJumps = jumps;
    }

    public boolean downReviveCount() {
        --this.reviveCounter;
        return this.reviveCounter <= 0;
    }

    public int getReviveCount() {
        return this.reviveCounter;
    }

    public void setReviveCount(int count) {
        this.reviveCounter = count;
    }

    public int getJumpDelay() {
        return this.jumpDelay;
    }

    public void setJumpDelay(int delay) {
        this.jumpDelay = delay;
    }

    public void countDelay() {
        if (this.jumpDelay > 0) {
            --this.jumpDelay;
        } else if (this.jumpDelay < 0) {
            this.jumpDelay = 0;
        }
    }

    public class_1282 getSourceOfDeath() {
        return this.originalSource != null ? ((DamageSourceInvoker)this.originalSource).IncapacitatedInvokeBypassArmor() : ((DamageSourceInvoker)((Object)new BleedOutDamage(class_1282.field_5849))).IncapacitatedInvokeBypassArmor();
    }

    public void setSourceOfDeath(class_1282 causeOfDeath) {
        this.originalSource = new BleedOutDamage(causeOfDeath);
    }

    public void readFromNbt(class_2487 tag) {
        this.incapacitated = tag.method_10577("incapacitation");
        this.ticksUntilDeath = tag.method_10550("incapTimer");
        this.downsUntilDeath = tag.method_10550("incapCounter");
        this.giveUpJumps = tag.method_10550("jumpCounter");
    }

    public void writeToNbt(class_2487 tag) {
        tag.method_10556("incapacitation", this.incapacitated);
        tag.method_10569("incapTimer", this.ticksUntilDeath);
        tag.method_10569("incapCounter", this.downsUntilDeath);
        tag.method_10569("jumpCounter", this.giveUpJumps);
    }

    public void writeSyncPacket(class_2540 buf, class_3222 recipient) {
        buf.writeBoolean(this.getIsIncapacitated());
    }

    public void applySyncPacket(class_2540 buf) {
        this.setIsIncapacitated(buf.readBoolean());
    }
}

