/*
 * Decompiled with CFR 0.152.
 */
package com.cartoonishvillain.incapacitated;

import com.cartoonishvillain.incapacitated.components.ComponentStarter;
import com.cartoonishvillain.incapacitated.components.PlayerComponent;
import com.cartoonishvillain.incapacitated.config.IncapacitationConfig;
import java.util.ArrayList;
import java.util.List;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_1282;
import net.minecraft.class_151;
import net.minecraft.class_2960;
import net.minecraft.class_3244;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Incapacitated
implements ModInitializer {
    public static final Logger LOGGER = LogManager.getLogger((String)"incapacitated");
    public static IncapacitationConfig config;
    public static ArrayList<String> ReviveFoods;
    public static ArrayList<String> HealingFoods;
    public static ArrayList<String> instantKillDamageSourcesMessageID;

    public void onInitialize() {
        AutoConfig.register(IncapacitationConfig.class, JanksonConfigSerializer::new);
        config = (IncapacitationConfig)AutoConfig.getConfigHolder(IncapacitationConfig.class).getConfig();
        instantKillDamageSourcesMessageID = new ArrayList<String>(List.of("bleedout", class_1282.field_5849.field_5841, class_1282.field_5863.field_5841, class_1282.field_5850.field_5841));
        ReviveFoods = this.getFoodForReviving();
        HealingFoods = this.getFoodForHealing();
        ServerPlayConnectionEvents.JOIN.register((Object)JoinListener.getInstance());
    }

    private ArrayList<String> getFoodForReviving() {
        String FoodList = Incapacitated.config.config.REVIVEFOODS;
        String[] reviveFoods = FoodList.split(",");
        ArrayList<String> reviveFoodList = new ArrayList<String>();
        try {
            for (String string : reviveFoods) {
                String food = new class_2960(string).method_12832();
                reviveFoodList.add(food);
            }
        }
        catch (class_151 e) {
            LOGGER.error("Incapacitation: Revive foods not parsed. Non [a-z0-9_.-] character in config! Using default...");
            return new ArrayList<String>(List.of("enchanted_golden_apple"));
        }
        return reviveFoodList;
    }

    private ArrayList<String> getFoodForHealing() {
        String FoodList = Incapacitated.config.config.HEALINGFOODS;
        String[] healFoods = FoodList.split(",");
        ArrayList<String> healFoodList = new ArrayList<String>();
        try {
            for (String string : healFoods) {
                String food = new class_2960(string).method_12832();
                healFoodList.add(food);
            }
        }
        catch (class_151 e) {
            LOGGER.error("Incapacitation: Healing foods not parsed. Non [a-z0-9_.-] character in config! Using default...");
            return new ArrayList<String>(List.of("golden_apple"));
        }
        return healFoodList;
    }

    public static class JoinListener
    implements ServerPlayConnectionEvents.Join {
        private static final JoinListener INSTANCE = new JoinListener();

        public void onPlayReady(class_3244 handler, PacketSender sender, MinecraftServer server) {
            PlayerComponent playerComponent = (PlayerComponent)ComponentStarter.PLAYERCOMPONENTINSTANCE.get((Object)handler.field_14140);
            playerComponent.sync();
        }

        public static JoinListener getInstance() {
            return INSTANCE;
        }
    }
}

