/*
 * Decompiled with CFR 0.152.
 */
package com.cartoonishvillain.incapacitated;

import com.cartoonishvillain.incapacitated.IncapEffects;
import com.cartoonishvillain.incapacitated.config.ClientConfig;
import com.cartoonishvillain.incapacitated.config.CommonConfig;
import com.cartoonishvillain.incapacitated.config.ConfigHelper;
import com.cartoonishvillain.incapacitated.networking.IncapacitationMessenger;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ResourceLocationException;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="incapacitated")
public class Incapacitated {
    public static final String MODID = "incapacitated";
    private static final Logger LOGGER = LogManager.getLogger();
    public static CommonConfig config;
    public static ClientConfig clientConfig;
    public static boolean devMode;
    public static ArrayList<String> ReviveFoods;
    public static ArrayList<String> HealingFoods;
    public static ArrayList<String> instantKillDamageSourcesMessageID;
    public static Boolean merciful;
    public static Boolean hunter;
    public static Boolean slow;
    public static Boolean weakened;
    public static Boolean regenerating;
    public static Boolean unlimitedDowns;
    public static Boolean downLogging;

    public Incapacitated() {
        IncapacitationMessenger.register();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuff);
        config = ConfigHelper.register(ModConfig.Type.COMMON, CommonConfig::new);
        clientConfig = ConfigHelper.register(ModConfig.Type.CLIENT, ClientConfig::new);
        instantKillDamageSourcesMessageID = new ArrayList<String>(List.of("bleedout", DamageSource.f_19317_.f_19326_, DamageSource.f_19308_.f_19326_, DamageSource.f_19320_.f_19326_));
        IncapEffects.init();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void setup(FMLCommonSetupEvent event) {
        HealingFoods = this.getFoodForHealing();
        ReviveFoods = this.getFoodForReviving();
        merciful = Incapacitated.config.MERCIFUL.get();
        hunter = Incapacitated.config.HUNTER.get();
        slow = Incapacitated.config.SLOW.get();
        weakened = Incapacitated.config.WEAKENED.get();
        regenerating = Incapacitated.config.REGENERATING.get();
        unlimitedDowns = Incapacitated.config.UNLIMITEDDOWNS.get();
        downLogging = Incapacitated.config.DOWNLOGGING.get();
    }

    private void doClientStuff(FMLClientSetupEvent event) {
    }

    private ArrayList<String> getFoodForReviving() {
        String FoodList = Incapacitated.config.REVIVEFOODS.get();
        String[] reviveFoods = FoodList.split(",");
        ArrayList<String> reviveFoodList = new ArrayList<String>();
        try {
            for (String string : reviveFoods) {
                String food = new ResourceLocation(string).m_135815_();
                reviveFoodList.add(food);
            }
        }
        catch (ResourceLocationException e) {
            LOGGER.error("Incapacitation: Revive foods not parsed. Non [a-z0-9_.-] character in config! Using default...");
            return new ArrayList<String>(List.of("enchanted_golden_apple"));
        }
        return reviveFoodList;
    }

    private ArrayList<String> getFoodForHealing() {
        String FoodList = Incapacitated.config.HEALINGFOODS.get();
        String[] healFoods = FoodList.split(",");
        ArrayList<String> healFoodList = new ArrayList<String>();
        try {
            for (String string : healFoods) {
                String food = new ResourceLocation(string).m_135815_();
                healFoodList.add(food);
            }
        }
        catch (ResourceLocationException e) {
            LOGGER.error("Incapacitation: Healing foods not parsed. Non [a-z0-9_.-] character in config! Using default...");
            return new ArrayList<String>(List.of("golden_apple"));
        }
        return healFoodList;
    }

    static {
        devMode = false;
        merciful = false;
        hunter = false;
        slow = false;
        weakened = false;
        regenerating = false;
        unlimitedDowns = false;
        downLogging = false;
    }
}

