/*
 * Decompiled with CFR 0.152.
 */
package com.cartoonishvillain.incapacitated.networking;

import com.cartoonishvillain.incapacitated.Incapacitated;
import com.cartoonishvillain.incapacitated.capability.PlayerCapability;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public class IncapPacket {
    private int ID;
    private Boolean isIncapacitated;
    private short downCount;

    public IncapPacket(int id, boolean isIncapacitated, short downCount) {
        this.ID = id;
        this.isIncapacitated = isIncapacitated;
        this.downCount = downCount;
    }

    public IncapPacket(FriendlyByteBuf packetBuffer) {
        this.ID = packetBuffer.readInt();
        this.isIncapacitated = packetBuffer.readBoolean();
        this.downCount = packetBuffer.readShort();
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.ID);
        buffer.writeBoolean(this.isIncapacitated.booleanValue());
        buffer.writeShort((int)this.downCount);
    }

    public static IncapPacket decode(FriendlyByteBuf buf) {
        return new IncapPacket(buf);
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            Entity entity = Minecraft.m_91087_().f_91073_.m_6815_(this.ID);
            if (entity != null) {
                entity.getCapability(PlayerCapability.INSTANCE).ifPresent(h -> {
                    h.setIsIncapacitated(this.isIncapacitated);
                    h.setDownsUntilDeath(this.downCount);
                    if (Incapacitated.clientConfig.GRAYSCREEN.get().booleanValue()) {
                        if (this.downCount <= 0) {
                            ResourceLocation resourceLocation = new ResourceLocation("shaders/post/desaturate.json");
                            Minecraft.m_91087_().f_91063_.m_109128_(resourceLocation);
                        } else {
                            Minecraft.m_91087_().f_91063_.m_109086_();
                        }
                    }
                });
            }
        });
        context.setPacketHandled(true);
    }
}

