/*
 * Decompiled with CFR 0.152.
 */
package com.plummetstudios.insatiable.common.item;

import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.BundleTooltip;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class LunchBox
extends Item {
    private static final String TAG_ITEMS = "Items";
    public static final int MAX_WEIGHT = 320;
    private static final int BUNDLE_IN_BUNDLE_WEIGHT = 4;
    private static final int BAR_COLOR = Mth.m_14159_((float)0.4f, (float)0.4f, (float)1.0f);

    public LunchBox(Item.Properties p_150726_) {
        super(p_150726_);
    }

    public static float getFullnessDisplay(ItemStack p_150767_) {
        return (float)LunchBox.getContentWeight(p_150767_) / 320.0f;
    }

    public boolean m_142207_(ItemStack p_150733_, Slot p_150734_, ClickAction p_150735_, Player p_150736_) {
        if (p_150735_ != ClickAction.SECONDARY) {
            return false;
        }
        ItemStack itemstack = p_150734_.m_7993_();
        if (itemstack.m_41619_()) {
            this.playRemoveOneSound((Entity)p_150736_);
            LunchBox.removeOne(p_150733_).ifPresent(p_150740_ -> LunchBox.add(p_150733_, p_150734_.m_150659_(p_150740_)));
        } else if (itemstack.m_41720_().m_142095_() && p_150734_.m_7993_().m_41614_() || itemstack.m_41720_() == Items.f_42502_) {
            int i = (320 - LunchBox.getContentWeight(p_150733_)) / LunchBox.getWeight(itemstack);
            int j = LunchBox.add(p_150733_, p_150734_.m_150647_(itemstack.m_41613_(), i, p_150736_));
            if (j > 0) {
                this.playInsertSound((Entity)p_150736_);
            }
        }
        return true;
    }

    public boolean m_142305_(ItemStack p_150742_, ItemStack p_150743_, Slot p_150744_, ClickAction p_150745_, Player p_150746_, SlotAccess p_150747_) {
        if (p_150745_ == ClickAction.SECONDARY && p_150744_.m_150651_(p_150746_)) {
            if (p_150743_.m_41619_()) {
                LunchBox.removeOne(p_150742_).ifPresent(p_186347_ -> {
                    this.playRemoveOneSound((Entity)p_150746_);
                    p_150747_.m_142104_(p_186347_);
                });
            } else {
                int i = LunchBox.add(p_150742_, p_150743_);
                if (i > 0) {
                    this.playInsertSound((Entity)p_150746_);
                    p_150743_.m_41774_(i);
                }
            }
            return true;
        }
        return false;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level p_150760_, Player p_150761_, InteractionHand p_150762_) {
        ItemStack itemstack = p_150761_.m_21120_(p_150762_);
        if (LunchBox.dropContents(itemstack, p_150761_)) {
            this.playDropContentsSound((Entity)p_150761_);
            p_150761_.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            return InteractionResultHolder.m_19092_((Object)itemstack, (boolean)p_150760_.m_5776_());
        }
        return InteractionResultHolder.m_19100_((Object)itemstack);
    }

    public boolean m_142522_(ItemStack p_150769_) {
        return LunchBox.getContentWeight(p_150769_) > 0;
    }

    public int m_142158_(ItemStack p_150771_) {
        return Math.min(1 + 12 * LunchBox.getContentWeight(p_150771_) / 320, 13);
    }

    public int m_142159_(ItemStack p_150773_) {
        return BAR_COLOR;
    }

    private static int add(ItemStack p_150764_, ItemStack p_150765_) {
        if (!p_150765_.m_41619_() && p_150765_.m_41720_().m_142095_()) {
            CompoundTag compoundtag = p_150764_.m_41784_();
            if (!compoundtag.m_128441_(TAG_ITEMS)) {
                compoundtag.m_128365_(TAG_ITEMS, (Tag)new ListTag());
            }
            int i = LunchBox.getContentWeight(p_150764_);
            int j = LunchBox.getWeight(p_150765_);
            int k = Math.min(p_150765_.m_41613_(), (320 - i) / j);
            if (k == 0) {
                return 0;
            }
            ListTag listtag = compoundtag.m_128437_(TAG_ITEMS, 10);
            Optional<CompoundTag> optional = LunchBox.getMatchingItem(p_150765_, listtag);
            if (optional.isPresent()) {
                CompoundTag compoundtag1 = optional.get();
                ItemStack itemstack = ItemStack.m_41712_((CompoundTag)compoundtag1);
                itemstack.m_41769_(k);
                itemstack.m_41739_(compoundtag1);
                listtag.remove((Object)compoundtag1);
                listtag.add(0, (Tag)compoundtag1);
            } else {
                ItemStack itemstack1 = p_150765_.m_41777_();
                itemstack1.m_41764_(k);
                CompoundTag compoundtag2 = new CompoundTag();
                itemstack1.m_41739_(compoundtag2);
                listtag.add(0, (Tag)compoundtag2);
            }
            return k;
        }
        return 0;
    }

    private static Optional<CompoundTag> getMatchingItem(ItemStack p_150757_, ListTag p_150758_) {
        if (p_150757_.m_41613_() >= 64) {
            return Optional.empty();
        }
        return p_150757_.m_150930_(Items.f_151058_) ? Optional.empty() : p_150758_.stream().filter(CompoundTag.class::isInstance).map(CompoundTag.class::cast).filter(p_186350_ -> ItemStack.m_150942_((ItemStack)ItemStack.m_41712_((CompoundTag)p_186350_), (ItemStack)p_150757_)).findFirst();
    }

    private static int getWeight(ItemStack p_150777_) {
        CompoundTag compoundtag;
        if (p_150777_.m_150930_(Items.f_151058_)) {
            return 4 + LunchBox.getContentWeight(p_150777_);
        }
        if ((p_150777_.m_150930_(Items.f_42786_) || p_150777_.m_150930_(Items.f_42785_)) && p_150777_.m_41782_() && (compoundtag = BlockItem.m_186336_((ItemStack)p_150777_)) != null && !compoundtag.m_128437_("Bees", 10).isEmpty()) {
            return 320;
        }
        return 1;
    }

    private static int getContentWeight(ItemStack p_150779_) {
        return LunchBox.getContents(p_150779_).mapToInt(p_186356_ -> LunchBox.getWeight(p_186356_) * p_186356_.m_41613_()).sum();
    }

    private static Optional<ItemStack> removeOne(ItemStack p_150781_) {
        CompoundTag compoundtag = p_150781_.m_41784_();
        if (!compoundtag.m_128441_(TAG_ITEMS)) {
            return Optional.empty();
        }
        ListTag listtag = compoundtag.m_128437_(TAG_ITEMS, 10);
        if (listtag.isEmpty()) {
            return Optional.empty();
        }
        boolean i = false;
        CompoundTag compoundtag1 = listtag.m_128728_(0);
        ItemStack itemstack = ItemStack.m_41712_((CompoundTag)compoundtag1);
        listtag.remove(0);
        if (listtag.isEmpty()) {
            p_150781_.m_41749_(TAG_ITEMS);
        }
        return Optional.of(itemstack);
    }

    private static boolean dropContents(ItemStack p_150730_, Player p_150731_) {
        CompoundTag compoundtag = p_150730_.m_41784_();
        if (!compoundtag.m_128441_(TAG_ITEMS)) {
            return false;
        }
        if (p_150731_ instanceof ServerPlayer) {
            ListTag listtag = compoundtag.m_128437_(TAG_ITEMS, 10);
            for (int i = 0; i < listtag.size(); ++i) {
                CompoundTag compoundtag1 = listtag.m_128728_(i);
                ItemStack itemstack = ItemStack.m_41712_((CompoundTag)compoundtag1);
                p_150731_.m_36176_(itemstack, true);
            }
        }
        p_150730_.m_41749_(TAG_ITEMS);
        return true;
    }

    private static Stream<ItemStack> getContents(ItemStack p_150783_) {
        CompoundTag compoundtag = p_150783_.m_41783_();
        if (compoundtag == null) {
            return Stream.empty();
        }
        ListTag listtag = compoundtag.m_128437_(TAG_ITEMS, 10);
        return listtag.stream().map(CompoundTag.class::cast).map(ItemStack::m_41712_);
    }

    public Optional<TooltipComponent> m_142422_(ItemStack p_150775_) {
        NonNullList nonnulllist = NonNullList.m_122779_();
        LunchBox.getContents(p_150775_).forEach(arg_0 -> nonnulllist.add(arg_0));
        return Optional.of(new BundleTooltip(nonnulllist, LunchBox.getContentWeight(p_150775_)));
    }

    public void m_7373_(ItemStack p_150749_, Level p_150750_, List<Component> p_150751_, TooltipFlag p_150752_) {
        p_150751_.add((Component)Component.m_237110_((String)"item.minecraft.bundle.fullness", (Object[])new Object[]{LunchBox.getContentWeight(p_150749_), 320}).m_130940_(ChatFormatting.GRAY));
    }

    public void m_142023_(ItemEntity p_150728_) {
        ItemUtils.m_150952_((ItemEntity)p_150728_, LunchBox.getContents(p_150728_.m_32055_()));
    }

    private void playRemoveOneSound(Entity p_186343_) {
        p_186343_.m_5496_(SoundEvents.f_11677_, 0.8f, 0.8f + p_186343_.m_9236_().m_213780_().m_188501_() * 0.4f);
    }

    private void playInsertSound(Entity p_186352_) {
        p_186352_.m_5496_(SoundEvents.f_11677_, 0.8f, 0.8f + p_186352_.m_9236_().m_213780_().m_188501_() * 0.4f);
    }

    private void playDropContentsSound(Entity p_186354_) {
        p_186354_.m_5496_(SoundEvents.f_184214_, 0.8f, 0.8f + p_186354_.m_9236_().m_213780_().m_188501_() * 0.4f);
    }
}

