/*
 * Decompiled with CFR 0.152.
 */
package com.plummetstudios.insatiable.common.item;

import com.plummetstudios.insatiable.client.model.armor.PeltHelmetModel;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModArmorItem
extends ArmorItem {
    private static final String HELMET_TEXTURE = "insatiable:textures/entity/pelt_helmet.png";
    private static final String TEXTURE = "insatiable:textures/models/armor/pelt_layer_1.png";
    private static final String LEGS_TEXTURE = "insatiable:textures/models/armor/pelt_layer_2.png";
    private static final int TICK_COOLDOWN = 10;
    private long lastTickTime = 0L;

    public ModArmorItem(ArmorMaterial material, EquipmentSlot slot, Item.Properties settings) {
        super(material, slot, settings);
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        return switch (slot) {
            case EquipmentSlot.HEAD -> HELMET_TEXTURE;
            case EquipmentSlot.LEGS -> LEGS_TEXTURE;
            default -> TEXTURE;
        };
    }

    public void m_7373_(ItemStack p_41421_, @Nullable Level p_41422_, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.insatiable.pelt_helmet.tooltip").m_130940_(ChatFormatting.GRAY));
    }

    public void onArmorTick(ItemStack stack, Level world, Player player) {
        long currentTime = world.m_46467_();
        if (currentTime - this.lastTickTime < 10L) {
            return;
        }
        this.lastTickTime = currentTime;
        List list = player.f_19853_.m_45976_(Animal.class, player.m_20191_().m_82377_(8.0, 4.0, 8.0));
        for (Animal e : list) {
            e.m_6710_(null);
            e.m_6703_(null);
            Vec3 vec = LandRandomPos.m_148521_((PathfinderMob)e, (int)15, (int)7, (Vec3)player.m_20182_());
            if (vec == null) continue;
            e.m_21573_().m_26519_(vec.f_82479_, vec.f_82480_, vec.f_82481_, 1.3);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        super.initializeClient(consumer);
        consumer.accept(new IClientItemExtensions(){

            @NotNull
            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                return ModArmorItem.this.f_40377_ == EquipmentSlot.HEAD ? new PeltHelmetModel(PeltHelmetModel.createBodyLayer().m_171564_()) : super.getHumanoidArmorModel(livingEntity, itemStack, equipmentSlot, original);
            }
        });
    }
}

