/*
 * Decompiled with CFR 0.152.
 */
package com.plummetstudios.insatiable.loot;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;

public class LootInjector {

    public static class LootInjectorModifier
    extends LootModifier {
        public static final Supplier<Codec<LootInjectorModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> LootInjectorModifier.codecStart((RecordCodecBuilder.Instance)inst).and(inst.group((App)ResourceLocation.f_135803_.fieldOf("loot_table_id").forGetter(m -> m.table), (App)Codec.BOOL.fieldOf("allow_recursive_glms").forGetter(m -> m.allowRecursiveGlms))).apply((Applicative)inst, LootInjectorModifier::new)));
        private final boolean allowRecursiveGlms;
        private final ResourceLocation table;

        public LootInjectorModifier(LootItemCondition[] conditionsIn, ResourceLocation tableIn, boolean recursiveGlms) {
            super(conditionsIn);
            this.table = tableIn;
            this.allowRecursiveGlms = recursiveGlms;
        }

        protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
            LootContext.Builder builder = new LootContext.Builder(context.m_78952_()).m_230911_(context.m_230907_());
            LootTable loottable = context.m_78952_().m_7654_().m_129898_().m_79217_(this.table);
            generatedLoot.addAll((ObjectList)loottable.m_230922_(builder.m_78975_(LootContextParamSets.f_81410_)));
            return generatedLoot;
        }

        public Codec<? extends IGlobalLootModifier> codec() {
            return CODEC.get();
        }
    }
}

