/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.instrumentalmobs.config;

import com.mrbysco.instrumentalmobs.InstrumentalMobs;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public class InstrumentalConfig {
    public static final ForgeConfigSpec commonSpec;
    public static final Common COMMON;

    @SubscribeEvent
    public static void onLoad(ModConfig.Loading configEvent) {
        InstrumentalMobs.LOGGER.debug("Loaded Instrumental Mobs' config file {}", (Object)configEvent.getConfig().getFileName());
    }

    @SubscribeEvent
    public static void onFileChange(ModConfig.Reloading configEvent) {
        InstrumentalMobs.LOGGER.debug("Instrumental Mobs' config just got changed on the file system!");
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        commonSpec = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.BooleanValue mobsReact;
        public final ForgeConfigSpec.DoubleValue instrumentRange;
        public final ForgeConfigSpec.DoubleValue soundDamageChance;

        Common(ForgeConfigSpec.Builder builder) {
            builder.comment("Server settings").push("Server");
            this.mobsReact = builder.comment("Mobs react upon usage of the instruments [default: true]").define("mobsReact", true);
            this.instrumentRange = builder.comment("The area in which the instruments react with mobs. [default: 10.0D]").defineInRange("instrumentRange", 10.0, 0.01, 128.0);
            this.soundDamageChance = builder.comment("The chance of instrument sounds damaging mobs after pushing. [default: 0.35D]").defineInRange("soundDamageChance", 0.35, 0.001, 1.0);
            builder.pop();
        }
    }
}

