/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.instrumentalmobs.entities;

import com.mrbysco.instrumentalmobs.entities.projectiles.EntitySoundWaves;
import com.mrbysco.instrumentalmobs.init.InstrumentalRegistry;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.monster.GhastEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class MicrophoneGhastEntity
extends GhastEntity {
    private static final DataParameter<Boolean> SINGING = EntityDataManager.func_187226_a(MicrophoneGhastEntity.class, (IDataSerializer)DataSerializers.field_187198_h);

    public MicrophoneGhastEntity(EntityType<? extends MicrophoneGhastEntity> type, World worldIn) {
        super(type, worldIn);
        this.func_184201_a(EquipmentSlotType.HEAD, new ItemStack((IItemProvider)InstrumentalRegistry.microphone.get()));
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(5, (Goal)new RandomFlyGoal(this));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookAroundGoal(this));
        this.field_70714_bg.func_75776_a(7, (Goal)new VoiceAttackGoal(this));
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 10, true, false, p_213812_1_ -> Math.abs(p_213812_1_.func_226278_cu_() - this.func_226278_cu_()) <= 4.0));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(SINGING, (Object)false);
    }

    public void setSinging(boolean isSinging) {
        this.func_184212_Q().func_187227_b(SINGING, (Object)isSinging);
    }

    public boolean isSinging() {
        return (Boolean)this.func_184212_Q().func_187225_a(SINGING);
    }

    public static boolean canSpawnHere(EntityType<MicrophoneGhastEntity> p_223368_0_, IWorld p_223368_1_, SpawnReason reason, BlockPos p_223368_3_, Random p_223368_4_) {
        return p_223368_1_.func_175659_aa() != Difficulty.PEACEFUL && p_223368_4_.nextInt(20) == 0 && MicrophoneGhastEntity.func_223315_a(p_223368_0_, (IWorld)p_223368_1_, (SpawnReason)reason, (BlockPos)p_223368_3_, (Random)p_223368_4_);
    }

    static class RandomFlyGoal
    extends Goal {
        private final MicrophoneGhastEntity parentEntity;

        public RandomFlyGoal(MicrophoneGhastEntity ghast) {
            this.parentEntity = ghast;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            double d2;
            double d1;
            MovementController movementcontroller = this.parentEntity.func_70605_aq();
            if (!movementcontroller.func_75640_a()) {
                return true;
            }
            double d0 = movementcontroller.func_179917_d() - this.parentEntity.func_226277_ct_();
            double d3 = d0 * d0 + (d1 = movementcontroller.func_179919_e() - this.parentEntity.func_226278_cu_()) * d1 + (d2 = movementcontroller.func_179918_f() - this.parentEntity.func_226281_cx_()) * d2;
            return d3 < 1.0 || d3 > 3600.0;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75249_e() {
            Random random = this.parentEntity.func_70681_au();
            double d0 = this.parentEntity.func_226277_ct_() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            double d1 = this.parentEntity.func_226278_cu_() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            double d2 = this.parentEntity.func_226281_cx_() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            this.parentEntity.func_70605_aq().func_75642_a(d0, d1, d2, 1.0);
        }
    }

    static class LookAroundGoal
    extends Goal {
        private final MicrophoneGhastEntity parentEntity;

        public LookAroundGoal(MicrophoneGhastEntity ghast) {
            this.parentEntity = ghast;
            this.func_220684_a(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            return true;
        }

        public void func_75246_d() {
            if (this.parentEntity.func_70638_az() == null) {
                Vector3d vector3d = this.parentEntity.func_213322_ci();
                this.parentEntity.field_70761_aq = this.parentEntity.field_70177_z = -((float)MathHelper.func_181159_b((double)vector3d.field_72450_a, (double)vector3d.field_72449_c)) * 57.295776f;
            } else {
                LivingEntity livingentity = this.parentEntity.func_70638_az();
                double d0 = 64.0;
                if (livingentity.func_70068_e((Entity)this.parentEntity) < 4096.0) {
                    double d1 = livingentity.func_226277_ct_() - this.parentEntity.func_226277_ct_();
                    double d2 = livingentity.func_226281_cx_() - this.parentEntity.func_226281_cx_();
                    this.parentEntity.field_70761_aq = this.parentEntity.field_70177_z = -((float)MathHelper.func_181159_b((double)d1, (double)d2)) * 57.295776f;
                }
            }
        }
    }

    static class VoiceAttackGoal
    extends Goal {
        private final MicrophoneGhastEntity parentEntity;
        public int attackTimer;

        public VoiceAttackGoal(MicrophoneGhastEntity ghast) {
            this.parentEntity = ghast;
        }

        public boolean func_75250_a() {
            return this.parentEntity.func_70638_az() != null;
        }

        public void func_75249_e() {
            this.attackTimer = 0;
            this.parentEntity.setSinging(true);
        }

        public void func_75251_c() {
            this.parentEntity.func_175454_a(false);
            this.parentEntity.setSinging(false);
        }

        public void func_75246_d() {
            LivingEntity livingentity = this.parentEntity.func_70638_az();
            double d0 = 64.0;
            if (livingentity.func_70068_e((Entity)this.parentEntity) < 4096.0 && this.parentEntity.func_70685_l((Entity)livingentity)) {
                World world = this.parentEntity.field_70170_p;
                ++this.attackTimer;
                if (this.attackTimer == 10 && !this.parentEntity.func_174814_R()) {
                    world.func_217378_a((PlayerEntity)null, 1015, this.parentEntity.func_233580_cy_(), 0);
                }
                if (this.attackTimer == 20) {
                    double d1 = 4.0;
                    Vector3d vector3d = this.parentEntity.func_70676_i(1.0f);
                    double d2 = livingentity.func_226277_ct_() - (this.parentEntity.func_226277_ct_() + vector3d.field_72450_a * 4.0);
                    double d3 = livingentity.func_226283_e_(0.5) - (0.5 + this.parentEntity.func_226283_e_(0.5));
                    double d4 = livingentity.func_226281_cx_() - (this.parentEntity.func_226281_cx_() + vector3d.field_72449_c * 4.0);
                    if (!this.parentEntity.func_174814_R()) {
                        world.func_217378_a((PlayerEntity)null, 1016, this.parentEntity.func_233580_cy_(), 0);
                    }
                    EntitySoundWaves entitysoundwave = new EntitySoundWaves(world, (LivingEntity)this.parentEntity, d2, d3, d4);
                    entitysoundwave.func_70107_b(this.parentEntity.func_226277_ct_() + vector3d.field_72450_a * 4.0, this.parentEntity.func_226283_e_(0.5) + 0.5, entitysoundwave.func_226281_cx_() + vector3d.field_72449_c * 4.0);
                    world.func_217376_c((Entity)entitysoundwave);
                    this.attackTimer = -40;
                }
            } else if (this.attackTimer > 0) {
                --this.attackTimer;
            }
            this.parentEntity.func_175454_a(this.attackTimer > 10);
        }
    }
}

