/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.instrumentalmobs.init;

import com.mrbysco.instrumentalmobs.blocks.DrumBlock;
import com.mrbysco.instrumentalmobs.entities.CymbalHuskEntity;
import com.mrbysco.instrumentalmobs.entities.DrumZombieEntity;
import com.mrbysco.instrumentalmobs.entities.FrenchHornCreeperEntity;
import com.mrbysco.instrumentalmobs.entities.MaracaSpiderEntity;
import com.mrbysco.instrumentalmobs.entities.MicrophoneGhastEntity;
import com.mrbysco.instrumentalmobs.entities.TubaEndermanEntity;
import com.mrbysco.instrumentalmobs.entities.XylophoneSkeletonEntity;
import com.mrbysco.instrumentalmobs.entities.projectiles.EntityMicrophoneWave;
import com.mrbysco.instrumentalmobs.entities.projectiles.EntitySoundWaves;
import com.mrbysco.instrumentalmobs.init.InstrumentalTab;
import com.mrbysco.instrumentalmobs.items.CustomSpawnEggItem;
import com.mrbysco.instrumentalmobs.items.DrumInstrument;
import com.mrbysco.instrumentalmobs.items.InstrumentItem;
import com.mrbysco.instrumentalmobs.items.InstrumentMicrophone;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class InstrumentalRegistry {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"instrumentalmobs");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"instrumentalmobs");
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITIES, (String)"instrumentalmobs");
    public static final DeferredRegister<SoundEvent> SOUND_EVENTS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (String)"instrumentalmobs");
    public static final RegistryObject<Block> DRUM_BLOCK = BLOCKS.register("drum_block", () -> new DrumBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151580_n, (MaterialColor)MaterialColor.field_151666_j).func_200943_b(0.8f).func_200947_a(SoundType.field_185854_g).func_226896_b_()));
    public static final RegistryObject<Item> DRUM_BLOCK_ITEM = ITEMS.register("drum_block", () -> new BlockItem((Block)DRUM_BLOCK.get(), InstrumentalRegistry.itemBuilder()));
    public static final RegistryObject<Item> DRUM_ITEM = ITEMS.register("drum", () -> new DrumInstrument(InstrumentalRegistry.itemBuilder().func_200917_a(1).func_200918_c(140), () -> (SoundEvent)drum_sound.get(), 30, 40));
    public static final RegistryObject<Item> cymbal = ITEMS.register("cymbal", () -> new Item(InstrumentalRegistry.itemBuilder().func_200917_a(1)));
    public static final RegistryObject<Item> cymbals = ITEMS.register("cymbals", () -> new InstrumentItem(InstrumentalRegistry.itemBuilder().func_200917_a(1).func_200918_c(100), () -> (SoundEvent)cymbals_sound.get(), 30, 40));
    public static final RegistryObject<Item> french_horn = ITEMS.register("french_horn", () -> new InstrumentItem(InstrumentalRegistry.itemBuilder().func_200917_a(1).func_200918_c(165), () -> (SoundEvent)french_horn_sound.get(), 40, 50));
    public static final RegistryObject<Item> maraca = ITEMS.register("maraca", () -> new Item(InstrumentalRegistry.itemBuilder().func_200917_a(1)));
    public static final RegistryObject<Item> maracas = ITEMS.register("maracas", () -> new InstrumentItem(InstrumentalRegistry.itemBuilder().func_200917_a(1).func_200918_c(125), () -> (SoundEvent)maraca_sound.get(), 30, 20));
    public static final RegistryObject<Item> microphone = ITEMS.register("microphone", () -> new InstrumentMicrophone(InstrumentalRegistry.itemBuilder().func_200917_a(1).func_200918_c(110), () -> SoundEvents.field_189105_bM, 40, 40));
    public static final RegistryObject<Item> tuba = ITEMS.register("tuba", () -> new InstrumentItem(InstrumentalRegistry.itemBuilder().func_200917_a(1).func_200917_a(180), () -> (SoundEvent)tuba_sound.get(), 20, 40));
    public static final RegistryObject<Item> xylophone = ITEMS.register("xylophone", () -> new InstrumentItem(InstrumentalRegistry.itemBuilder().func_200917_a(1).func_200918_c(160), () -> (SoundEvent)xylophone_sound.get(), 30, 30));
    public static final RegistryObject<Item> CYMBAL_HUSK_SPAWN_EGG = ITEMS.register("cymbal_husk_spawn_egg", () -> new CustomSpawnEggItem(() -> (EntityType)CYMBAL_HUSK.get(), 7958625, 15125652, InstrumentalRegistry.itemBuilder()));
    public static final RegistryObject<Item> DRUM_ZOMBIE_SPAWN_EGG = ITEMS.register("drum_zombie_spawn_egg", () -> new CustomSpawnEggItem(() -> (EntityType)DRUM_ZOMBIE.get(), 44975, 7969893, InstrumentalRegistry.itemBuilder()));
    public static final RegistryObject<Item> FRENCH_HORN_CREEPER_SPAWN_EGG = ITEMS.register("french_horn_creeper", () -> new CustomSpawnEggItem(() -> (EntityType)FRENCH_HORN_CREEPER.get(), 894731, 0, InstrumentalRegistry.itemBuilder()));
    public static final RegistryObject<Item> MARACA_SPIDER_SPAWN_EGG = ITEMS.register("maraca_spider_spawn_egg", () -> new CustomSpawnEggItem(() -> (EntityType)MARACA_SPIDER.get(), 803406, 11013646, InstrumentalRegistry.itemBuilder()));
    public static final RegistryObject<Item> MICROPHONE_GHAST_SPAWN_EGG = ITEMS.register("microphone_ghast_spawn_egg", () -> new CustomSpawnEggItem(() -> (EntityType)MICROPHONE_GHAST.get(), 0xF9F9F9, 0xBCBCBC, InstrumentalRegistry.itemBuilder()));
    public static final RegistryObject<Item> TUBA_ENDERMAN_SPAWN_EGG = ITEMS.register("tuba_enderman_spawn_egg", () -> new CustomSpawnEggItem(() -> (EntityType)TUBA_ENDERMAN.get(), 0x161616, 0, InstrumentalRegistry.itemBuilder()));
    public static final RegistryObject<Item> XYLOPHONE_SKELETON_SPAWN_EGG = ITEMS.register("xylophone_skeleton_spawn_egg", () -> new CustomSpawnEggItem(() -> (EntityType)XYLOPHONE_SKELETON.get(), 0xC1C1C1, 0x494949, InstrumentalRegistry.itemBuilder()));
    public static final RegistryObject<EntityType<CymbalHuskEntity>> CYMBAL_HUSK = ENTITIES.register("cymbal_husk", () -> InstrumentalRegistry.register("cymbal_husk", EntityType.Builder.func_220322_a(CymbalHuskEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(0.6f, 1.95f).func_233606_a_(8)));
    public static final RegistryObject<EntityType<DrumZombieEntity>> DRUM_ZOMBIE = ENTITIES.register("drum_zombie", () -> InstrumentalRegistry.register("drum_zombie", EntityType.Builder.func_220322_a(DrumZombieEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(0.6f, 1.95f).func_233606_a_(8)));
    public static final RegistryObject<EntityType<FrenchHornCreeperEntity>> FRENCH_HORN_CREEPER = ENTITIES.register("french_horn_creeper", () -> InstrumentalRegistry.register("french_horn_creeper", EntityType.Builder.func_220322_a(FrenchHornCreeperEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(0.6f, 1.7f).func_233606_a_(8)));
    public static final RegistryObject<EntityType<MaracaSpiderEntity>> MARACA_SPIDER = ENTITIES.register("maraca_spider", () -> InstrumentalRegistry.register("maraca_spider", EntityType.Builder.func_220322_a(MaracaSpiderEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(1.4f, 0.9f).func_233606_a_(8)));
    public static final RegistryObject<EntityType<MicrophoneGhastEntity>> MICROPHONE_GHAST = ENTITIES.register("microphone_ghast", () -> InstrumentalRegistry.register("microphone_ghast", EntityType.Builder.func_220322_a(MicrophoneGhastEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(4.0f, 4.0f).func_220320_c().func_233606_a_(10)));
    public static final RegistryObject<EntityType<TubaEndermanEntity>> TUBA_ENDERMAN = ENTITIES.register("tuba_enderman", () -> InstrumentalRegistry.register("tuba_enderman", EntityType.Builder.func_220322_a(TubaEndermanEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(0.6f, 2.9f).func_233606_a_(8)));
    public static final RegistryObject<EntityType<XylophoneSkeletonEntity>> XYLOPHONE_SKELETON = ENTITIES.register("xylophone_skeleton", () -> InstrumentalRegistry.register("xylophone_skeleton", EntityType.Builder.func_220322_a(XylophoneSkeletonEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(0.6f, 1.99f).func_233606_a_(8)));
    public static final RegistryObject<EntityType<EntityMicrophoneWave>> MICROPHONE_WAVE = ENTITIES.register("microphone_sound", () -> InstrumentalRegistry.register("microphone_sound", EntityType.Builder.func_220322_a(EntityMicrophoneWave::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.3125f, 0.3125f).func_233606_a_(4).func_233608_b_(10).setCustomClientFactory(EntityMicrophoneWave::new)));
    public static final RegistryObject<EntityType<EntitySoundWaves>> SOUND_WAVE = ENTITIES.register("sound_waves", () -> InstrumentalRegistry.register("sound_waves", EntityType.Builder.func_220322_a(EntitySoundWaves::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.3125f, 0.3125f).func_233606_a_(4).func_233608_b_(10).setCustomClientFactory(EntitySoundWaves::new)));
    public static final RegistryObject<SoundEvent> cymbals_sound = SOUND_EVENTS.register("cymbal.sound", () -> InstrumentalRegistry.createSound("cymbal.sound"));
    public static final RegistryObject<SoundEvent> drum_sound = SOUND_EVENTS.register("drum.sound", () -> InstrumentalRegistry.createSound("drum.sound"));
    public static final RegistryObject<SoundEvent> french_horn_sound = SOUND_EVENTS.register("frenchhorn.sound", () -> InstrumentalRegistry.createSound("frenchhorn.sound"));
    public static final RegistryObject<SoundEvent> maraca_sound = SOUND_EVENTS.register("maraca.sound", () -> InstrumentalRegistry.createSound("maraca.sound"));
    public static final RegistryObject<SoundEvent> single_drum_sound = SOUND_EVENTS.register("drum.single.sound", () -> InstrumentalRegistry.createSound("drum.single.sound"));
    public static final RegistryObject<SoundEvent> tuba_sound = SOUND_EVENTS.register("tuba.sound", () -> InstrumentalRegistry.createSound("tuba.sound"));
    public static final RegistryObject<SoundEvent> xylophone_sound = SOUND_EVENTS.register("xylophone.sound", () -> InstrumentalRegistry.createSound("xylophone.sound"));

    public static <T extends Entity> EntityType<T> register(String id, EntityType.Builder<T> builder, boolean sendVelocityUpdates) {
        return builder.setShouldReceiveVelocityUpdates(sendVelocityUpdates).func_206830_a(id);
    }

    public static <T extends Entity> EntityType<T> register(String id, EntityType.Builder<T> builder) {
        return InstrumentalRegistry.register(id, builder, true);
    }

    private static SoundEvent createSound(String name) {
        ResourceLocation resourceLocation = new ResourceLocation("instrumentalmobs", name);
        return new SoundEvent(resourceLocation);
    }

    private static Item.Properties itemBuilder() {
        return new Item.Properties().func_200916_a(InstrumentalTab.INSTRUMENTAL_TAB);
    }
}

