/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.instrumentalmobs.items;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.spawner.AbstractSpawner;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CustomSpawnEggItem
extends Item {
    private static final Map<Supplier<EntityType<?>>, CustomSpawnEggItem> EGGS = Maps.newIdentityHashMap();
    private final Supplier<EntityType<?>> typeIn;
    private final int primaryColor;
    private final int secondaryColor;

    public CustomSpawnEggItem(Supplier<EntityType<?>> type, int primary, int secondary, Item.Properties properties) {
        super(properties);
        this.typeIn = type;
        this.primaryColor = primary;
        this.secondaryColor = secondary;
        EGGS.put(type, this);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        TileEntity tile;
        World worldIn = context.func_195991_k();
        if (worldIn.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        ItemStack stack = context.func_195996_i();
        BlockPos pos = context.func_195995_a();
        Direction dir = context.func_196000_l();
        BlockState state = worldIn.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block == Blocks.field_150474_ac && (tile = worldIn.func_175625_s(pos)) instanceof MobSpawnerTileEntity) {
            AbstractSpawner spawner = ((MobSpawnerTileEntity)tile).func_145881_a();
            EntityType<?> type = this.getType(stack.func_77978_p());
            spawner.func_200876_a(type);
            tile.func_70296_d();
            worldIn.func_184138_a(pos, state, state, 3);
            stack.func_190918_g(1);
            return ActionResultType.SUCCESS;
        }
        BlockPos pos2 = state.func_196952_d((IBlockReader)worldIn, pos).func_197766_b() ? pos : pos.func_177972_a(dir);
        EntityType<?> type = this.getType(stack.func_77978_p());
        if (!worldIn.field_72995_K && type.func_220331_a((ServerWorld)worldIn, stack, context.func_195999_j(), pos2, SpawnReason.SPAWN_EGG, true, !Objects.equals(pos, pos2) && dir == Direction.UP) != null) {
            stack.func_190918_g(1);
        }
        return ActionResultType.SUCCESS;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        BlockRayTraceResult raytraceresult = CustomSpawnEggItem.func_219968_a((World)worldIn, (PlayerEntity)playerIn, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.SOURCE_ONLY);
        if (raytraceresult.func_216346_c() != RayTraceResult.Type.BLOCK) {
            return ActionResult.func_226250_c_((Object)itemstack);
        }
        if (worldIn.field_72995_K) {
            return ActionResult.func_226248_a_((Object)itemstack);
        }
        BlockRayTraceResult blockraytraceresult = raytraceresult;
        BlockPos blockpos = blockraytraceresult.func_216350_a();
        if (!(worldIn.func_180495_p(blockpos).func_177230_c() instanceof FlowingFluidBlock)) {
            return ActionResult.func_226250_c_((Object)itemstack);
        }
        if (worldIn.func_175660_a(playerIn, blockpos) && playerIn.func_175151_a(blockpos, blockraytraceresult.func_216354_b(), itemstack)) {
            EntityType<?> entitytype = this.getType(itemstack.func_77978_p());
            if (!worldIn.field_72995_K && entitytype.func_220331_a((ServerWorld)worldIn, itemstack, playerIn, blockpos, SpawnReason.SPAWN_EGG, false, false) == null) {
                return ActionResult.func_226250_c_((Object)itemstack);
            }
            if (!playerIn.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            playerIn.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
            return ActionResult.func_226248_a_((Object)itemstack);
        }
        return ActionResult.func_226251_d_((Object)itemstack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getColor(int p_195983_1_) {
        return p_195983_1_ == 0 ? this.primaryColor : this.secondaryColor;
    }

    public static Iterable<CustomSpawnEggItem> getEggs() {
        return Iterables.unmodifiableIterable(EGGS.values());
    }

    public EntityType<?> getType(@Nullable CompoundNBT compound) {
        CompoundNBT lvt_2_1_;
        if (compound != null && compound.func_150297_b("EntityTag", 10) && (lvt_2_1_ = compound.func_74775_l("EntityTag")).func_150297_b("id", 8)) {
            return EntityType.func_220327_a((String)lvt_2_1_.func_74779_i("id")).orElse(this.typeIn.get());
        }
        return this.typeIn.get();
    }
}

