/*
 * Decompiled with CFR 0.152.
 */
package com.github.nyuppo.mixin;

import com.github.nyuppo.mixin.MobVariantsMixin;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Wolf.class})
public abstract class WolfVariantsMixin
extends MobVariantsMixin {
    private static final EntityDataAccessor<Integer> VARIANT_ID = SynchedEntityData.m_135353_(Wolf.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final String NBT_KEY = "Variant";

    @Override
    protected void onDefineSynchedData(CallbackInfo ci) {
        ((Wolf)this).m_20088_().m_135372_(VARIANT_ID, (Object)0);
    }

    @Override
    protected void onAddAdditionalSaveData(CompoundTag p_21484_, CallbackInfo ci) {
        p_21484_.m_128405_(NBT_KEY, ((Integer)((Wolf)this).m_20088_().m_135370_(VARIANT_ID)).intValue());
    }

    @Override
    protected void onReadAdditionalSaveData(CompoundTag p_21450_, CallbackInfo ci) {
        ((Wolf)this).m_20088_().m_135381_(VARIANT_ID, (Object)p_21450_.m_128451_(NBT_KEY));
    }

    @Override
    protected void onFinalizeSpawn(ServerLevelAccessor p_21434_, DifficultyInstance p_21435_, MobSpawnType p_21436_, SpawnGroupData p_21437_, CompoundTag p_21438_, CallbackInfoReturnable<SpawnGroupData> cir) {
        int i = this.getRandomVariant(p_21434_.m_213780_());
        ((Wolf)this).m_20088_().m_135381_(VARIANT_ID, (Object)i);
    }

    @Inject(method={"getBreedOffspring(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/AgeableMob;)Lnet/minecraft/world/entity/animal/Wolf;"}, at={@At(value="HEAD")}, cancellable=true)
    private void onGetBreedOffspring(ServerLevel p_148890_, AgeableMob p_148891_, CallbackInfoReturnable<Wolf> ci) {
        Wolf child = (Wolf)EntityType.f_20499_.m_20615_((Level)p_148890_);
        int i = 0;
        if (p_148891_.m_217043_().m_188503_(4) != 0) {
            CompoundTag thisNbt = new CompoundTag();
            ((Wolf)this).m_20240_(thisNbt);
            CompoundTag parentNbt = new CompoundTag();
            p_148891_.m_20240_(parentNbt);
            if (thisNbt.m_128441_(NBT_KEY) && parentNbt.m_128441_(NBT_KEY)) {
                int parentVariant;
                int thisVariant = thisNbt.m_128451_(NBT_KEY);
                if (thisVariant == (parentVariant = parentNbt.m_128451_(NBT_KEY))) {
                    i = thisVariant;
                } else {
                    boolean hasBred = false;
                    if (thisVariant == 2 && parentVariant == 1 || thisVariant == 1 && parentVariant == 2) {
                        if (p_148891_.m_217043_().m_188503_(3) == 0) {
                            hasBred = true;
                            i = 3;
                        }
                    } else if (thisVariant == 1 && parentVariant == 0 || thisVariant == 0 && parentVariant == 1) {
                        if (p_148891_.m_217043_().m_188503_(3) == 0) {
                            hasBred = true;
                            i = 4;
                        }
                    } else if ((thisVariant == 2 && parentVariant == 4 || thisVariant == 4 && parentVariant == 2) && p_148891_.m_217043_().m_188503_(3) == 0) {
                        hasBred = true;
                        i = 5;
                    }
                    if (!hasBred) {
                        i = p_148891_.m_217043_().m_188499_() ? thisVariant : parentVariant;
                    }
                }
            }
        } else {
            i = this.getRandomVariant(p_148891_.m_217043_());
        }
        CompoundTag childNbt = new CompoundTag();
        child.m_20240_(childNbt);
        childNbt.m_128405_(NBT_KEY, i);
        child.m_7378_(childNbt);
        ci.setReturnValue((Object)child);
    }

    private int getRandomVariant(RandomSource random) {
        int i = random.m_188503_(3);
        if (i == 0) {
            return 1;
        }
        if (i == 1) {
            return 2;
        }
        return 0;
    }
}

