/*
 * Decompiled with CFR 0.152.
 */
package mod.motivationaldragon.potionblender.blockentities;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import mod.motivationaldragon.potionblender.block.BrewingCauldron;
import mod.motivationaldragon.potionblender.config.ModConfig;
import mod.motivationaldragon.potionblender.item.ModItem;
import mod.motivationaldragon.potionblender.platform.Service;
import mod.motivationaldragon.potionblender.utils.ModUtils;
import net.minecraft.class_1262;
import net.minecraft.class_1264;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1844;
import net.minecraft.class_1927;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BrewingCauldronBlockEntity
extends class_2586 {
    private static final String POTION_MIXER_KEY = "potionblender.PotionBlender";
    private static final Map<class_1792, class_1792> recipes = new HashMap<class_1792, class_1792>(3);
    private class_2371<class_1799> inventory;
    private int numberOfPotion;

    protected BrewingCauldronBlockEntity(class_2338 pos, class_2680 state) {
        super(Service.PLATFORM.getPlatformBrewingCauldron(), pos, state);
        this.inventory = class_2371.method_10213((int)ModConfig.getConfig().max_effects, (Object)class_1799.field_8037);
        this.numberOfPotion = 0;
    }

    public class_2371<class_1799> getInventory() {
        return this.inventory;
    }

    public int size() {
        return this.inventory.size();
    }

    private void emptyCauldron(@NotNull class_1937 level) {
        this.inventory.clear();
        this.numberOfPotion = 0;
        class_2680 hasFluid = (class_2680)level.method_8320(this.method_11016()).method_11657((class_2769)BrewingCauldron.HAS_FLUID, (Comparable)Boolean.valueOf(false));
        level.method_8501(this.method_11016(), hasFluid);
        this.updateListeners();
    }

    private void updateListeners() {
        this.method_5431();
        this.syncInventoryWithClient();
        assert (this.method_10997() != null);
        this.method_10997().method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 1);
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    protected abstract void syncInventoryWithClient();

    public void onUseDelegate(class_2680 _state, class_1937 level, class_2338 pos, class_1657 player) {
        if (this.numberOfPotion >= 1) {
            this.dropInventoryContent(level, pos);
        }
    }

    private void craftCombinedPotion(class_1799 recipeItemStack, class_1937 level, @NotNull class_2338 pos) {
        if (level.method_8608()) {
            return;
        }
        List<class_1293> finalPotionStatusEffects = this.getInventoryStatusEffectsInstances();
        BrewingCauldronBlockEntity.mergeCombinableEffects(finalPotionStatusEffects);
        class_1799 potionToCraft = new class_1799((class_1935)recipes.get(recipeItemStack.method_7909()));
        if (potionToCraft.method_31574(ModItem.COMBINED_LINGERING_POTION)) {
            finalPotionStatusEffects = BrewingCauldronBlockEntity.handleLingeringEffect(finalPotionStatusEffects);
        }
        class_1799 potionItemStack = class_1844.method_8056((class_1799)potionToCraft, finalPotionStatusEffects);
        assert (potionItemStack.method_7969() != null);
        int color = class_1844.method_8055(finalPotionStatusEffects);
        potionItemStack.method_7969().method_10569("CustomPotionColor", color);
        class_1264.method_5449((class_1937)level, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), (class_1799)potionItemStack);
        class_1264.method_5449((class_1937)level, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), (class_1799)new class_1799((class_1935)class_1802.field_8469, this.numberOfPotion - 1));
        level.method_8396(null, pos, class_3417.field_14978, class_3419.field_15245, 1.0f, 1.0f);
        this.emptyCauldron(level);
    }

    private static void mergeCombinableEffects(List<class_1293> finalPotionStatusEffects) {
        HashSet<class_1291> mergedStatusEffects = new HashSet<class_1291>();
        for (int i = 0; i < finalPotionStatusEffects.size(); ++i) {
            class_1293 effectInstance1 = finalPotionStatusEffects.get(i);
            ArrayList<class_1293> combinableEffects = new ArrayList<class_1293>();
            int totalDuration = effectInstance1.method_5584();
            combinableEffects.add(effectInstance1);
            int potionDecay = 2;
            for (int j = 0; j < finalPotionStatusEffects.size(); ++j) {
                class_1293 effectInstance2 = finalPotionStatusEffects.get(j);
                if (i == j || mergedStatusEffects.contains(effectInstance1.method_5579()) || !BrewingCauldronBlockEntity.areEffectsDurationsAddable(effectInstance1, effectInstance2)) continue;
                totalDuration = (int)((double)totalDuration + 1.0 / (double)potionDecay * (double)effectInstance2.method_5584());
                ++potionDecay;
                combinableEffects.add(effectInstance2);
            }
            mergedStatusEffects.add(effectInstance1.method_5579());
            if (combinableEffects.size() <= 1) continue;
            class_1293 combinedEffect = ModUtils.copyEffectWithNewDuration((class_1293)combinableEffects.get(0), totalDuration);
            finalPotionStatusEffects.removeAll(combinableEffects);
            finalPotionStatusEffects.add(combinedEffect);
        }
    }

    @NotNull
    private static List<class_1293> handleLingeringEffect(List<class_1293> finalPotionStatusEffects) {
        ArrayList<class_1293> lingeringEffects = new ArrayList<class_1293>(finalPotionStatusEffects.size());
        for (class_1293 effectInstance : finalPotionStatusEffects) {
            if (effectInstance.method_5579().method_5561()) {
                lingeringEffects.add(new class_1293(effectInstance.method_5579(), effectInstance.method_5584(), Math.round((float)effectInstance.method_5578() * 0.5f), effectInstance.method_5591(), effectInstance.method_5581(), effectInstance.method_5592()));
                continue;
            }
            lingeringEffects.add(ModUtils.copyEffectWithNewDuration(effectInstance, Math.round((float)effectInstance.method_5584() * 0.25f)));
        }
        finalPotionStatusEffects = lingeringEffects;
        return finalPotionStatusEffects;
    }

    private static boolean areEffectsDurationsAddable(class_1293 effectInstance1, class_1293 effectInstance2) {
        return effectInstance1.method_5579() == effectInstance2.method_5579() && effectInstance1.method_5578() == effectInstance2.method_5578();
    }

    private void dropInventoryContent(@NotNull class_1937 level, class_2338 pos) {
        if (level.method_8608()) {
            return;
        }
        level.method_8396(null, pos, class_3417.field_15219, class_3419.field_15245, 1.0f, 1.0f);
        class_1264.method_17349((class_1937)level, (class_2338)pos, this.getInventory());
        this.emptyCauldron(level);
    }

    public void onEntityLandDelegate(class_1297 entity) {
        assert (this.field_11863 != null);
        if (this.field_11863.method_8608()) {
            return;
        }
        if (entity instanceof class_1542) {
            class_1542 itemEntity = (class_1542)entity;
            class_1799 itemStack = itemEntity.method_6983();
            if (BrewingCauldronBlockEntity.isACombinedPotion(itemStack)) {
                entity.method_5650(class_1297.class_5529.field_26999);
                class_2338 pos = this.method_11016();
                this.field_11863.method_8437(entity, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), 1.5f, class_1927.class_4179.field_18686);
            }
            if (itemStack.method_31574(class_1802.field_8574) && this.numberOfPotion < this.inventory.size()) {
                this.addItemToCauldron(itemEntity);
            }
            if (recipes.containsKey(itemStack.method_7909()) && this.numberOfPotion > 0) {
                this.craftCombinedPotion(itemStack, this.field_11863, this.method_11016());
                entity.method_5650(class_1297.class_5529.field_26999);
            }
        }
    }

    private static boolean isACombinedPotion(class_1799 itemStack) {
        boolean isTippedArrow = false;
        if (itemStack.method_7985()) {
            assert (itemStack.method_7969() != null);
            isTippedArrow = itemStack.method_7969().method_10545("potionblender_isTippedArrow");
        }
        return itemStack.method_31574(ModItem.COMBINED_POTION) || itemStack.method_31574(ModItem.SPLASH_COMBINED_POTION) || itemStack.method_31574(ModItem.COMBINED_LINGERING_POTION) || isTippedArrow;
    }

    private void addItemToCauldron(@NotNull class_1542 itemEntity) {
        assert (this.field_11863 != null);
        if (this.field_11863.method_8608()) {
            return;
        }
        class_1937 level = itemEntity.method_37908();
        level.method_8396(null, this.method_11016(), class_3417.field_15197, class_3419.field_15245, 1.0f, 1.0f);
        this.addItem(itemEntity.method_6983());
        class_2680 mixerCauldronBlockState = (class_2680)level.method_8320(this.method_11016()).method_11657((class_2769)BrewingCauldron.HAS_FLUID, (Comparable)Boolean.valueOf(true));
        level.method_8501(this.method_11016(), mixerCauldronBlockState);
        this.forceChunkUpdate();
        itemEntity.method_5650(class_1297.class_5529.field_26999);
        this.updateListeners();
    }

    private void addItem(@NotNull class_1799 itemStack) {
        assert (this.field_11863 != null);
        if (this.numberOfPotion > this.inventory.size()) {
            this.countPotion(this.inventory);
        }
        this.inventory.set(this.numberOfPotion, (Object)itemStack);
        ++this.numberOfPotion;
    }

    private void forceChunkUpdate() {
        class_2680 blockState;
        if (this.field_11863 == null) {
            return;
        }
        boolean redrawValue = (Boolean)(blockState = this.field_11863.method_8320(this.method_11016())).method_11654((class_2769)BrewingCauldron.REDRAW_DUMMY);
        class_2680 newRedraw = (class_2680)blockState.method_11657((class_2769)BrewingCauldron.REDRAW_DUMMY, (Comparable)Boolean.valueOf(!redrawValue));
        this.field_11863.method_8501(this.method_11016(), newRedraw);
    }

    public void method_11014(@NotNull class_2487 nbt) {
        this.inventory = class_2371.method_10213((int)this.size(), (Object)class_1799.field_8037);
        class_1262.method_5429((class_2487)nbt, this.inventory);
        this.numberOfPotion = nbt.method_10550(POTION_MIXER_KEY);
        super.method_11014(nbt);
    }

    protected void method_11007(@NotNull class_2487 nbt) {
        class_1262.method_5426((class_2487)nbt, this.inventory);
        nbt.method_10569(POTION_MIXER_KEY, this.numberOfPotion);
        super.method_11007(nbt);
    }

    public int getWaterColor() {
        return class_1844.method_8055(this.getInventoryStatusEffectsInstances());
    }

    @NotNull
    public class_2487 method_16887() {
        return this.method_38244();
    }

    @NotNull
    protected List<class_1293> getInventoryStatusEffectsInstances() {
        ArrayList<class_1293> effects = new ArrayList<class_1293>();
        if (this.numberOfPotion > this.inventory.size()) {
            this.numberOfPotion = this.size() - 1;
        }
        for (int i = 0; i < this.numberOfPotion; ++i) {
            class_1799 potionItemStack = (class_1799)this.inventory.get(i);
            effects.addAll(class_1844.method_8067((class_1799)potionItemStack));
        }
        return effects;
    }

    public void setInventory(class_2371<class_1799> newInventory) {
        this.numberOfPotion = 0;
        this.inventory = newInventory;
        this.countPotion(newInventory);
    }

    private void countPotion(class_2371<class_1799> newInventory) {
        for (class_1799 stack : newInventory) {
            if (stack.method_31574(class_1802.field_8162)) continue;
            ++this.numberOfPotion;
        }
    }

    static {
        recipes.put(class_1802.field_8790, ModItem.COMBINED_POTION);
        recipes.put(class_1802.field_8054, ModItem.SPLASH_COMBINED_POTION);
        recipes.put(class_1802.field_8613, ModItem.COMBINED_LINGERING_POTION);
    }
}

