/*
 * Decompiled with CFR 0.152.
 */
package mod.motivationaldragon.potionblender;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import mod.motivationaldragon.potionblender.PotionBlenderCommon;
import mod.motivationaldragon.potionblender.block.ModBlock;
import mod.motivationaldragon.potionblender.blockentity.ForgeBlockEntities;
import mod.motivationaldragon.potionblender.item.ModItem;
import mod.motivationaldragon.potionblender.networking.NetworkRegister;
import mod.motivationaldragon.potionblender.recipes.ModSpecialRecipeSerializer;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod(value="potionblender")
public class ForgePotionBlender {
    public ForgePotionBlender() {
        PotionBlenderCommon.init();
        NetworkRegister.register();
        ForgePotionBlender.bind(ForgeRegistries.BLOCKS, ModBlock::registerBlock);
        ForgePotionBlender.bind(ForgeRegistries.ITEMS, ModItem::register);
        ForgePotionBlender.bind(ForgeRegistries.ITEMS, ModBlock::registerBlockItem);
        ForgePotionBlender.bind(ForgeRegistries.RECIPE_SERIALIZERS, ModSpecialRecipeSerializer::register);
        ForgeBlockEntities.register();
    }

    private static <T extends IForgeRegistryEntry<T>> void bind(IForgeRegistry<T> registry, Consumer<BiConsumer<T, ResourceLocation>> source) {
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(registry.getRegistrySuperType(), event -> {
            if (registry.equals(event.getRegistry())) {
                source.accept((t, rl) -> {
                    t.setRegistryName(rl);
                    event.getRegistry().register(t);
                });
            }
        });
    }
}

