/*
 * Decompiled with CFR 0.152.
 */
package mod.motivationaldragon.potionblender.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import mod.motivationaldragon.potionblender.Constants;
import mod.motivationaldragon.potionblender.config.ConfigInstance;

public class ModConfig {
    private static final String CONFIG_FILE_NAME = "potion_blender_config.json";
    private static final Path CONFIG_PATH = Path.of("potionblender", "potion_blender_config.json");
    private static final Gson JSON_PARSER = new GsonBuilder().setPrettyPrinting().create();
    private static ConfigInstance config;
    private static boolean isReady;

    private ModConfig() {
    }

    public static ConfigInstance getConfig() {
        return config;
    }

    private static void readConfig() {
        if (!isReady) {
            ModConfig.init();
        }
        try {
            String jsonString = Files.readString(CONFIG_PATH);
            config = ModConfig.deserializeConfig(jsonString);
            Constants.LOG.info("Loaded config");
            return;
        }
        catch (IOException e) {
            Constants.LOG.error("Could not read config file");
            e.printStackTrace();
            Constants.LOG.warn("Unable to read config, using a default one as fallback");
            config = new ConfigInstance();
            return;
        }
    }

    public static void init() {
        if (isReady) {
            return;
        }
        isReady = true;
        Path configPath = Path.of("potionblender", CONFIG_FILE_NAME);
        if (!Files.exists(configPath, new LinkOption[0])) {
            try {
                Path path = Path.of("potionblender", new String[0]);
                Constants.LOG.info("No config file found, creating a new one at: %s...".formatted(path));
                Files.createDirectories(path, new FileAttribute[0]);
                ConfigInstance configInstance = new ConfigInstance();
                String jsonString = ModConfig.serializeConfig(configInstance);
                Files.createFile(configPath, new FileAttribute[0]);
                Files.writeString(configPath, (CharSequence)jsonString, new OpenOption[0]);
            }
            catch (IOException e) {
                Constants.LOG.error("Could not access config file");
                e.printStackTrace();
            }
        }
    }

    public static ConfigInstance deserializeConfig(String configAsJson) {
        try {
            return (ConfigInstance)JSON_PARSER.fromJson(configAsJson, ConfigInstance.class);
        }
        catch (JsonSyntaxException e) {
            Constants.LOG.error("Could not parse config JSON. Make sure syntax is correct");
            e.printStackTrace();
            Constants.LOG.warn("Unable to deserialize config, using a default one as fallback");
            return new ConfigInstance();
        }
    }

    public static String serializeConfig(ConfigInstance config) {
        return JSON_PARSER.toJson((Object)config);
    }

    static {
        isReady = false;
        ModConfig.readConfig();
    }
}

