/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.client.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_1058;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_455;
import net.minecraft.class_4587;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_757;
import net.puffish.skillsmod.SkillsMod;
import net.puffish.skillsmod.client.SkillsClientMod;
import net.puffish.skillsmod.client.data.ClientIconData;
import net.puffish.skillsmod.client.data.ClientSkillCategoryData;
import net.puffish.skillsmod.client.data.ClientSkillConnectionData;
import net.puffish.skillsmod.client.data.ClientSkillData;
import net.puffish.skillsmod.client.data.ClientSkillDefinitionData;
import net.puffish.skillsmod.client.gui.DrawUtils;
import net.puffish.skillsmod.client.network.packets.out.SkillClickOutPacket;
import net.puffish.skillsmod.skill.SkillState;
import net.puffish.skillsmod.utils.Bounds2i;
import net.puffish.skillsmod.utils.Vec2i;

public class SkillsScreen
extends class_437 {
    private static final class_2960 TABS_TEXTURE = new class_2960("textures/gui/advancements/tabs.png");
    private static final class_2960 WINDOW_TEXTURE = new class_2960("textures/gui/advancements/window.png");
    private static final class_2960 WIDGETS_TEXTURE = new class_2960("textures/gui/advancements/widgets.png");
    private static final int TEXTURE_WIDTH = 256;
    private static final int TEXTURE_HEIGHT = 256;
    private static final int FRAME_WIDTH = 252;
    private static final int FRAME_HEIGHT = 140;
    private static final int FRAME_PADDING = 8;
    private static final int FRAME_CUT = 16;
    private static final int FRAME_EXPAND = 24;
    private static final int CONTENT_GROW = 32;
    private static final int TABS_HEIGHT = 28;
    private static final int HALF_FRAME_WIDTH = 126;
    private static final int HALF_FRAME_HEIGHT = 70;
    private final List<ClientSkillCategoryData> categories;
    private int activeCategory = 0;
    private float minScale = 1.0f;
    private float maxScale = 1.0f;
    private float scale = 1.0f;
    private int x = 0;
    private int y = 0;
    private boolean dragging;
    private Bounds2i bounds;
    private double dragStartX;
    private double dragStartY;
    private boolean small;
    private int contentPaddingTop;
    private int contentPaddingLeft;
    private int contentPaddingRight;
    private int contentPaddingBottom;
    private List<? extends class_5481> tooltip;

    public SkillsScreen(List<ClientSkillCategoryData> categories) {
        super(class_5244.field_39003);
        this.categories = categories;
    }

    private ClientSkillCategoryData getActiveCategory() {
        return this.categories.get(this.activeCategory);
    }

    private void setActiveCategory(int activeCategory) {
        this.activeCategory = activeCategory;
        this.resize();
    }

    protected void method_25426() {
        super.method_25426();
        this.resize();
    }

    private void resize() {
        boolean bl = this.small = this.field_22789 < 450;
        if (this.small) {
            this.contentPaddingTop = 62;
            this.contentPaddingLeft = 17;
            this.contentPaddingRight = 17;
            this.contentPaddingBottom = 17;
        } else {
            this.contentPaddingTop = 54;
            this.contentPaddingLeft = 17;
            this.contentPaddingRight = 17;
            this.contentPaddingBottom = 17;
        }
        this.x = this.field_22789 / 2;
        this.y = this.field_22790 / 2;
        this.bounds = this.getActiveCategory().getBounds();
        this.bounds.grow(32);
        this.bounds.extend(new Vec2i(this.contentPaddingLeft - this.x, this.contentPaddingTop - this.y));
        this.bounds.extend(new Vec2i(this.field_22789 - this.x - this.contentPaddingRight, this.field_22790 - this.y - this.contentPaddingBottom));
        int contentWidth = this.field_22789 - this.contentPaddingLeft - this.contentPaddingRight;
        int contentHeight = this.field_22790 - this.contentPaddingTop - this.contentPaddingBottom;
        int halfWidth = class_3532.method_38788((int)(this.bounds.height() * contentWidth), (int)(contentHeight * 2));
        int halfHeight = class_3532.method_38788((int)(this.bounds.width() * contentHeight), (int)(contentWidth * 2));
        this.bounds.extend(new Vec2i(-halfWidth, -halfHeight));
        this.bounds.extend(new Vec2i(halfWidth, halfHeight));
        this.minScale = Math.max((float)contentWidth / (float)this.bounds.width(), (float)contentHeight / (float)this.bounds.height());
        this.maxScale = 1.0f;
        this.scale = 1.0f;
    }

    private Vec2i getMousePos(double mouseX, double mouseY) {
        return new Vec2i((int)mouseX, (int)mouseY);
    }

    private Vec2i getTransformedMousePos(double mouseX, double mouseY) {
        return new Vec2i((int)Math.round((mouseX - (double)this.x) / (double)this.scale), (int)Math.round((mouseY - (double)this.y) / (double)this.scale));
    }

    private boolean isInsideTab(Vec2i mouse, int i) {
        return mouse.x >= 8 + i * 32 && mouse.y >= 8 && mouse.x < 8 + i * 32 + 28 && mouse.y < 40;
    }

    private boolean isInsideSkill(Vec2i transformedMouse, ClientSkillData skill) {
        return transformedMouse.x >= skill.getX() - 13 && transformedMouse.y >= skill.getY() - 13 && transformedMouse.x < skill.getX() + 13 && transformedMouse.y < skill.getY() + 13;
    }

    private boolean isInsideContent(Vec2i mouse) {
        return mouse.x >= this.contentPaddingLeft && mouse.y >= this.contentPaddingTop && mouse.x < this.field_22789 - this.contentPaddingRight && mouse.y < this.field_22790 - this.contentPaddingBottom;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        Vec2i mouse = this.getMousePos(mouseX, mouseY);
        Vec2i transformedMouse = this.getTransformedMousePos(mouseX, mouseY);
        if (this.isInsideContent(mouse)) {
            for (ClientSkillData skill : this.getActiveCategory().getSkills().values()) {
                if (!this.isInsideSkill(transformedMouse, skill)) continue;
                SkillsClientMod.getInstance().getPacketSender().send(SkillClickOutPacket.write(this.getActiveCategory().getId(), skill.getId()));
            }
            if (button == 0) {
                this.dragStartX = mouseX - (double)this.x;
                this.dragStartY = mouseY - (double)this.y;
                this.dragging = true;
            }
        } else {
            this.dragging = false;
        }
        for (int i = 0; i < this.categories.size(); ++i) {
            if (!this.isInsideTab(mouse, i)) continue;
            this.setActiveCategory(i);
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (SkillsClientMod.OPEN_KEY_BINDING.method_1417(keyCode, scanCode)) {
            this.method_25419();
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        this.tooltip = null;
        this.method_25420(matrices);
        this.drawContent(matrices, mouseX, mouseY);
        this.drawWindow(matrices);
        this.drawTabs(matrices, mouseX, mouseY);
        if (this.tooltip != null) {
            this.method_25417(matrices, this.tooltip, mouseX, mouseY);
        }
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.dragging && button == 0) {
            this.x = (int)Math.round(mouseX - this.dragStartX);
            this.y = (int)Math.round(mouseY - this.dragStartY);
            this.limitPosition();
            return true;
        }
        return false;
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        float factor = (float)Math.pow(2.0, amount * 0.25);
        this.scale *= factor;
        if (this.scale < this.minScale) {
            this.scale = this.minScale;
            factor = this.minScale / this.scale;
        }
        if (this.scale > this.maxScale) {
            this.scale = this.maxScale;
            factor = this.maxScale / this.scale;
        }
        this.x = (int)((long)this.x - Math.round((double)(factor - 1.0f) * (mouseX - (double)this.x)));
        this.y = (int)((long)this.y - Math.round((double)(factor - 1.0f) * (mouseY - (double)this.y)));
        this.limitPosition();
        return super.method_25401(mouseX, mouseY, amount);
    }

    private void limitPosition() {
        this.y = Math.min(this.y, Math.round((float)this.contentPaddingTop - (float)this.bounds.min().y * this.scale));
        this.x = Math.min(this.x, Math.round((float)this.contentPaddingLeft - (float)this.bounds.min().x * this.scale));
        this.x = Math.max(this.x, Math.round((float)(this.field_22789 - this.contentPaddingRight) - (float)this.bounds.max().x * this.scale));
        this.y = Math.max(this.y, Math.round((float)(this.field_22790 - this.contentPaddingBottom) - (float)this.bounds.max().y * this.scale));
    }

    private void drawIcon(class_4587 matrices, int x, int y, ClientIconData icon) {
        if (this.field_22787 == null) {
            return;
        }
        if (icon instanceof ClientIconData.ItemIconData) {
            ClientIconData.ItemIconData itemIcon = (ClientIconData.ItemIconData)icon;
            DrawUtils.drawItem(matrices, x - 8, y - 8, itemIcon.getItem());
        } else if (icon instanceof ClientIconData.EffectIconData) {
            ClientIconData.EffectIconData effectIcon = (ClientIconData.EffectIconData)icon;
            class_1058 sprite = this.field_22787.method_18505().method_18663(effectIcon.getEffect());
            RenderSystem.setShaderTexture((int)0, (class_2960)sprite.method_24119().method_24106());
            DrawUtils.drawSingleSprite(matrices, x - 9, y - 9, 18, 18, sprite);
        } else if (icon instanceof ClientIconData.TextureIconData) {
            ClientIconData.TextureIconData textureIcon = (ClientIconData.TextureIconData)icon;
            RenderSystem.setShaderTexture((int)0, (class_2960)textureIcon.getTexture());
            DrawUtils.drawSingleTexture(matrices, x - 8, y - 8, 16, 16);
        }
    }

    private void drawContent(class_4587 matrices, double mouseX, double mouseY) {
        if (this.field_22787 == null) {
            return;
        }
        Vec2i mouse = this.getMousePos(mouseX, mouseY);
        Vec2i transformedMouse = this.getTransformedMousePos(mouseX, mouseY);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
        RenderSystem.enableDepthTest();
        RenderSystem.depthFunc((int)519);
        RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        matrices.method_22903();
        matrices.method_22904(0.0, 0.0, 256.0);
        class_332.method_25294((class_4587)matrices, (int)0, (int)0, (int)this.field_22789, (int)this.field_22790, (int)-16777216);
        matrices.method_22904(0.0, 0.0, -512.0);
        class_332.method_25294((class_4587)matrices, (int)(this.contentPaddingLeft - 4), (int)(this.contentPaddingTop - 4), (int)(this.field_22789 - this.contentPaddingRight + 4), (int)(this.field_22790 - this.contentPaddingBottom + 4), (int)-16777216);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.depthFunc((int)515);
        matrices.method_22904((double)this.x, (double)this.y, 128.0);
        matrices.method_22905(this.scale, this.scale, 1.0f);
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)this.getActiveCategory().getBackground());
        DrawUtils.drawRepeatedTexture(matrices, this.bounds.min().x, this.bounds.min().y, this.bounds.width(), this.bounds.height(), 0, 0, 16, 16);
        for (ClientSkillConnectionData connections : this.getActiveCategory().getConnections()) {
            ClientSkillData skillA = this.getActiveCategory().getSkills().get(connections.getSkillAId());
            ClientSkillData skillB = this.getActiveCategory().getSkills().get(connections.getSkillBId());
            if (skillA == null || skillB == null) continue;
            DrawUtils.drawLine(matrices, skillA.getX(), skillA.getY(), skillB.getX(), skillB.getY(), 3, -16777216);
            DrawUtils.drawLine(matrices, skillA.getX(), skillA.getY(), skillB.getX(), skillB.getY(), 1, -1);
        }
        for (ClientSkillData skill : this.getActiveCategory().getSkills().values()) {
            class_455 status;
            ClientSkillDefinitionData definition = this.getActiveCategory().getDefinitions().get(skill.getDefinitionId());
            if (definition == null) continue;
            class_455 class_4552 = status = skill.getState() == SkillState.UNLOCKED ? class_455.field_2701 : class_455.field_2699;
            if (skill.getState() == SkillState.LOCKED) {
                RenderSystem.setShaderColor((float)0.25f, (float)0.25f, (float)0.25f, (float)1.0f);
            } else {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            RenderSystem.setShader(class_757::method_34542);
            RenderSystem.setShaderTexture((int)0, (class_2960)WIDGETS_TEXTURE);
            this.method_25302(matrices, skill.getX() - 13, skill.getY() - 13, definition.getFrame().method_832(), 128 + status.method_2320() * 26, 26, 26);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.drawIcon(matrices, skill.getX(), skill.getY(), definition.getIcon());
            if (!this.isInsideSkill(transformedMouse, skill) || !this.isInsideContent(mouse)) continue;
            this.tooltip = Stream.concat(this.field_22793.method_1728((class_5348)definition.getTitle(), 170).stream(), this.field_22793.method_1728((class_5348)definition.getDescription(), 170).stream()).toList();
        }
        matrices.method_22909();
        matrices.method_22903();
        RenderSystem.depthFunc((int)519);
        matrices.method_22904(0.0, 0.0, -512.0);
        RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        class_332.method_25294((class_4587)matrices, (int)0, (int)0, (int)this.field_22789, (int)this.field_22790, (int)-16777216);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.depthFunc((int)515);
        matrices.method_22909();
    }

    private void drawTabs(class_4587 matrices, double mouseX, double mouseY) {
        if (this.field_22787 == null) {
            return;
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
        RenderSystem.disableDepthTest();
        RenderSystem.setShaderTexture((int)0, (class_2960)TABS_TEXTURE);
        for (int i = 0; i < this.categories.size(); ++i) {
            class_332.method_25290((class_4587)matrices, (int)(8 + 32 * i), (int)8, (float)(i > 0 ? 28.0f : 0.0f), (float)(this.activeCategory == i ? 32.0f : 0.0f), (int)28, (int)32, (int)256, (int)256);
        }
        Vec2i mouse = this.getMousePos(mouseX, mouseY);
        for (int i = 0; i < this.categories.size(); ++i) {
            ClientSkillCategoryData category = this.categories.get(i);
            this.drawIcon(matrices, 8 + 32 * i + 6 + 8, 25, category.getIcon());
            if (!this.isInsideTab(mouse, i)) continue;
            this.tooltip = this.field_22793.method_1728((class_5348)category.getTitle(), 170);
        }
    }

    private void drawWindow(class_4587 matrices) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
        RenderSystem.disableDepthTest();
        RenderSystem.setShaderTexture((int)0, (class_2960)WINDOW_TEXTURE);
        class_332.method_25290((class_4587)matrices, (int)8, (int)(this.field_22790 - 8 - 70 + 1), (float)0.0f, (float)70.0f, (int)126, (int)70, (int)256, (int)256);
        class_332.method_25290((class_4587)matrices, (int)(this.field_22789 - 8 - 126 + 1), (int)(this.field_22790 - 8 - 70 + 1), (float)126.0f, (float)70.0f, (int)126, (int)70, (int)256, (int)256);
        DrawUtils.drawScaledTexture(matrices, 8, 78, 126, this.field_22790 - 16 - 140 + 1, 0, 69, 126, 2, 256, 256);
        DrawUtils.drawScaledTexture(matrices, 134, this.field_22790 - 8 - 70 + 1, this.field_22789 - 16 - 252 + 1, 70, 125, 70, 2, 70, 256, 256);
        DrawUtils.drawScaledTexture(matrices, this.field_22789 - 8 - 126 + 1, 78, 126, this.field_22790 - 16 - 140 + 1, 126, 69, 126, 2, 256, 256);
        if (this.small) {
            class_332.method_25290((class_4587)matrices, (int)8, (int)36, (float)0.0f, (float)0.0f, (int)126, (int)16, (int)256, (int)256);
            class_332.method_25290((class_4587)matrices, (int)8, (int)52, (float)0.0f, (float)8.0f, (int)126, (int)26, (int)256, (int)256);
            class_332.method_25290((class_4587)matrices, (int)(this.field_22789 - 8 - 126 + 1), (int)36, (float)126.0f, (float)0.0f, (int)126, (int)16, (int)256, (int)256);
            class_332.method_25290((class_4587)matrices, (int)(this.field_22789 - 8 - 126 + 1), (int)52, (float)126.0f, (float)8.0f, (int)126, (int)26, (int)256, (int)256);
            DrawUtils.drawScaledTexture(matrices, 134, 36, this.field_22789 - 16 - 252 + 1, 16, 125, 0, 2, 16, 256, 256);
            DrawUtils.drawScaledTexture(matrices, 134, 52, this.field_22789 - 16 - 252 + 1, 54, 125, 8, 2, 54, 256, 256);
        } else {
            class_332.method_25290((class_4587)matrices, (int)8, (int)36, (float)0.0f, (float)0.0f, (int)126, (int)42, (int)256, (int)256);
            class_332.method_25290((class_4587)matrices, (int)(this.field_22789 - 8 - 126 + 1), (int)36, (float)126.0f, (float)0.0f, (int)126, (int)42, (int)256, (int)256);
            DrawUtils.drawScaledTexture(matrices, 134, 36, this.field_22789 - 16 - 252 + 1, 70, 125, 0, 2, 70, 256, 256);
        }
        class_5250 tmpText = SkillsMod.createTranslatable("text", "skills", new Object[0]);
        int tmpX = 16;
        int tmpY = 42;
        this.field_22793.method_30883(matrices, (class_2561)tmpText, (float)tmpX, (float)tmpY, -12566464);
        int leftX = tmpX + this.field_22793.method_27525((class_5348)tmpText);
        tmpX = this.field_22789 - 8 - 7;
        tmpText = class_2561.method_43470((String)Integer.toString(this.getActiveCategory().getPointsLeft()));
        tmpX -= this.field_22793.method_27525((class_5348)tmpText);
        DrawUtils.drawTextWithBorder(matrices, (class_2561)tmpText, --tmpX, tmpY, -16777216, -8323296);
        --tmpX;
        tmpText = SkillsMod.createTranslatable("text", "points_left", new Object[0]);
        this.field_22793.method_30883(matrices, (class_2561)tmpText, (float)(tmpX -= this.field_22793.method_27525((class_5348)tmpText)), (float)tmpY, -12566464);
        int rightX = tmpX;
        if (this.getActiveCategory().getExperienceProgress() >= 0.0f) {
            if (this.small) {
                tmpX = this.field_22789 - 8 - 8 - 182;
                tmpY = 53;
            } else {
                tmpX = (leftX + rightX - 182) / 2;
                tmpY = 43;
            }
            RenderSystem.setShaderTexture((int)0, (class_2960)class_329.field_22737);
            this.method_25302(matrices, tmpX, tmpY, 0, 64, 182, 5);
            int width = Math.min(182, (int)(this.getActiveCategory().getExperienceProgress() * 183.0f));
            if (width > 0) {
                this.method_25302(matrices, tmpX, tmpY, 0, 69, width, 5);
            }
        }
    }
}

