/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.client.network.packets.in;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_189;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.puffish.skillsmod.client.data.ClientIconData;
import net.puffish.skillsmod.client.data.ClientSkillCategoryData;
import net.puffish.skillsmod.client.data.ClientSkillConnectionData;
import net.puffish.skillsmod.client.data.ClientSkillData;
import net.puffish.skillsmod.client.data.ClientSkillDefinitionData;
import net.puffish.skillsmod.json.JsonElementWrapper;
import net.puffish.skillsmod.network.InPacket;
import net.puffish.skillsmod.skill.SkillState;
import net.puffish.skillsmod.utils.JsonParseUtils;

public class ShowCategoryInPacket
implements InPacket {
    private final ClientSkillCategoryData category;

    private ShowCategoryInPacket(ClientSkillCategoryData category) {
        this.category = category;
    }

    public static ShowCategoryInPacket read(class_2540 buf) {
        ClientSkillCategoryData category = ShowCategoryInPacket.readCategory(buf);
        return new ShowCategoryInPacket(category);
    }

    public static ClientSkillCategoryData readCategory(class_2540 buf) {
        String id = buf.method_19772();
        int index = buf.readInt();
        class_2561 title = buf.method_10808();
        ClientIconData icon = ShowCategoryInPacket.readSkillIcon(buf);
        class_2960 background = buf.method_10810();
        Map<String, ClientSkillDefinitionData> definitions = buf.method_34066(ShowCategoryInPacket::readDefinition).stream().collect(Collectors.toMap(ClientSkillDefinitionData::getId, definition -> definition));
        Map<String, ClientSkillData> skills = buf.method_34066(ShowCategoryInPacket::readSkill).stream().collect(Collectors.toMap(ClientSkillData::getId, skill -> skill));
        List connections = buf.method_34066(ShowCategoryInPacket::readSkillConnection);
        int points = buf.readInt();
        Float experienceProgress = buf.method_37436(class_2540::readFloat).orElse(Float.valueOf(-1.0f));
        return new ClientSkillCategoryData(id, index, title, icon, background, definitions, skills, connections, points, experienceProgress.floatValue());
    }

    public static ClientSkillDefinitionData readDefinition(class_2540 buf) {
        String id = buf.method_19772();
        class_2561 title = buf.method_10808();
        class_2561 description = buf.method_10808();
        class_189 frame = (class_189)buf.method_10818(class_189.class);
        ClientIconData icon = ShowCategoryInPacket.readSkillIcon(buf);
        return new ClientSkillDefinitionData(id, title, description, frame, icon);
    }

    public static ClientIconData readSkillIcon(class_2540 buf) {
        String type = buf.method_19772();
        return buf.method_37436(class_2540::method_19772).flatMap(data -> JsonElementWrapper.parseString(data).getSuccess()).flatMap(rootElement -> switch (type) {
            case "item" -> JsonParseUtils.parseItemStack(rootElement).getSuccess().map(ClientIconData.ItemIconData::new);
            case "effect" -> rootElement.getAsObject().andThen(rootObject -> rootObject.get("effect")).andThen(JsonParseUtils::parseEffect).getSuccess().map(ClientIconData.EffectIconData::new);
            case "texture" -> rootElement.getAsObject().andThen(rootObject -> rootObject.get("texture")).andThen(JsonParseUtils::parseIdentifier).getSuccess().map(ClientIconData.TextureIconData::new);
            default -> Optional.empty();
        }).orElseGet(ClientIconData.TextureIconData::createMissing);
    }

    public static ClientSkillData readSkill(class_2540 buf) {
        String id = buf.method_19772();
        int x = buf.readInt();
        int y = buf.readInt();
        String definition = buf.method_19772();
        boolean isRoot = buf.readBoolean();
        SkillState state = (SkillState)buf.method_10818(SkillState.class);
        return new ClientSkillData(id, x, y, definition, isRoot, state);
    }

    public static ClientSkillConnectionData readSkillConnection(class_2540 buf) {
        String skillAId = buf.method_19772();
        String skillBId = buf.method_19772();
        return new ClientSkillConnectionData(skillAId, skillBId);
    }

    public ClientSkillCategoryData getCategory() {
        return this.category;
    }
}

