/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.experience.builtin;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1299;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_6885;
import net.minecraft.server.MinecraftServer;
import net.puffish.skillsmod.SkillsAPI;
import net.puffish.skillsmod.SkillsMod;
import net.puffish.skillsmod.experience.ExperienceSource;
import net.puffish.skillsmod.json.JsonElementWrapper;
import net.puffish.skillsmod.json.JsonObjectWrapper;
import net.puffish.skillsmod.json.JsonPath;
import net.puffish.skillsmod.utils.JsonParseUtils;
import net.puffish.skillsmod.utils.Result;
import net.puffish.skillsmod.utils.error.Error;
import net.puffish.skillsmod.utils.error.ManyErrors;

public class KillEntityExperienceSource
implements ExperienceSource {
    public static final class_2960 ID = SkillsMod.createIdentifier("kill_entity");
    private final List<Modifier> modifiers;
    private final AntiFarming antiFarming;

    public KillEntityExperienceSource(List<Modifier> modifiers, AntiFarming antiFarming) {
        this.modifiers = modifiers;
        this.antiFarming = antiFarming;
    }

    public static void register() {
        SkillsAPI.registerExperienceSource(ID, KillEntityExperienceSource::create);
    }

    private static Result<KillEntityExperienceSource, Error> create(Result<JsonElementWrapper, Error> maybeDataElement) {
        return maybeDataElement.andThen(KillEntityExperienceSource::create);
    }

    private static Result<KillEntityExperienceSource, Error> create(JsonElementWrapper rootElement) {
        return rootElement.getAsObject().andThen(KillEntityExperienceSource::create);
    }

    private static Result<KillEntityExperienceSource, Error> create(JsonObjectWrapper rootObject) {
        ArrayList<Error> errors = new ArrayList<Error>();
        List cases = rootObject.getArray("modifiers").getSuccess().flatMap(array -> array.getAsList((i, element) -> Modifier.parse(element)).mapFailure(ManyErrors::ofList).ifFailure(errors::add).getSuccess()).orElseGet(List::of);
        Optional optAntiFarming = rootObject.get("anti_farming").andThen(AntiFarming::parse).ifFailure(errors::add).getSuccess();
        if (errors.isEmpty()) {
            return Result.success(new KillEntityExperienceSource(cases, (AntiFarming)optAntiFarming.orElseThrow()));
        }
        return Result.failure(ManyErrors.ofList(errors));
    }

    @Override
    public void dispose(MinecraftServer server) {
    }

    public int getValue(class_1299<?> entityType, int value) {
        float fValue = value;
        for (Modifier modifier : this.modifiers) {
            fValue = modifier.testAndApply(entityType, fValue);
        }
        return Math.round(fValue);
    }

    public AntiFarming getAntiFarming() {
        return this.antiFarming;
    }

    public record AntiFarming(boolean enabled, int limitPerChunk, int resetAfterSeconds) {
        public static Result<AntiFarming, Error> parse(JsonElementWrapper rootElement) {
            return rootElement.getAsObject().andThen(AntiFarming::parse);
        }

        public static Result<AntiFarming, Error> parse(JsonObjectWrapper rootObject) {
            ArrayList<Error> errors = new ArrayList<Error>();
            Optional<Boolean> enabled = rootObject.getBoolean("enabled").ifFailure(errors::add).getSuccess();
            Optional<Integer> limitPerChunk = rootObject.getInt("limit_per_chunk").ifFailure(errors::add).getSuccess();
            Optional<Integer> resetAfterSeconds = rootObject.getInt("reset_after_seconds").ifFailure(errors::add).getSuccess();
            if (errors.isEmpty()) {
                return Result.success(new AntiFarming(enabled.orElseThrow(), limitPerChunk.orElseThrow(), resetAfterSeconds.orElseThrow()));
            }
            return Result.failure(ManyErrors.ofList(errors));
        }
    }

    private static abstract class Modifier {
        private final List<Condition> conditions;

        private Modifier(List<Condition> conditions) {
            this.conditions = conditions;
        }

        public static Result<Modifier, Error> parse(JsonElementWrapper rootElement) {
            return rootElement.getAsObject().andThen(Modifier::parse);
        }

        public static Result<Modifier, Error> parse(JsonObjectWrapper rootObject) {
            ArrayList<Error> errors = new ArrayList<Error>();
            List conditions = rootObject.getArray("conditions").getSuccess().flatMap(array -> array.getAsList((i, element) -> Condition.parse(element)).mapFailure(ManyErrors::ofList).ifFailure(errors::add).getSuccess()).orElseGet(List::of);
            Optional<JsonElementWrapper> optTypeElement = rootObject.get("type").ifFailure(errors::add).getSuccess();
            Optional optType = optTypeElement.flatMap(typeElement -> typeElement.getAsString().ifFailure(errors::add).getSuccess());
            Result<JsonElementWrapper, Error> maybeDataElement = rootObject.get("data");
            if (errors.isEmpty()) {
                return Modifier.build(conditions, (String)optType.orElseThrow(), maybeDataElement, optTypeElement.orElseThrow().getPath());
            }
            return Result.failure(ManyErrors.ofList(errors));
        }

        private static Result<Modifier, Error> build(List<Condition> conditions, String type, Result<JsonElementWrapper, Error> maybeDataElement, JsonPath typeElementPath) {
            return switch (type) {
                case "addition" -> maybeDataElement.andThen(dataElement -> AdditionModifier.parseInternal(conditions, dataElement).mapSuccess(tmp -> tmp));
                case "multiply" -> maybeDataElement.andThen(dataElement -> MultiplyModifier.parseInternal(conditions, dataElement).mapSuccess(tmp -> tmp));
                case "fixed" -> maybeDataElement.andThen(dataElement -> FixedModifier.parseInternal(conditions, dataElement).mapSuccess(tmp -> tmp));
                default -> Result.failure(typeElementPath.errorAt("Expected a valid modifier type"));
            };
        }

        protected abstract float apply(float var1);

        public float testAndApply(class_1299<?> entityType, float value) {
            if (this.conditions.stream().anyMatch(condition -> condition.test(entityType))) {
                return this.apply(value);
            }
            return value;
        }

        public static final class FixedModifier
        extends Modifier {
            private final float value;

            private FixedModifier(List<Condition> conditions, float value) {
                super(conditions);
                this.value = value;
            }

            public static Result<FixedModifier, Error> parseInternal(List<Condition> conditions, JsonElementWrapper rootElement) {
                return rootElement.getAsObject().andThen(rootObject -> FixedModifier.parseInternal(conditions, rootObject));
            }

            public static Result<FixedModifier, Error> parseInternal(List<Condition> conditions, JsonObjectWrapper rootObject) {
                ArrayList<Error> errors = new ArrayList<Error>();
                Optional<Float> optValue = rootObject.getFloat("value").ifFailure(errors::add).getSuccess();
                if (errors.isEmpty()) {
                    return Result.success(new FixedModifier(conditions, optValue.orElseThrow().floatValue()));
                }
                return Result.failure(ManyErrors.ofList(errors));
            }

            @Override
            public float apply(float value) {
                return this.value;
            }
        }

        public static final class MultiplyModifier
        extends Modifier {
            private final float value;

            private MultiplyModifier(List<Condition> conditions, float value) {
                super(conditions);
                this.value = value;
            }

            public static Result<MultiplyModifier, Error> parseInternal(List<Condition> conditions, JsonElementWrapper rootElement) {
                return rootElement.getAsObject().andThen(rootObject -> MultiplyModifier.parseInternal(conditions, rootObject));
            }

            public static Result<MultiplyModifier, Error> parseInternal(List<Condition> conditions, JsonObjectWrapper rootObject) {
                ArrayList<Error> errors = new ArrayList<Error>();
                Optional<Float> optValue = rootObject.getFloat("value").ifFailure(errors::add).getSuccess();
                if (errors.isEmpty()) {
                    return Result.success(new MultiplyModifier(conditions, optValue.orElseThrow().floatValue()));
                }
                return Result.failure(ManyErrors.ofList(errors));
            }

            @Override
            public float apply(float value) {
                return this.value * value;
            }
        }

        public static final class AdditionModifier
        extends Modifier {
            private final float value;

            private AdditionModifier(List<Condition> conditions, float value) {
                super(conditions);
                this.value = value;
            }

            public static Result<AdditionModifier, Error> parseInternal(List<Condition> conditions, JsonElementWrapper rootElement) {
                return rootElement.getAsObject().andThen(rootObject -> AdditionModifier.parseInternal(conditions, rootObject));
            }

            public static Result<AdditionModifier, Error> parseInternal(List<Condition> conditions, JsonObjectWrapper rootObject) {
                ArrayList<Error> errors = new ArrayList<Error>();
                Optional<Float> optValue = rootObject.getFloat("value").ifFailure(errors::add).getSuccess();
                if (errors.isEmpty()) {
                    return Result.success(new AdditionModifier(conditions, optValue.orElseThrow().floatValue()));
                }
                return Result.failure(ManyErrors.ofList(errors));
            }

            @Override
            public float apply(float value) {
                return this.value + value;
            }
        }
    }

    private static interface Condition {
        public boolean test(class_1299<?> var1);

        public static Result<Condition, Error> parse(JsonElementWrapper rootElement) {
            return rootElement.getAsObject().andThen(Condition::parse);
        }

        public static Result<Condition, Error> parse(JsonObjectWrapper rootObject) {
            ArrayList<Error> errors = new ArrayList<Error>();
            Optional<String> optType = rootObject.getString("type").ifFailure(errors::add).getSuccess();
            Result<JsonElementWrapper, Error> maybeDataElement = rootObject.get("data");
            if (errors.isEmpty()) {
                return Condition.build(optType.orElseThrow(), maybeDataElement, rootObject.getPath().thenObject("type"));
            }
            return Result.failure(ManyErrors.ofList(errors));
        }

        private static Result<Condition, Error> build(String type, Result<JsonElementWrapper, Error> maybeDataElement, JsonPath typeElementPath) {
            return switch (type) {
                case "entity" -> maybeDataElement.andThen(EntityCondition::parseInternal).mapSuccess(tmp -> tmp);
                case "tag" -> maybeDataElement.andThen(EntityTagCondition::parseInternal).mapSuccess(tmp -> tmp);
                default -> Result.failure(typeElementPath.errorAt("Expected a valid condition type"));
            };
        }

        public static final class EntityTagCondition
        implements Condition {
            private final class_6885.class_6888<class_1299<?>> entries;

            private EntityTagCondition(class_6885.class_6888<class_1299<?>> entries) {
                this.entries = entries;
            }

            public static Result<EntityTagCondition, Error> parseInternal(JsonElementWrapper rootElement) {
                return rootElement.getAsObject().andThen(EntityTagCondition::parseInternal);
            }

            public static Result<EntityTagCondition, Error> parseInternal(JsonObjectWrapper rootObject) {
                ArrayList<Error> errors = new ArrayList<Error>();
                Optional optTag = rootObject.get("tag").andThen(JsonParseUtils::parseEntityTypeTag).ifFailure(errors::add).getSuccess();
                if (errors.isEmpty()) {
                    return Result.success(new EntityTagCondition((class_6885.class_6888)optTag.orElseThrow()));
                }
                return Result.failure(ManyErrors.ofList(errors));
            }

            @Override
            public boolean test(class_1299<?> entityType) {
                return class_2378.field_11145.method_29113(entityType).map(key -> this.entries.method_40241(class_2378.field_11145.method_40290(key))).orElse(false);
            }
        }

        public static final class EntityCondition
        implements Condition {
            private final class_1299<?> entityType;

            private EntityCondition(class_1299<?> entityType) {
                this.entityType = entityType;
            }

            public static Result<EntityCondition, Error> parseInternal(JsonElementWrapper rootElement) {
                return rootElement.getAsObject().andThen(EntityCondition::parseInternal);
            }

            public static Result<EntityCondition, Error> parseInternal(JsonObjectWrapper rootObject) {
                ArrayList<Error> errors = new ArrayList<Error>();
                Optional optEntity = rootObject.get("entity").andThen(JsonParseUtils::parseEntityType).ifFailure(errors::add).getSuccess();
                if (errors.isEmpty()) {
                    return Result.success(new EntityCondition((class_1299)optEntity.orElseThrow()));
                }
                return Result.failure(ManyErrors.ofList(errors));
            }

            @Override
            public boolean test(class_1299<?> entityType) {
                return this.entityType == entityType;
            }
        }
    }
}

