/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.mixin;

import net.minecraft.class_1282;
import net.minecraft.class_1284;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_3222;
import net.puffish.skillsmod.SkillsAPI;
import net.puffish.skillsmod.access.EntityAttributeInstanceAccess;
import net.puffish.skillsmod.access.WorldChunkAccess;
import net.puffish.skillsmod.attributes.PlayerAttributes;
import net.puffish.skillsmod.experience.builtin.KillEntityExperienceSource;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin {
    @ModifyVariable(method={"damage"}, at=@At(value="HEAD"), ordinal=0, argsOnly=true)
    private float modifyVariableAtDamage(float damage, class_1282 source) {
        if (damage < 0.0f) {
            return damage;
        }
        class_1297 class_12972 = source.method_5529();
        if (class_12972 instanceof class_1657) {
            class_1657 player = (class_1657)class_12972;
            if (source instanceof class_1284) {
                attribute = (EntityAttributeInstanceAccess)player.method_5996(PlayerAttributes.RANGED_DAMAGE);
                damage = (float)attribute.computeValueForInitial(damage);
            } else {
                attribute = (EntityAttributeInstanceAccess)player.method_5996(PlayerAttributes.MELEE_DAMAGE);
                damage = (float)attribute.computeValueForInitial(damage);
            }
        }
        return damage;
    }

    @ModifyVariable(method={"heal"}, at=@At(value="HEAD"), ordinal=0, argsOnly=true)
    private float modifyVariableAtHeal(float amount) {
        if (amount < 0.0f) {
            return amount;
        }
        class_1309 class_13092 = (class_1309)this;
        if (class_13092 instanceof class_1657) {
            class_1657 player = (class_1657)class_13092;
            EntityAttributeInstanceAccess attribute = (EntityAttributeInstanceAccess)player.method_5996(PlayerAttributes.HEALING);
            amount = (float)attribute.computeValueForInitial(amount);
        }
        return amount;
    }

    @Inject(method={"getJumpVelocity"}, at={@At(value="RETURN")}, cancellable=true)
    private void injectAtGetJumpVelocity(CallbackInfoReturnable<Float> cir) {
        class_1309 class_13092 = (class_1309)this;
        if (class_13092 instanceof class_1657) {
            class_1657 player = (class_1657)class_13092;
            EntityAttributeInstanceAccess attribute = (EntityAttributeInstanceAccess)player.method_5996(PlayerAttributes.JUMP);
            cir.setReturnValue((Object)Float.valueOf((float)attribute.computeValueForInitial(cir.getReturnValueF())));
        }
    }

    @ModifyVariable(method={"computeFallDamage"}, at=@At(value="STORE"), ordinal=2)
    private float modifyVariableAtComputeFallDamage(float reduction) {
        class_1309 class_13092 = (class_1309)this;
        if (class_13092 instanceof class_1657) {
            class_1657 player = (class_1657)class_13092;
            EntityAttributeInstanceAccess attribute = (EntityAttributeInstanceAccess)player.method_5996(PlayerAttributes.JUMP);
            reduction = (float)((double)reduction + (attribute.computeValueForInitial(1.0) - 1.0) * 10.0);
        }
        return reduction;
    }

    @Inject(method={"drop"}, at={@At(value="HEAD")})
    private void injectAtDrop(class_1282 source, CallbackInfo ci) {
        class_1297 class_12972 = source.method_5529();
        if (class_12972 instanceof class_3222) {
            class_3222 player = (class_3222)class_12972;
            class_1309 entity = (class_1309)this;
            if (entity.method_6054()) {
                WorldChunkAccess worldChunk = (WorldChunkAccess)entity.method_37908().method_8500(entity.method_24515());
                worldChunk.antiFarmingCleanupOutdated();
                SkillsAPI.visitExperienceSources(player, experienceSource -> {
                    KillEntityExperienceSource entityExperienceSource;
                    if (experienceSource instanceof KillEntityExperienceSource && worldChunk.antiFarmingAddAndCheck((entityExperienceSource = (KillEntityExperienceSource)experienceSource).getAntiFarming())) {
                        return entityExperienceSource.getValue(entity.method_5864(), entity.method_6110());
                    }
                    return 0;
                });
            }
        }
    }

    @Inject(method={"modifyAppliedDamage"}, at={@At(value="TAIL")}, cancellable=true)
    private void injectAtModifyAppliedDamage(CallbackInfoReturnable<Float> cir) {
        class_1309 class_13092 = (class_1309)this;
        if (class_13092 instanceof class_1657) {
            class_1657 player = (class_1657)class_13092;
            if (cir.getReturnValueF() < 1.1342745E38f) {
                EntityAttributeInstanceAccess attribute = (EntityAttributeInstanceAccess)player.method_5996(PlayerAttributes.RESISTANCE);
                cir.setReturnValue((Object)Float.valueOf(Math.max(0.0f, 2.0f * cir.getReturnValueF() - (float)attribute.computeValueForInitial(cir.getReturnValueF()))));
            }
        }
    }
}

