/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.server.data;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.puffish.skillsmod.config.experience.ExperienceConfig;

public class CategoryData {
    private final Set<String> unlockedSkills;
    private boolean unlocked;
    private int points;
    private int experience;

    private CategoryData(Set<String> unlockedSkills, boolean unlocked, int points, int experience) {
        this.unlockedSkills = unlockedSkills;
        this.unlocked = unlocked;
        this.points = points;
        this.experience = experience;
    }

    public static CategoryData create(boolean unlocked) {
        return new CategoryData(new HashSet<String>(), unlocked, 0, 0);
    }

    public static CategoryData read(class_2487 nbt) {
        boolean unlocked = nbt.method_10577("unlocked");
        int points = nbt.method_10550("points");
        int experience = nbt.method_10550("experience");
        HashSet<String> unlockedSkills = new HashSet<String>();
        class_2499 unlockedNbt = nbt.method_10554("unlocked_skills", 8);
        for (class_2520 elementNbt : unlockedNbt) {
            if (!(elementNbt instanceof class_2519)) continue;
            class_2519 stringNbt = (class_2519)elementNbt;
            unlockedSkills.add(stringNbt.method_10714());
        }
        return new CategoryData(unlockedSkills, unlocked, points, experience);
    }

    public class_2487 writeNbt(class_2487 nbt) {
        nbt.method_10556("unlocked", this.unlocked);
        nbt.method_10569("points", this.points);
        nbt.method_10569("experience", this.experience);
        class_2499 unlockedNbt = new class_2499();
        for (String skill : this.unlockedSkills) {
            unlockedNbt.add((Object)class_2519.method_23256((String)skill));
        }
        nbt.method_10566("unlocked_skills", (class_2520)unlockedNbt);
        return nbt;
    }

    public void unlockSkill(String id) {
        this.unlockedSkills.add(id);
    }

    public void resetSkills() {
        this.unlockedSkills.clear();
    }

    public void addExperience(int experience) {
        this.experience += experience;
    }

    public Set<String> getUnlockedSkillIds() {
        return this.unlockedSkills;
    }

    public int getExperience() {
        return this.experience;
    }

    public void setExperience(int experience) {
        this.experience = experience;
    }

    public int getPointsForExperience(ExperienceConfig experience) {
        if (!experience.isEnabled()) {
            return 0;
        }
        return experience.getLevel(this);
    }

    public int getSpentPoints() {
        return this.getUnlockedSkillIds().size();
    }

    public int getPointsLeft(ExperienceConfig experience) {
        return this.getExtraPoints() + this.getPointsForExperience(experience) - this.getSpentPoints();
    }

    public void setPointsLeft(int count, ExperienceConfig experience) {
        this.addExtraPoints(count - this.getPointsLeft(experience));
    }

    public void addExtraPoints(int count) {
        this.points += count;
    }

    public int getExtraPoints() {
        return this.points;
    }

    public void setExtraPoints(int points) {
        this.points = points;
    }

    public boolean isUnlocked() {
        return this.unlocked;
    }

    public void setUnlocked(boolean unlocked) {
        this.unlocked = unlocked;
    }
}

