/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.server.network.packets.out;

import java.util.Optional;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.puffish.skillsmod.config.CategoryConfig;
import net.puffish.skillsmod.config.GeneralConfig;
import net.puffish.skillsmod.config.IconConfig;
import net.puffish.skillsmod.config.experience.ExperienceConfig;
import net.puffish.skillsmod.config.skill.SkillConfig;
import net.puffish.skillsmod.config.skill.SkillConnectionConfig;
import net.puffish.skillsmod.config.skill.SkillConnectionsConfig;
import net.puffish.skillsmod.config.skill.SkillDefinitionConfig;
import net.puffish.skillsmod.config.skill.SkillDefinitionsConfig;
import net.puffish.skillsmod.config.skill.SkillsConfig;
import net.puffish.skillsmod.network.OutPacket;
import net.puffish.skillsmod.network.Packets;
import net.puffish.skillsmod.server.data.CategoryData;

public class ShowCategoryOutPacket
extends OutPacket {
    public ShowCategoryOutPacket(CategoryConfig category, CategoryData categoryData) {
        this.write(category, categoryData);
    }

    private void write(CategoryConfig category, CategoryData categoryData) {
        this.buf.method_10814(category.getId());
        this.buf.writeInt(category.getIndex());
        this.write(category.getGeneral());
        this.write(category.getDefinitions());
        this.write(category.getSkills(), category, categoryData);
        this.write(category.getConnections());
        this.write(category.getExperience(), categoryData);
    }

    private void write(SkillDefinitionsConfig definitions) {
        this.buf.method_34062(definitions.getAll(), (buf2, definition) -> this.write((SkillDefinitionConfig)definition));
    }

    private void write(GeneralConfig general) {
        this.buf.method_10805(general.getTitle());
        this.write(general.getIcon());
        this.buf.method_10812(general.getBackground());
    }

    private void write(SkillDefinitionConfig definition) {
        this.buf.method_10814(definition.getId());
        this.buf.method_10805(definition.getTitle());
        this.buf.method_10805(definition.getDescription());
        this.buf.method_10817((Enum)definition.getFrame());
        this.write(definition.getIcon());
    }

    private void write(ExperienceConfig experience, CategoryData categoryData) {
        this.buf.writeInt(categoryData.getPointsLeft(experience));
        if (experience.isEnabled()) {
            this.buf.method_37435(Optional.of(Float.valueOf(experience.getProgress(categoryData))), class_2540::writeFloat);
        } else {
            this.buf.method_37435(Optional.empty(), class_2540::writeFloat);
        }
    }

    private void write(SkillsConfig skills, CategoryConfig category, CategoryData categoryData) {
        this.buf.method_34062(skills.getAll(), (buf2, skill) -> this.write((SkillConfig)skill, category, categoryData));
    }

    private void write(SkillConnectionsConfig connections) {
        this.buf.method_34062(connections.getAll(), (buf2, connection) -> this.write((SkillConnectionConfig)connection));
    }

    private void write(SkillConfig skill, CategoryConfig category, CategoryData categoryData) {
        this.buf.method_10814(skill.getId());
        this.buf.writeInt(skill.getX());
        this.buf.writeInt(skill.getY());
        this.buf.method_10814(skill.getDefinitionId());
        this.buf.writeBoolean(skill.isRoot());
        this.buf.method_10817((Enum)skill.getStateFor(category, categoryData));
    }

    private void write(SkillConnectionConfig skill) {
        this.buf.method_10814(skill.getSkillAId());
        this.buf.method_10814(skill.getSkillBId());
    }

    private void write(IconConfig icon) {
        this.buf.method_10814(icon.getType());
        this.buf.method_43826((Object)icon.getData(), (buf1, element) -> buf1.method_10814(element.toString()));
    }

    @Override
    public class_2960 getIdentifier() {
        return Packets.SHOW_CATEGORY;
    }
}

