/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.utils;

import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.class_1291;
import net.minecraft.class_1299;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_189;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2522;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_4559;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6885;
import net.puffish.skillsmod.json.JsonElementWrapper;
import net.puffish.skillsmod.utils.Result;
import net.puffish.skillsmod.utils.error.Error;
import net.puffish.skillsmod.utils.error.ManyErrors;
import net.puffish.skillsmod.utils.error.SingleError;

public class JsonParseUtils {
    public static Result<class_2960, Error> parseIdentifier(JsonElementWrapper element) {
        try {
            return Result.success(new class_2960(class_3518.method_15287((JsonElement)element.getJson(), (String)"")));
        }
        catch (Exception e) {
            return Result.failure(SingleError.of("Expected valid nbt at " + element.getPath().toString()));
        }
    }

    public static Result<class_1291, Error> parseEffect(JsonElementWrapper element) {
        try {
            return JsonParseUtils.parseIdentifier(element).mapSuccess(id -> (class_1291)class_2378.field_11159.method_17966(id).orElseThrow());
        }
        catch (Exception e) {
            return Result.failure(SingleError.of("Expected valid effect at " + element.getPath().toString()));
        }
    }

    public static Result<class_2248, Error> parseBlock(JsonElementWrapper element) {
        try {
            return JsonParseUtils.parseIdentifier(element).mapSuccess(id -> (class_2248)class_2378.field_11146.method_17966(id).orElseThrow());
        }
        catch (Exception e) {
            return Result.failure(SingleError.of("Expected valid block at " + element.getPath().toString()));
        }
    }

    public static Result<class_4559, Error> parseStatePredicate(JsonElementWrapper element) {
        try {
            return Result.success(class_4559.method_22519((JsonElement)element.getJson()));
        }
        catch (Exception e) {
            return Result.failure(SingleError.of("Expected valid state predicate at " + element.getPath().toString()));
        }
    }

    public static Result<class_6885.class_6888<class_2248>, Error> parseBlockTag(JsonElementWrapper element) {
        try {
            return JsonParseUtils.parseIdentifier(element).mapSuccess(id -> (class_6885.class_6888)class_2378.field_11146.method_40266(class_6862.method_40092((class_5321)class_2378.field_25105, (class_2960)id)).orElseThrow());
        }
        catch (Exception e) {
            return Result.failure(SingleError.of("Expected valid block tag at " + element.getPath().toString()));
        }
    }

    public static Result<class_1299<?>, Error> parseEntityType(JsonElementWrapper element) {
        try {
            return JsonParseUtils.parseIdentifier(element).mapSuccess(id -> (class_1299)class_2378.field_11145.method_17966(id).orElseThrow());
        }
        catch (Exception e) {
            return Result.failure(SingleError.of("Expected valid entity at " + element.getPath().toString()));
        }
    }

    public static Result<class_6885.class_6888<class_1299<?>>, Error> parseEntityTypeTag(JsonElementWrapper element) {
        try {
            return JsonParseUtils.parseIdentifier(element).mapSuccess(id -> (class_6885.class_6888)class_2378.field_11145.method_40266(class_6862.method_40092((class_5321)class_2378.field_25107, (class_2960)id)).orElseThrow());
        }
        catch (Exception e) {
            return Result.failure(SingleError.of("Expected valid entity tag at " + element.getPath().toString()));
        }
    }

    public static Result<class_1792, Error> parseItem(JsonElementWrapper element) {
        try {
            return Result.success(class_3518.method_15256((JsonElement)element.getJson(), (String)""));
        }
        catch (Exception e) {
            return Result.failure(SingleError.of("Expected valid item at " + element.getPath().toString()));
        }
    }

    public static Result<class_2487, Error> parseNbt(JsonElementWrapper element) {
        try {
            return Result.success(class_2522.method_10718((String)class_3518.method_15287((JsonElement)element.getJson(), (String)"")));
        }
        catch (Exception e) {
            return Result.failure(SingleError.of("Expected valid nbt at " + element.getPath().toString()));
        }
    }

    public static Result<class_1799, Error> parseItemStack(JsonElementWrapper element) {
        try {
            return element.getAsObject().andThen(object -> {
                ArrayList<Error> errors = new ArrayList<Error>();
                Optional item = object.get("item").andThen(JsonParseUtils::parseItem).ifFailure(errors::add).getSuccess();
                Optional nbt = object.get("nbt").getSuccess().flatMap(nbtElement -> JsonParseUtils.parseNbt(nbtElement).ifFailure(errors::add).getSuccess());
                if (errors.isEmpty()) {
                    class_1799 itemStack = new class_1799((class_1935)item.orElseThrow());
                    nbt.ifPresent(arg_0 -> ((class_1799)itemStack).method_7980(arg_0));
                    return Result.success(itemStack);
                }
                return Result.failure(ManyErrors.ofList(errors));
            });
        }
        catch (Exception e) {
            return Result.failure(SingleError.of("Expected valid item stack at " + element.getPath().toString()));
        }
    }

    public static Result<class_189, Error> parseFrame(JsonElementWrapper element) {
        try {
            return element.getAsString().andThen(name -> Result.success(class_189.method_833((String)name)));
        }
        catch (Exception e) {
            return Result.failure(SingleError.of("Expected valid frame at " + element.getPath().toString()));
        }
    }

    public static Result<class_2561, Error> parseText(JsonElementWrapper element) {
        try {
            return Result.success(class_2561.class_2562.method_10872((JsonElement)element.getJson()));
        }
        catch (Exception e) {
            return Result.failure(SingleError.of("Expected valid text at " + element.getPath().toString()));
        }
    }

    public static Result<class_1320, Error> parseAttribute(JsonElementWrapper element) {
        try {
            return JsonParseUtils.parseIdentifier(element).mapSuccess(id -> (class_1320)class_2378.field_23781.method_17966(id).orElseThrow());
        }
        catch (Exception e) {
            return Result.failure(SingleError.of("Expected valid attribute at " + element.getPath().toString()));
        }
    }

    public static Result<class_1322.class_1323, Error> parseAttributeOperation(JsonElementWrapper element) {
        return element.getAsString().andThen(string -> switch (string) {
            case "addition" -> Result.success(class_1322.class_1323.field_6328);
            case "multiply_base" -> Result.success(class_1322.class_1323.field_6330);
            case "multiply_total" -> Result.success(class_1322.class_1323.field_6331);
            default -> Result.failure(SingleError.of("Expected valid attribute operation at " + element.getPath().toString()));
        });
    }
}

