/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.config;

import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.puffish.skillsmod.config.GeneralConfig;
import net.puffish.skillsmod.config.experience.ExperienceConfig;
import net.puffish.skillsmod.config.skill.SkillConnectionsConfig;
import net.puffish.skillsmod.config.skill.SkillDefinitionConfig;
import net.puffish.skillsmod.config.skill.SkillDefinitionsConfig;
import net.puffish.skillsmod.config.skill.SkillRewardConfig;
import net.puffish.skillsmod.config.skill.SkillsConfig;
import net.puffish.skillsmod.json.JsonElementWrapper;
import net.puffish.skillsmod.server.data.CategoryData;
import net.puffish.skillsmod.skill.SkillState;
import net.puffish.skillsmod.utils.Result;
import net.puffish.skillsmod.utils.error.Error;
import net.puffish.skillsmod.utils.error.ManyErrors;

public class CategoryConfig {
    private final String id;
    private final int index;
    private final GeneralConfig general;
    private final SkillDefinitionsConfig definitions;
    private final SkillsConfig skills;
    private final SkillConnectionsConfig connections;
    private final ExperienceConfig experience;

    private CategoryConfig(String id, int index, GeneralConfig general, SkillDefinitionsConfig definitions, SkillsConfig skills, SkillConnectionsConfig connections, ExperienceConfig experience) {
        this.id = id;
        this.index = index;
        this.general = general;
        this.definitions = definitions;
        this.skills = skills;
        this.connections = connections;
        this.experience = experience;
    }

    public static Result<CategoryConfig, Error> parse(String id, int index, JsonElementWrapper generalElement, JsonElementWrapper definitionsElement, JsonElementWrapper skillsElement, JsonElementWrapper connectionsElement, JsonElementWrapper experienceElement) {
        ArrayList<Error> errors = new ArrayList<Error>();
        Optional<GeneralConfig> optGeneral = GeneralConfig.parse(generalElement).ifFailure(errors::add).getSuccess();
        Optional<ExperienceConfig> optExperience = ExperienceConfig.parse(experienceElement).ifFailure(errors::add).getSuccess();
        Optional<SkillDefinitionsConfig> optDefinitions = SkillDefinitionsConfig.parse(definitionsElement).ifFailure(errors::add).getSuccess();
        Optional optSkills = optDefinitions.flatMap(definitions -> SkillsConfig.parse(skillsElement, definitions).ifFailure(errors::add).getSuccess());
        Optional optConnections = optSkills.flatMap(skills -> SkillConnectionsConfig.parse(connectionsElement, skills).ifFailure(errors::add).getSuccess());
        if (errors.isEmpty()) {
            return Result.success(new CategoryConfig(id, index, optGeneral.orElseThrow(), optDefinitions.orElseThrow(), (SkillsConfig)optSkills.orElseThrow(), (SkillConnectionsConfig)optConnections.orElseThrow(), optExperience.orElseThrow()));
        }
        return Result.failure(ManyErrors.ofList(errors));
    }

    public boolean tryUnlockSkill(ServerPlayer player, CategoryData categoryData, String skillId) {
        return this.skills.getById(skillId).map(skill -> {
            if (skill.getStateFor(this, categoryData) != SkillState.AVAILABLE) {
                return false;
            }
            categoryData.unlockSkill(skillId);
            String definitionId = skill.getDefinitionId();
            this.definitions.getById(definitionId).ifPresent(definition -> {
                int count = this.countUnlocked(categoryData, definitionId);
                for (SkillRewardConfig reward : definition.getRewards()) {
                    reward.getInstance().update(player, count);
                }
            });
            return true;
        }).orElse(false);
    }

    public void refreshReward(ServerPlayer player, CategoryData categoryData, ResourceLocation type) {
        for (SkillDefinitionConfig definition : this.definitions.getAll()) {
            int count = this.countUnlocked(categoryData, definition.getId());
            for (SkillRewardConfig reward : definition.getRewards()) {
                if (!reward.getType().equals((Object)type)) continue;
                reward.getInstance().update(player, count);
            }
        }
    }

    public void applyRewards(ServerPlayer player, CategoryData categoryData) {
        for (SkillDefinitionConfig definition : this.definitions.getAll()) {
            int count = this.countUnlocked(categoryData, definition.getId());
            for (SkillRewardConfig reward : definition.getRewards()) {
                reward.getInstance().update(player, count);
            }
        }
    }

    public void resetRewards(ServerPlayer player) {
        for (SkillDefinitionConfig definition : this.definitions.getAll()) {
            for (SkillRewardConfig reward : definition.getRewards()) {
                reward.getInstance().update(player, 0);
            }
        }
    }

    public int countUnlocked(CategoryData categoryData, String definitionId) {
        return (int)this.skills.getAll().stream().filter(skill -> skill.getDefinitionId().equals(definitionId) && skill.getStateFor(this, categoryData) == SkillState.UNLOCKED).count();
    }

    public void dispose(MinecraftServer server) {
        this.definitions.dispose(server);
        this.experience.dispose(server);
    }

    public String getId() {
        return this.id;
    }

    public int getIndex() {
        return this.index;
    }

    public GeneralConfig getGeneral() {
        return this.general;
    }

    public SkillDefinitionsConfig getDefinitions() {
        return this.definitions;
    }

    public SkillsConfig getSkills() {
        return this.skills;
    }

    public SkillConnectionsConfig getConnections() {
        return this.connections;
    }

    public ExperienceConfig getExperience() {
        return this.experience;
    }
}

