/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.utils;

import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.puffish.skillsmod.json.JsonElementWrapper;
import net.puffish.skillsmod.utils.Result;
import net.puffish.skillsmod.utils.error.Error;
import net.puffish.skillsmod.utils.error.ManyErrors;
import net.puffish.skillsmod.utils.error.SingleError;

public class JsonParseUtils {
    public static Result<ResourceLocation, Error> parseIdentifier(JsonElementWrapper element) {
        try {
            return Result.success(new ResourceLocation(GsonHelper.m_13805_((JsonElement)element.getJson(), (String)"")));
        }
        catch (Exception e) {
            return Result.failure(SingleError.of("Expected valid nbt at " + element.getPath().toString()));
        }
    }

    public static Result<MobEffect, Error> parseEffect(JsonElementWrapper element) {
        try {
            return JsonParseUtils.parseIdentifier(element).mapSuccess(id -> (MobEffect)Registry.f_122823_.m_6612_(id).orElseThrow());
        }
        catch (Exception e) {
            return Result.failure(SingleError.of("Expected valid effect at " + element.getPath().toString()));
        }
    }

    public static Result<Block, Error> parseBlock(JsonElementWrapper element) {
        try {
            return JsonParseUtils.parseIdentifier(element).mapSuccess(id -> (Block)Registry.f_122824_.m_6612_(id).orElseThrow());
        }
        catch (Exception e) {
            return Result.failure(SingleError.of("Expected valid block at " + element.getPath().toString()));
        }
    }

    public static Result<StatePropertiesPredicate, Error> parseStatePredicate(JsonElementWrapper element) {
        try {
            return Result.success(StatePropertiesPredicate.m_67679_((JsonElement)element.getJson()));
        }
        catch (Exception e) {
            return Result.failure(SingleError.of("Expected valid state predicate at " + element.getPath().toString()));
        }
    }

    public static Result<HolderSet.Named<Block>, Error> parseBlockTag(JsonElementWrapper element) {
        try {
            return JsonParseUtils.parseIdentifier(element).mapSuccess(id -> (HolderSet.Named)Registry.f_122824_.m_203431_(TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)id)).orElseThrow());
        }
        catch (Exception e) {
            return Result.failure(SingleError.of("Expected valid block tag at " + element.getPath().toString()));
        }
    }

    public static Result<EntityType<?>, Error> parseEntityType(JsonElementWrapper element) {
        try {
            return JsonParseUtils.parseIdentifier(element).mapSuccess(id -> (EntityType)Registry.f_122826_.m_6612_(id).orElseThrow());
        }
        catch (Exception e) {
            return Result.failure(SingleError.of("Expected valid entity at " + element.getPath().toString()));
        }
    }

    public static Result<HolderSet.Named<EntityType<?>>, Error> parseEntityTypeTag(JsonElementWrapper element) {
        try {
            return JsonParseUtils.parseIdentifier(element).mapSuccess(id -> (HolderSet.Named)Registry.f_122826_.m_203431_(TagKey.m_203882_((ResourceKey)Registry.f_122903_, (ResourceLocation)id)).orElseThrow());
        }
        catch (Exception e) {
            return Result.failure(SingleError.of("Expected valid entity tag at " + element.getPath().toString()));
        }
    }

    public static Result<Item, Error> parseItem(JsonElementWrapper element) {
        try {
            return Result.success(GsonHelper.m_13874_((JsonElement)element.getJson(), (String)""));
        }
        catch (Exception e) {
            return Result.failure(SingleError.of("Expected valid item at " + element.getPath().toString()));
        }
    }

    public static Result<CompoundTag, Error> parseNbt(JsonElementWrapper element) {
        try {
            return Result.success(TagParser.m_129359_((String)GsonHelper.m_13805_((JsonElement)element.getJson(), (String)"")));
        }
        catch (Exception e) {
            return Result.failure(SingleError.of("Expected valid nbt at " + element.getPath().toString()));
        }
    }

    public static Result<ItemStack, Error> parseItemStack(JsonElementWrapper element) {
        try {
            return element.getAsObject().andThen(object -> {
                ArrayList<Error> errors = new ArrayList<Error>();
                Optional item = object.get("item").andThen(JsonParseUtils::parseItem).ifFailure(errors::add).getSuccess();
                Optional nbt = object.get("nbt").getSuccess().flatMap(nbtElement -> JsonParseUtils.parseNbt(nbtElement).ifFailure(errors::add).getSuccess());
                if (errors.isEmpty()) {
                    ItemStack itemStack = new ItemStack((ItemLike)item.orElseThrow());
                    nbt.ifPresent(arg_0 -> ((ItemStack)itemStack).m_41751_(arg_0));
                    return Result.success(itemStack);
                }
                return Result.failure(ManyErrors.ofList(errors));
            });
        }
        catch (Exception e) {
            return Result.failure(SingleError.of("Expected valid item stack at " + element.getPath().toString()));
        }
    }

    public static Result<FrameType, Error> parseFrame(JsonElementWrapper element) {
        try {
            return element.getAsString().andThen(name -> Result.success(FrameType.m_15549_((String)name)));
        }
        catch (Exception e) {
            return Result.failure(SingleError.of("Expected valid frame at " + element.getPath().toString()));
        }
    }

    public static Result<Component, Error> parseText(JsonElementWrapper element) {
        try {
            return Result.success(Component.Serializer.m_130691_((JsonElement)element.getJson()));
        }
        catch (Exception e) {
            return Result.failure(SingleError.of("Expected valid text at " + element.getPath().toString()));
        }
    }

    public static Result<Attribute, Error> parseAttribute(JsonElementWrapper element) {
        try {
            return JsonParseUtils.parseIdentifier(element).mapSuccess(id -> (Attribute)Registry.f_122866_.m_6612_(id).orElseThrow());
        }
        catch (Exception e) {
            return Result.failure(SingleError.of("Expected valid attribute at " + element.getPath().toString()));
        }
    }

    public static Result<AttributeModifier.Operation, Error> parseAttributeOperation(JsonElementWrapper element) {
        return element.getAsString().andThen(string -> switch (string) {
            case "addition" -> Result.success(AttributeModifier.Operation.ADDITION);
            case "multiply_base" -> Result.success(AttributeModifier.Operation.MULTIPLY_BASE);
            case "multiply_total" -> Result.success(AttributeModifier.Operation.MULTIPLY_TOTAL);
            default -> Result.failure(SingleError.of("Expected valid attribute operation at " + element.getPath().toString()));
        });
    }
}

