/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.client.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.puffish.skillsmod.client.data.ClientIconData;
import net.puffish.skillsmod.client.data.ClientSkillConnectionData;
import net.puffish.skillsmod.client.data.ClientSkillData;
import net.puffish.skillsmod.client.data.ClientSkillDefinitionData;
import net.puffish.skillsmod.skill.SkillState;
import net.puffish.skillsmod.utils.Bounds2i;
import org.joml.Vector2i;

public class ClientSkillCategoryData {
    private final String id;
    private final int index;
    private final class_2561 title;
    private final ClientIconData icon;
    private final class_2960 background;
    private final Map<String, ClientSkillDefinitionData> definitions;
    private final Map<String, ClientSkillData> skills;
    private final Collection<ClientSkillConnectionData> connections;
    private final Map<String, Collection<String>> neighbors;
    private int pointsLeft;
    private float experienceProgress;

    public ClientSkillCategoryData(String id, int index, class_2561 title, ClientIconData icon, class_2960 background, Map<String, ClientSkillDefinitionData> definitions, Map<String, ClientSkillData> skills, Collection<ClientSkillConnectionData> connections, int pointsLeft, float experienceProgress) {
        this.id = id;
        this.index = index;
        this.title = title;
        this.icon = icon;
        this.background = background;
        this.definitions = definitions;
        this.skills = skills;
        this.connections = connections;
        this.neighbors = new HashMap<String, Collection<String>>();
        this.pointsLeft = pointsLeft;
        this.experienceProgress = experienceProgress;
        for (ClientSkillConnectionData connection : connections) {
            this.neighbors.compute(connection.getSkillAId(), (key, value) -> {
                if (value == null) {
                    value = new ArrayList<String>();
                }
                value.add(connection.getSkillBId());
                return value;
            });
            this.neighbors.compute(connection.getSkillBId(), (key, value) -> {
                if (value == null) {
                    value = new ArrayList<String>();
                }
                value.add(connection.getSkillAId());
                return value;
            });
        }
    }

    public Bounds2i getBounds() {
        Bounds2i bounds = Bounds2i.zero();
        for (ClientSkillData skill : this.skills.values()) {
            bounds.extend(new Vector2i(skill.getX(), skill.getY()));
        }
        return bounds;
    }

    public void unlock(String skillId) {
        ClientSkillData skill = this.skills.get(skillId);
        if (skill == null) {
            return;
        }
        skill.setState(SkillState.UNLOCKED);
        if (skill.isRoot()) {
            for (ClientSkillData otherSkill : this.skills.values()) {
                if (!otherSkill.isRoot() || otherSkill.getState() != SkillState.AVAILABLE) continue;
                otherSkill.setState(SkillState.LOCKED);
            }
        }
        for (String neighborId : this.neighbors.get(skillId)) {
            ClientSkillData neighbor = this.skills.get(neighborId);
            if (neighbor == null || neighbor.getState() != SkillState.LOCKED) continue;
            neighbor.setState(SkillState.AVAILABLE);
        }
    }

    public String getId() {
        return this.id;
    }

    public int getIndex() {
        return this.index;
    }

    public Map<String, ClientSkillDefinitionData> getDefinitions() {
        return this.definitions;
    }

    public Map<String, ClientSkillData> getSkills() {
        return this.skills;
    }

    public Collection<ClientSkillConnectionData> getConnections() {
        return this.connections;
    }

    public Map<String, Collection<String>> getNeighbors() {
        return this.neighbors;
    }

    public class_2561 getTitle() {
        return this.title;
    }

    public ClientIconData getIcon() {
        return this.icon;
    }

    public class_2960 getBackground() {
        return this.background;
    }

    public int getPointsLeft() {
        return this.pointsLeft;
    }

    public void setPointsLeft(int pointsLeft) {
        this.pointsLeft = pointsLeft;
    }

    public float getExperienceProgress() {
        return this.experienceProgress;
    }

    public void setExperienceProgress(float experienceProgress) {
        this.experienceProgress = experienceProgress;
    }
}

