/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.config.skill;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import net.minecraft.server.MinecraftServer;
import net.puffish.skillsmod.config.skill.SkillDefinitionConfig;
import net.puffish.skillsmod.json.JsonElementWrapper;
import net.puffish.skillsmod.json.JsonObjectWrapper;
import net.puffish.skillsmod.utils.Result;
import net.puffish.skillsmod.utils.error.Error;
import net.puffish.skillsmod.utils.error.ManyErrors;

public class SkillDefinitionsConfig {
    private final Map<String, SkillDefinitionConfig> definitions;

    private SkillDefinitionsConfig(Map<String, SkillDefinitionConfig> definitions) {
        this.definitions = definitions;
    }

    public static Result<SkillDefinitionsConfig, Error> parse(JsonElementWrapper rootElement) {
        return rootElement.getAsObject().andThen(SkillDefinitionsConfig::parse);
    }

    public static Result<SkillDefinitionsConfig, Error> parse(JsonObjectWrapper rootObject) {
        return rootObject.getAsMap(SkillDefinitionConfig::parse).mapFailure(errors -> ManyErrors.ofList(errors)).mapSuccess(SkillDefinitionsConfig::new);
    }

    public Optional<SkillDefinitionConfig> getById(String id) {
        return Optional.ofNullable(this.definitions.get(id));
    }

    public Collection<SkillDefinitionConfig> getAll() {
        return this.definitions.values();
    }

    public void dispose(MinecraftServer server) {
        for (SkillDefinitionConfig definition : this.definitions.values()) {
            definition.dispose(server);
        }
    }
}

