/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.server.data;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.puffish.skillsmod.config.CategoryConfig;
import net.puffish.skillsmod.server.data.CategoryData;

public class PlayerData {
    private final Map<String, CategoryData> categories;

    private PlayerData(Map<String, CategoryData> categories) {
        this.categories = categories;
    }

    public static PlayerData empty() {
        return new PlayerData(new HashMap<String, CategoryData>());
    }

    public static PlayerData read(class_2487 nbt) {
        HashMap<String, CategoryData> categories = new HashMap<String, CategoryData>();
        class_2487 categoriesNbt = nbt.method_10562("categories");
        for (String id : categoriesNbt.method_10541()) {
            class_2520 elementNbt = categoriesNbt.method_10580(id);
            if (!(elementNbt instanceof class_2487)) continue;
            class_2487 categoryNbt = (class_2487)elementNbt;
            categories.put(id, CategoryData.read(categoryNbt));
        }
        return new PlayerData(categories);
    }

    public class_2487 writeNbt(class_2487 nbt) {
        class_2487 categoriesNbt = new class_2487();
        for (Map.Entry<String, CategoryData> entry : this.categories.entrySet()) {
            categoriesNbt.method_10566(entry.getKey(), (class_2520)entry.getValue().writeNbt(new class_2487()));
        }
        nbt.method_10566("categories", (class_2520)categoriesNbt);
        return nbt;
    }

    public void unlockCategory(CategoryConfig category) {
        this.getCategoryData(category).setUnlocked(true);
    }

    public void lockCategory(CategoryConfig category) {
        this.getCategoryData(category).setUnlocked(false);
    }

    public boolean isCategoryUnlocked(CategoryConfig category) {
        CategoryData categoryData = this.categories.get(category.getId());
        if (categoryData != null) {
            return categoryData.isUnlocked();
        }
        return category.getGeneral().isUnlockedByDefault();
    }

    public CategoryData getCategoryData(CategoryConfig category) {
        return this.categories.compute(category.getId(), (key, value) -> {
            if (value == null) {
                value = CategoryData.create(category.getGeneral().isUnlockedByDefault());
            }
            return value;
        });
    }

    public void removeCategoryData(CategoryConfig category) {
        this.categories.remove(category.getId());
    }
}

