/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod;

import java.util.Collection;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.puffish.skillsmod.SkillsMod;
import net.puffish.skillsmod.experience.ExperienceSource;
import net.puffish.skillsmod.experience.ExperienceSourceFactory;
import net.puffish.skillsmod.experience.ExperienceSourceRegistry;
import net.puffish.skillsmod.rewards.RewardFactory;
import net.puffish.skillsmod.rewards.RewardRegistry;

public class SkillsAPI {
    public static final String MOD_ID = "puffish_skills";

    public static void registerReward(ResourceLocation key, RewardFactory factory) {
        RewardRegistry.register(key, factory);
    }

    public static void refreshReward(ServerPlayer player, ResourceLocation key) {
        SkillsMod.getInstance().refreshReward(player, key);
    }

    public static void registerExperienceSource(ResourceLocation key, ExperienceSourceFactory factory) {
        ExperienceSourceRegistry.register(key, factory);
    }

    public static void visitExperienceSources(ServerPlayer player, Function<ExperienceSource, Integer> function) {
        SkillsMod.getInstance().visitExperienceSources(player, function);
    }

    public static Optional<Collection<String>> getSkills(String categoryId) {
        return SkillsMod.getInstance().getSkills(categoryId);
    }

    public static Optional<Collection<String>> getUnlockedSkills(ServerPlayer player, String categoryId) {
        return SkillsMod.getInstance().getUnlockedSkills(player, categoryId);
    }

    public static Collection<String> getCategories() {
        return SkillsMod.getInstance().getCategories();
    }

    public static Collection<String> getUnlockedCategories(ServerPlayer player) {
        return SkillsMod.getInstance().getUnlockedCategories(player);
    }

    public static void unlockCategory(ServerPlayer player, String categoryId) {
        SkillsMod.getInstance().unlockCategory(player, categoryId);
    }

    public static void lockCategory(ServerPlayer player, String categoryId) {
        SkillsMod.getInstance().lockCategory(player, categoryId);
    }

    public static void eraseCategory(ServerPlayer player, String categoryId) {
        SkillsMod.getInstance().eraseCategory(player, categoryId);
    }

    public static void unlockSkill(ServerPlayer player, String categoryId, String skillId) {
        SkillsMod.getInstance().unlockSkill(player, categoryId, skillId);
    }

    public static void resetSkills(ServerPlayer player, String categoryId) {
        SkillsMod.getInstance().resetSkills(player, categoryId);
    }

    public static Optional<Integer> getExperience(ServerPlayer player, String categoryId) {
        return SkillsMod.getInstance().getExperience(player, categoryId);
    }

    public static void setExperience(ServerPlayer player, String categoryId, int amount) {
        SkillsMod.getInstance().setExperience(player, categoryId, amount);
    }

    public static void addExperience(ServerPlayer player, String categoryId, int amount) {
        SkillsMod.getInstance().addExperience(player, categoryId, amount);
    }

    public static Optional<Integer> getExtraPoints(ServerPlayer player, String categoryId) {
        return SkillsMod.getInstance().getExtraPoints(player, categoryId);
    }

    public static void setExtraPoints(ServerPlayer player, String categoryId, int count) {
        SkillsMod.getInstance().setExtraPoints(player, categoryId, count);
    }

    public static void addExtraPoints(ServerPlayer player, String categoryId, int count) {
        SkillsMod.getInstance().addExtraPoints(player, categoryId, count);
    }

    public static Optional<Integer> getPointsLeft(ServerPlayer player, String categoryId) {
        return SkillsMod.getInstance().getPointsLeft(player, categoryId);
    }

    public static void setPointsLeft(ServerPlayer player, String categoryId, int count) {
        SkillsMod.getInstance().setPointsLeft(player, categoryId, count);
    }
}

