/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.puffish.skillsmod.attributes.PlayerAttributes;
import net.puffish.skillsmod.commands.CategoryCommand;
import net.puffish.skillsmod.commands.ExperienceCommand;
import net.puffish.skillsmod.commands.PointsCommand;
import net.puffish.skillsmod.commands.SkillsCommand;
import net.puffish.skillsmod.config.CategoryConfig;
import net.puffish.skillsmod.config.experience.ExperienceSourceConfig;
import net.puffish.skillsmod.config.skill.SkillConfig;
import net.puffish.skillsmod.experience.ExperienceSource;
import net.puffish.skillsmod.experience.builtin.KillEntityExperienceSource;
import net.puffish.skillsmod.experience.builtin.MineBlockExperienceSource;
import net.puffish.skillsmod.json.JsonElementWrapper;
import net.puffish.skillsmod.network.Packets;
import net.puffish.skillsmod.rewards.builtin.AttributeReward;
import net.puffish.skillsmod.server.data.CategoryData;
import net.puffish.skillsmod.server.data.PlayerData;
import net.puffish.skillsmod.server.data.ServerData;
import net.puffish.skillsmod.server.event.ServerEventListener;
import net.puffish.skillsmod.server.event.ServerEventReceiver;
import net.puffish.skillsmod.server.event.ServerRegistrar;
import net.puffish.skillsmod.server.network.ServerPacketReceiver;
import net.puffish.skillsmod.server.network.ServerPacketSender;
import net.puffish.skillsmod.server.network.packets.in.SkillClickInPacket;
import net.puffish.skillsmod.server.network.packets.out.ExperienceUpdateOutPacket;
import net.puffish.skillsmod.server.network.packets.out.HideCategoryOutPacket;
import net.puffish.skillsmod.server.network.packets.out.PointsUpdateOutPacket;
import net.puffish.skillsmod.server.network.packets.out.ShowCategoryOutPacket;
import net.puffish.skillsmod.server.network.packets.out.SkillUnlockOutPacket;
import net.puffish.skillsmod.utils.ChangeListener;
import net.puffish.skillsmod.utils.PathUtils;
import net.puffish.skillsmod.utils.Result;
import net.puffish.skillsmod.utils.error.Error;
import net.puffish.skillsmod.utils.error.ManyErrors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SkillsMod {
    private static SkillsMod instance;
    private final Logger logger = LoggerFactory.getLogger((String)"puffish_skills");
    private final Path modConfigDir;
    private final ServerPacketSender packetSender;
    private ChangeListener<Map<String, CategoryConfig>> categories = null;

    private SkillsMod(Path modConfigDir, ServerPacketSender packetSender) {
        this.modConfigDir = modConfigDir;
        this.packetSender = packetSender;
    }

    public static SkillsMod getInstance() {
        return instance;
    }

    public static void setup(Path configDir, ServerRegistrar registrar, ServerEventReceiver eventReceiver, ServerPacketSender packetSender, ServerPacketReceiver packetReceiver) {
        Path modConfigDir = configDir.resolve("puffish_skills");
        try {
            Files.createDirectories(modConfigDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        instance = new SkillsMod(modConfigDir, packetSender);
        packetReceiver.registerPacket(Packets.SKILL_CLICK_PACKET, SkillClickInPacket::read, instance::onSkillClickPacket);
        eventReceiver.registerListener(instance.new EventListener());
        PlayerAttributes.register(registrar);
        AttributeReward.register();
        MineBlockExperienceSource.register();
        KillEntityExperienceSource.register();
    }

    public static ResourceLocation createIdentifier(String path) {
        return new ResourceLocation("puffish_skills", path);
    }

    public static MutableComponent createTranslatable(String type, String path, Object ... args) {
        return Component.m_237110_((String)Util.m_137492_((String)type, (ResourceLocation)SkillsMod.createIdentifier(path)), (Object[])args);
    }

    public static ResourceLocation createAttribute(String type, String name) {
        return SkillsMod.createIdentifier(type + "." + name);
    }

    private void copyConfigFromJar() {
        PathUtils.copyFileFromJar(Path.of("config", "categories.json"), this.modConfigDir.resolve("categories.json"));
        List<String> categories = List.of("combat", "mining");
        List<String> files = List.of("category.json", "definitions.json", "skills.json", "connections.json", "experience.json");
        for (String category : categories) {
            for (String file : files) {
                PathUtils.copyFileFromJar(Path.of("config", "categories", category, file), this.modConfigDir.resolve(Path.of("categories", category, file)));
            }
        }
    }

    private void loadConfig() {
        if (!Files.exists(this.modConfigDir, new LinkOption[0]) || PathUtils.isDirectoryEmpty(this.modConfigDir)) {
            this.copyConfigFromJar();
        }
        Path categoriesFile = this.modConfigDir.resolve("categories.json");
        PathUtils.createFileIfMissing(categoriesFile);
        JsonElementWrapper.parseFile(categoriesFile, this.modConfigDir.relativize(categoriesFile)).andThen(JsonElementWrapper::getAsArray).andThen(array -> array.getAsList((i, element) -> element.getAsString()).mapFailure(ManyErrors::ofList)).andThen(this::readCategories).peek(map -> {
            this.logger.info("Config loaded successfully!");
            this.categories.set((Map<String, CategoryConfig>)map);
        }, error -> {
            this.logger.error("Could not load config:" + System.lineSeparator() + error.getMessage());
            this.categories.set(Map.of());
        });
    }

    private Result<Map<String, CategoryConfig>, Error> readCategories(List<String> ids) {
        ArrayList<Error> errors = new ArrayList<Error>();
        HashMap map = new HashMap();
        Path categoriesDir = this.modConfigDir.resolve("categories");
        for (int i = 0; i < ids.size(); ++i) {
            String id = ids.get(i);
            this.readCategory(id, i, categoriesDir.resolve(id)).ifFailure(errors::add).ifSuccess(category -> map.put(id, category));
        }
        if (errors.isEmpty()) {
            return Result.success(map);
        }
        return Result.failure(ManyErrors.ofList(errors));
    }

    private Result<CategoryConfig, Error> readCategory(String id, int index, Path categoryDir) {
        Path generalFile = categoryDir.resolve("category.json");
        Path definitionsFile = categoryDir.resolve("definitions.json");
        Path skillsFile = categoryDir.resolve("skills.json");
        Path connectionsFile = categoryDir.resolve("connections.json");
        Path experienceFile = categoryDir.resolve("experience.json");
        PathUtils.createFileIfMissing(generalFile);
        PathUtils.createFileIfMissing(definitionsFile);
        PathUtils.createFileIfMissing(skillsFile);
        PathUtils.createFileIfMissing(connectionsFile);
        PathUtils.createFileIfMissing(experienceFile);
        ArrayList<Error> errors = new ArrayList<Error>();
        Optional<JsonElementWrapper> generalElement = JsonElementWrapper.parseFile(generalFile, this.modConfigDir.relativize(generalFile)).ifFailure(errors::add).getSuccess();
        Optional<JsonElementWrapper> definitionsElement = JsonElementWrapper.parseFile(definitionsFile, this.modConfigDir.relativize(definitionsFile)).ifFailure(errors::add).getSuccess();
        Optional<JsonElementWrapper> skillsElement = JsonElementWrapper.parseFile(skillsFile, this.modConfigDir.relativize(skillsFile)).ifFailure(errors::add).getSuccess();
        Optional<JsonElementWrapper> connectionsElement = JsonElementWrapper.parseFile(connectionsFile, this.modConfigDir.relativize(connectionsFile)).ifFailure(errors::add).getSuccess();
        Optional<JsonElementWrapper> experienceElement = JsonElementWrapper.parseFile(experienceFile, this.modConfigDir.relativize(experienceFile)).ifFailure(errors::add).getSuccess();
        if (errors.isEmpty()) {
            return CategoryConfig.parse(id, index, generalElement.orElseThrow(), definitionsElement.orElseThrow(), skillsElement.orElseThrow(), connectionsElement.orElseThrow(), experienceElement.orElseThrow());
        }
        return Result.failure(ManyErrors.ofList(errors));
    }

    private void onSkillClickPacket(ServerPlayer player, SkillClickInPacket packet) {
        this.unlockSkill(player, packet.getCategoryId(), packet.getSkillId());
    }

    public void unlockSkill(ServerPlayer player, String categoryId, String skillId) {
        this.getCategory(categoryId).ifPresent(category -> this.getCategoryDataIfUnlocked(player, (CategoryConfig)category).ifPresent(categoryData -> {
            if (categoryData.getPointsLeft(category.getExperience()) < 1) {
                return;
            }
            if (category.tryUnlockSkill(player, (CategoryData)categoryData, skillId)) {
                this.packetSender.send(player, new SkillUnlockOutPacket(categoryId, skillId));
                this.syncPoints(player, (CategoryConfig)category, (CategoryData)categoryData);
            }
        }));
    }

    public void resetSkills(ServerPlayer player, String categoryId) {
        this.getCategory(categoryId).ifPresent(category -> this.getCategoryDataIfUnlocked(player, (CategoryConfig)category).ifPresent(categoryData -> {
            categoryData.resetSkills();
            this.applyRewards(player, (CategoryConfig)category, (CategoryData)categoryData);
            this.syncCategory(player, (CategoryConfig)category, (CategoryData)categoryData);
        }));
    }

    public void eraseCategory(ServerPlayer player, String categoryId) {
        this.getCategory(categoryId).ifPresent(category -> {
            PlayerData playerData = this.getPlayerData(player);
            playerData.removeCategoryData((CategoryConfig)category);
            this.syncCategory(player, (CategoryConfig)category);
        });
    }

    public void unlockCategory(ServerPlayer player, String categoryId) {
        this.getCategory(categoryId).ifPresent(category -> {
            PlayerData playerData = this.getPlayerData(player);
            playerData.unlockCategory((CategoryConfig)category);
            this.syncCategory(player, (CategoryConfig)category);
        });
    }

    public void lockCategory(ServerPlayer player, String categoryId) {
        this.getCategory(categoryId).ifPresent(category -> {
            PlayerData playerData = this.getPlayerData(player);
            playerData.lockCategory((CategoryConfig)category);
            this.syncCategory(player, (CategoryConfig)category);
        });
    }

    public void addExperience(ServerPlayer player, String categoryId, int amount) {
        this.getCategory(categoryId).ifPresent(category -> {
            if (!category.getExperience().isEnabled()) {
                return;
            }
            this.getCategoryDataIfUnlocked(player, (CategoryConfig)category).ifPresent(categoryData -> {
                categoryData.addExperience(amount);
                this.syncExperience(player, (CategoryConfig)category, (CategoryData)categoryData);
                this.syncPoints(player, (CategoryConfig)category, (CategoryData)categoryData);
            });
        });
    }

    public void setExperience(ServerPlayer player, String categoryId, int amount) {
        this.getCategory(categoryId).ifPresent(category -> {
            if (!category.getExperience().isEnabled()) {
                return;
            }
            this.getCategoryDataIfUnlocked(player, (CategoryConfig)category).ifPresent(categoryData -> {
                categoryData.setExperience(amount);
                this.syncExperience(player, (CategoryConfig)category, (CategoryData)categoryData);
                this.syncPoints(player, (CategoryConfig)category, (CategoryData)categoryData);
            });
        });
    }

    public Optional<Integer> getExperience(ServerPlayer player, String categoryId) {
        return this.getCategory(categoryId).flatMap(category -> {
            if (!category.getExperience().isEnabled()) {
                return Optional.empty();
            }
            return this.getCategoryDataIfUnlocked(player, (CategoryConfig)category).map(CategoryData::getExperience);
        });
    }

    public void addExtraPoints(ServerPlayer player, String categoryId, int count) {
        this.getCategory(categoryId).ifPresent(category -> this.getCategoryDataIfUnlocked(player, (CategoryConfig)category).ifPresent(categoryData -> {
            categoryData.addExtraPoints(count);
            this.syncPoints(player, (CategoryConfig)category, (CategoryData)categoryData);
        }));
    }

    public void setExtraPoints(ServerPlayer player, String categoryId, int count) {
        this.getCategory(categoryId).ifPresent(category -> this.getCategoryDataIfUnlocked(player, (CategoryConfig)category).ifPresent(categoryData -> {
            categoryData.setExtraPoints(count);
            this.syncPoints(player, (CategoryConfig)category, (CategoryData)categoryData);
        }));
    }

    public Optional<Integer> getExtraPoints(ServerPlayer player, String categoryId) {
        return this.getCategory(categoryId).flatMap(category -> this.getCategoryDataIfUnlocked(player, (CategoryConfig)category).map(CategoryData::getExtraPoints));
    }

    public void setPointsLeft(ServerPlayer player, String categoryId, int count) {
        this.getCategory(categoryId).ifPresent(category -> {
            CategoryData categoryData = this.getPlayerData(player).getCategoryData((CategoryConfig)category);
            categoryData.setPointsLeft(count, category.getExperience());
            this.syncPoints(player, (CategoryConfig)category, categoryData);
        });
    }

    public Optional<Integer> getPointsLeft(ServerPlayer player, String categoryId) {
        return this.getCategory(categoryId).map(category -> {
            CategoryData categoryData = this.getPlayerData(player).getCategoryData((CategoryConfig)category);
            return categoryData.getPointsLeft(category.getExperience());
        });
    }

    public Collection<String> getUnlockedCategories(ServerPlayer player) {
        PlayerData playerData = this.getPlayerData(player);
        return this.getAllCategories().stream().filter(playerData::isCategoryUnlocked).map(CategoryConfig::getId).toList();
    }

    public Collection<String> getCategories() {
        return this.getAllCategories().stream().map(CategoryConfig::getId).toList();
    }

    public Optional<Collection<String>> getUnlockedSkills(ServerPlayer player, String categoryId) {
        return this.getCategory(categoryId).map(category -> {
            CategoryData categoryData = this.getPlayerData(player).getCategoryData((CategoryConfig)category);
            return categoryData.getUnlockedSkillIds();
        });
    }

    public Optional<Collection<String>> getSkills(String categoryId) {
        return this.getCategory(categoryId).map(category -> category.getSkills().getAll().stream().map(SkillConfig::getId).toList());
    }

    private void showCategory(ServerPlayer player, CategoryConfig category, CategoryData categoryData) {
        this.packetSender.send(player, new ShowCategoryOutPacket(category, categoryData));
    }

    private void hideCategory(ServerPlayer player, CategoryConfig category) {
        this.packetSender.send(player, new HideCategoryOutPacket(category.getId()));
    }

    private void syncPoints(ServerPlayer player, CategoryConfig category, CategoryData categoryData) {
        this.packetSender.send(player, new PointsUpdateOutPacket(category.getId(), categoryData.getPointsLeft(category.getExperience())));
    }

    private void syncExperience(ServerPlayer player, CategoryConfig category, CategoryData categoryData) {
        this.packetSender.send(player, new ExperienceUpdateOutPacket(category.getId(), category.getExperience().getProgress(categoryData)));
    }

    public void refreshReward(ServerPlayer player, ResourceLocation type) {
        for (CategoryConfig category : this.getAllCategories()) {
            CategoryData categoryData = this.getPlayerData(player).getCategoryData(category);
            category.refreshReward(player, categoryData, type);
        }
    }

    public void visitExperienceSources(ServerPlayer player, Function<ExperienceSource, Integer> function) {
        for (CategoryConfig category : this.getAllCategories()) {
            this.getCategoryDataIfUnlocked(player, category).ifPresent(categoryData -> {
                int amount = 0;
                for (ExperienceSourceConfig experienceSource : category.getExperience().getExperienceSources()) {
                    amount += ((Integer)function.apply(experienceSource.getInstance())).intValue();
                }
                if (amount != 0) {
                    categoryData.addExperience(amount);
                    this.syncExperience(player, category, (CategoryData)categoryData);
                    this.syncPoints(player, category, (CategoryData)categoryData);
                }
            });
        }
    }

    private void applyRewards(ServerPlayer player, CategoryConfig category, CategoryData categoryData) {
        category.applyRewards(player, categoryData);
    }

    private void resetRewards(ServerPlayer player, CategoryConfig category) {
        category.resetRewards(player);
    }

    private Optional<CategoryData> getCategoryDataIfUnlocked(ServerPlayer player, CategoryConfig category) {
        return this.getCategoryDataIfUnlocked(this.getPlayerData(player), category);
    }

    private Optional<CategoryData> getCategoryDataIfUnlocked(PlayerData playerData, CategoryConfig category) {
        if (playerData.isCategoryUnlocked(category)) {
            return Optional.of(playerData.getCategoryData(category));
        }
        return Optional.empty();
    }

    private Optional<CategoryConfig> getCategory(String categoryId) {
        return Optional.ofNullable(this.categories.get().get(categoryId));
    }

    private Collection<CategoryConfig> getAllCategories() {
        return this.categories.get().values();
    }

    private void syncCategory(ServerPlayer player, CategoryConfig category, CategoryData categoryData) {
        this.applyRewards(player, category, categoryData);
        this.showCategory(player, category, categoryData);
    }

    private void syncCategory(ServerPlayer player, CategoryConfig category) {
        this.getCategoryDataIfUnlocked(player, category).ifPresentOrElse(categoryData -> this.syncCategory(player, category, (CategoryData)categoryData), () -> {
            this.resetRewards(player, category);
            this.hideCategory(player, category);
        });
    }

    private void syncAllCategories(ServerPlayer player) {
        for (CategoryConfig category : this.getAllCategories()) {
            this.syncCategory(player, category);
        }
    }

    private PlayerData getPlayerData(ServerPlayer player) {
        return ServerData.getOrCreate(Objects.requireNonNull(player.m_20194_())).getPlayerData(player);
    }

    private class EventListener
    implements ServerEventListener {
        private EventListener() {
        }

        @Override
        public void onServerStarting(MinecraftServer server) {
            SkillsMod.this.categories = new ChangeListener<Object>(old -> {
                for (CategoryConfig category : old.values()) {
                    category.dispose(server);
                }
            }, null);
            SkillsMod.this.loadConfig();
        }

        @Override
        public void onServerReload(MinecraftServer server) {
            for (ServerPlayer player : server.m_6846_().m_11314_()) {
                for (CategoryConfig category : SkillsMod.this.getAllCategories()) {
                    SkillsMod.this.hideCategory(player, category);
                }
            }
            SkillsMod.this.loadConfig();
            for (ServerPlayer player : server.m_6846_().m_11314_()) {
                SkillsMod.this.syncAllCategories(player);
            }
        }

        @Override
        public void onPlayerJoin(ServerPlayer player) {
            SkillsMod.this.syncAllCategories(player);
        }

        @Override
        public void onCommandsRegister(CommandDispatcher<CommandSourceStack> dispatcher) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"puffish_skills").then(CategoryCommand.create())).then(SkillsCommand.create())).then(PointsCommand.create())).then(ExperienceCommand.create()));
        }
    }
}

