/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.client;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.puffish.skillsmod.SkillsMod;
import net.puffish.skillsmod.client.data.ClientSkillCategoryData;
import net.puffish.skillsmod.client.event.ClientEventListener;
import net.puffish.skillsmod.client.event.ClientEventReceiver;
import net.puffish.skillsmod.client.gui.SkillsScreen;
import net.puffish.skillsmod.client.keybinding.KeyBindingReceiver;
import net.puffish.skillsmod.client.network.ClientPacketReceiver;
import net.puffish.skillsmod.client.network.ClientPacketSender;
import net.puffish.skillsmod.client.network.packets.in.ExperienceUpdateInPacket;
import net.puffish.skillsmod.client.network.packets.in.HideCategoryInPacket;
import net.puffish.skillsmod.client.network.packets.in.PointsUpdateInPacket;
import net.puffish.skillsmod.client.network.packets.in.ShowCategoryInPacket;
import net.puffish.skillsmod.client.network.packets.in.SkillUnlockInPacket;
import net.puffish.skillsmod.network.Packets;

public class SkillsClientMod {
    public static final KeyMapping OPEN_KEY_BINDING = new KeyMapping("key.puffish_skills.open", InputConstants.Type.KEYSYM, 75, "category.puffish_skills.skills");
    private static SkillsClientMod instance;
    private final Map<String, ClientSkillCategoryData> categories = new HashMap<String, ClientSkillCategoryData>();
    private final ClientPacketSender packetSender;

    private SkillsClientMod(ClientPacketSender packetSender) {
        this.packetSender = packetSender;
    }

    public static SkillsClientMod getInstance() {
        return instance;
    }

    public static void setup(ClientEventReceiver eventReceiver, KeyBindingReceiver keyBindingReceiver, ClientPacketSender packetSender, ClientPacketReceiver packetReceiver) {
        instance = new SkillsClientMod(packetSender);
        keyBindingReceiver.registerKeyBinding(OPEN_KEY_BINDING, instance::onOpenKeyPress);
        packetReceiver.registerPacket(Packets.SHOW_CATEGORY, ShowCategoryInPacket::read, instance::onShowCategory);
        packetReceiver.registerPacket(Packets.HIDE_CATEGORY, HideCategoryInPacket::read, instance::onHideCategory);
        packetReceiver.registerPacket(Packets.SKILL_UNLOCK_PACKET, SkillUnlockInPacket::read, instance::onSkillUnlockPacket);
        packetReceiver.registerPacket(Packets.POINTS_UPDATE_PACKET, PointsUpdateInPacket::read, instance::onPointsUpdatePacket);
        packetReceiver.registerPacket(Packets.EXPERIENCE_UPDATE_PACKET, ExperienceUpdateInPacket::read, instance::onExperienceUpdatePacket);
        eventReceiver.registerListener(instance.new EventListener());
    }

    private void onOpenKeyPress() {
        if (this.categories.isEmpty()) {
            return;
        }
        Minecraft.m_91087_().m_91152_((Screen)new SkillsScreen(this.categories.values().stream().sorted(Comparator.comparing(ClientSkillCategoryData::getIndex)).toList()));
    }

    private void onShowCategory(ShowCategoryInPacket packet) {
        ClientSkillCategoryData category = packet.getCategory();
        this.categories.put(category.getId(), category);
    }

    private void onHideCategory(HideCategoryInPacket packet) {
        this.categories.remove(packet.getCategoryId());
    }

    private void onSkillUnlockPacket(SkillUnlockInPacket packet) {
        this.getCategoryById(packet.getCategoryId()).ifPresent(category -> category.unlock(packet.getSkillId()));
    }

    private void onExperienceUpdatePacket(ExperienceUpdateInPacket packet) {
        this.getCategoryById(packet.getCategoryId()).ifPresent(category -> category.setExperienceProgress(packet.getExperienceProgress()));
    }

    private void onPointsUpdatePacket(PointsUpdateInPacket packet) {
        this.getCategoryById(packet.getCategoryId()).ifPresent(category -> {
            if (packet.getPoints() > category.getPointsLeft()) {
                Minecraft.m_91087_().f_91065_.m_93076_().m_93785_((Component)SkillsMod.createTranslatable("chat", "new_point", OPEN_KEY_BINDING.m_90863_()));
            }
            category.setPointsLeft(packet.getPoints());
        });
    }

    private Optional<ClientSkillCategoryData> getCategoryById(String categoryId) {
        return Optional.ofNullable(this.categories.get(categoryId));
    }

    public ClientPacketSender getPacketSender() {
        return this.packetSender;
    }

    private class EventListener
    implements ClientEventListener {
        private EventListener() {
        }

        @Override
        public void onPlayerJoin() {
            SkillsClientMod.this.categories.clear();
        }
    }
}

