/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.client.network.packets.in;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.advancements.FrameType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.puffish.skillsmod.client.data.ClientIconData;
import net.puffish.skillsmod.client.data.ClientSkillCategoryData;
import net.puffish.skillsmod.client.data.ClientSkillConnectionData;
import net.puffish.skillsmod.client.data.ClientSkillData;
import net.puffish.skillsmod.client.data.ClientSkillDefinitionData;
import net.puffish.skillsmod.json.JsonElementWrapper;
import net.puffish.skillsmod.network.InPacket;
import net.puffish.skillsmod.skill.SkillState;
import net.puffish.skillsmod.utils.JsonParseUtils;

public class ShowCategoryInPacket
implements InPacket {
    private final ClientSkillCategoryData category;

    private ShowCategoryInPacket(ClientSkillCategoryData category) {
        this.category = category;
    }

    public static ShowCategoryInPacket read(FriendlyByteBuf buf) {
        ClientSkillCategoryData category = ShowCategoryInPacket.readCategory(buf);
        return new ShowCategoryInPacket(category);
    }

    public static ClientSkillCategoryData readCategory(FriendlyByteBuf buf) {
        String id = buf.m_130277_();
        int index = buf.readInt();
        Component title = buf.m_130238_();
        ClientIconData icon = ShowCategoryInPacket.readSkillIcon(buf);
        ResourceLocation background = buf.m_130281_();
        Map<String, ClientSkillDefinitionData> definitions = buf.m_236845_(ShowCategoryInPacket::readDefinition).stream().collect(Collectors.toMap(ClientSkillDefinitionData::getId, definition -> definition));
        Map<String, ClientSkillData> skills = buf.m_236845_(ShowCategoryInPacket::readSkill).stream().collect(Collectors.toMap(ClientSkillData::getId, skill -> skill));
        List connections = buf.m_236845_(ShowCategoryInPacket::readSkillConnection);
        int points = buf.readInt();
        Float experienceProgress = buf.m_236860_(FriendlyByteBuf::readFloat).orElse(Float.valueOf(-1.0f));
        return new ClientSkillCategoryData(id, index, title, icon, background, definitions, skills, connections, points, experienceProgress.floatValue());
    }

    public static ClientSkillDefinitionData readDefinition(FriendlyByteBuf buf) {
        String id = buf.m_130277_();
        Component title = buf.m_130238_();
        Component description = buf.m_130238_();
        FrameType frame = (FrameType)buf.m_130066_(FrameType.class);
        ClientIconData icon = ShowCategoryInPacket.readSkillIcon(buf);
        return new ClientSkillDefinitionData(id, title, description, frame, icon);
    }

    public static ClientIconData readSkillIcon(FriendlyByteBuf buf) {
        String type = buf.m_130277_();
        return buf.m_236860_(FriendlyByteBuf::m_130277_).flatMap(data -> JsonElementWrapper.parseString(data).getSuccess()).flatMap(rootElement -> switch (type) {
            case "item" -> JsonParseUtils.parseItemStack(rootElement).getSuccess().map(ClientIconData.ItemIconData::new);
            case "effect" -> rootElement.getAsObject().andThen(rootObject -> rootObject.get("effect")).andThen(JsonParseUtils::parseEffect).getSuccess().map(ClientIconData.EffectIconData::new);
            case "texture" -> rootElement.getAsObject().andThen(rootObject -> rootObject.get("texture")).andThen(JsonParseUtils::parseIdentifier).getSuccess().map(ClientIconData.TextureIconData::new);
            default -> Optional.empty();
        }).orElseGet(ClientIconData.TextureIconData::createMissing);
    }

    public static ClientSkillData readSkill(FriendlyByteBuf buf) {
        String id = buf.m_130277_();
        int x = buf.readInt();
        int y = buf.readInt();
        String definition = buf.m_130277_();
        boolean isRoot = buf.readBoolean();
        SkillState state = (SkillState)buf.m_130066_(SkillState.class);
        return new ClientSkillData(id, x, y, definition, isRoot, state);
    }

    public static ClientSkillConnectionData readSkillConnection(FriendlyByteBuf buf) {
        String skillAId = buf.m_130277_();
        String skillBId = buf.m_130277_();
        return new ClientSkillConnectionData(skillAId, skillBId);
    }

    public ClientSkillCategoryData getCategory() {
        return this.category;
    }
}

