/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.config;

import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.puffish.skillsmod.config.IconConfig;
import net.puffish.skillsmod.json.JsonElementWrapper;
import net.puffish.skillsmod.json.JsonObjectWrapper;
import net.puffish.skillsmod.utils.JsonParseUtils;
import net.puffish.skillsmod.utils.Result;
import net.puffish.skillsmod.utils.error.Error;
import net.puffish.skillsmod.utils.error.ManyErrors;

public class GeneralConfig {
    private final Component title;
    private final IconConfig icon;
    private final ResourceLocation background;
    private final boolean unlockedByDefault;

    private GeneralConfig(Component title, IconConfig icon, ResourceLocation background, boolean unlockedByDefault) {
        this.title = title;
        this.icon = icon;
        this.background = background;
        this.unlockedByDefault = unlockedByDefault;
    }

    public static Result<GeneralConfig, Error> parse(JsonElementWrapper rootElement) {
        return rootElement.getAsObject().andThen(GeneralConfig::parse);
    }

    public static Result<GeneralConfig, Error> parse(JsonObjectWrapper rootObject) {
        ArrayList<Error> errors = new ArrayList<Error>();
        Optional optTitle = rootObject.get("title").andThen(JsonParseUtils::parseText).ifFailure(errors::add).getSuccess();
        Optional optIcon = rootObject.get("icon").andThen(IconConfig::parse).ifFailure(errors::add).getSuccess();
        Optional optBackground = rootObject.get("background").andThen(JsonParseUtils::parseIdentifier).ifFailure(errors::add).getSuccess();
        Boolean unlockedByDefault = rootObject.getBoolean("unlocked_by_default").getSuccess().orElse(false);
        if (errors.isEmpty()) {
            return Result.success(new GeneralConfig((Component)optTitle.orElseThrow(), (IconConfig)optIcon.orElseThrow(), (ResourceLocation)optBackground.orElseThrow(), unlockedByDefault));
        }
        return Result.failure(ManyErrors.ofList(errors));
    }

    public Component getTitle() {
        return this.title;
    }

    public boolean isUnlockedByDefault() {
        return this.unlockedByDefault;
    }

    public IconConfig getIcon() {
        return this.icon;
    }

    public ResourceLocation getBackground() {
        return this.background;
    }
}

