/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.config.experience;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.server.MinecraftServer;
import net.puffish.skillsmod.config.experience.ExperienceSourceConfig;
import net.puffish.skillsmod.json.JsonElementWrapper;
import net.puffish.skillsmod.json.JsonObjectWrapper;
import net.puffish.skillsmod.server.data.CategoryData;
import net.puffish.skillsmod.utils.Result;
import net.puffish.skillsmod.utils.error.Error;
import net.puffish.skillsmod.utils.error.ManyErrors;

public class ExperienceConfig {
    private final boolean enabled;
    private final List<Integer> experiencePerLevel;
    private final List<ExperienceSourceConfig> experienceSources;

    private ExperienceConfig(boolean enabled, List<Integer> experiencePerLevel, List<ExperienceSourceConfig> experienceSources) {
        this.enabled = enabled;
        this.experiencePerLevel = experiencePerLevel;
        this.experienceSources = experienceSources;
    }

    public static Result<ExperienceConfig, Error> parse(JsonElementWrapper rootElement) {
        return rootElement.getAsObject().andThen(ExperienceConfig::parse);
    }

    public static Result<ExperienceConfig, Error> parse(JsonObjectWrapper rootObject) {
        ArrayList<Error> errors = new ArrayList<Error>();
        Optional<Boolean> enabled = rootObject.getBoolean("enabled").ifFailure(errors::add).getSuccess();
        Optional experiencePerLevel = rootObject.getArray("experience_per_level").andThen(array -> array.getAsList((i, element) -> element.getAsInt()).mapFailure(ManyErrors::ofList)).ifFailure(errors::add).getSuccess();
        List experienceSources = rootObject.getArray("sources").andThen(array -> array.getAsList((i, element) -> ExperienceSourceConfig.parse(element)).mapFailure(ManyErrors::ofList)).ifFailure(errors::add).getSuccess().orElseGet(List::of);
        if (errors.isEmpty()) {
            return Result.success(new ExperienceConfig(enabled.orElseThrow(), (List)experiencePerLevel.orElseThrow(), experienceSources));
        }
        return Result.failure(ManyErrors.ofList(errors));
    }

    public float getProgress(CategoryData categoryData) {
        int experience = categoryData.getExperience();
        int level = 0;
        int requiredExperience;
        while (experience >= (requiredExperience = this.experiencePerLevel.get(Math.min(level, this.experiencePerLevel.size() - 1)).intValue())) {
            experience -= requiredExperience;
            ++level;
        }
        return (float)experience / (float)requiredExperience;
    }

    public int getLevel(CategoryData categoryData) {
        int experience = categoryData.getExperience();
        int level = 0;
        int requiredExperience;
        while (experience >= (requiredExperience = this.experiencePerLevel.get(Math.min(level, this.experiencePerLevel.size() - 1)).intValue())) {
            experience -= requiredExperience;
            ++level;
        }
        return level;
    }

    public void dispose(MinecraftServer server) {
        for (ExperienceSourceConfig experienceSource : this.experienceSources) {
            experienceSource.dispose(server);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public List<Integer> getExperiencePerLevel() {
        return this.experiencePerLevel;
    }

    public List<ExperienceSourceConfig> getExperienceSources() {
        return this.experienceSources;
    }
}

