/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.config.skill;

import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.puffish.skillsmod.json.JsonElementWrapper;
import net.puffish.skillsmod.json.JsonObjectWrapper;
import net.puffish.skillsmod.json.JsonPath;
import net.puffish.skillsmod.rewards.Reward;
import net.puffish.skillsmod.rewards.RewardRegistry;
import net.puffish.skillsmod.utils.JsonParseUtils;
import net.puffish.skillsmod.utils.Result;
import net.puffish.skillsmod.utils.error.Error;
import net.puffish.skillsmod.utils.error.ManyErrors;

public class SkillRewardConfig {
    private final ResourceLocation type;
    private final Reward instance;

    private SkillRewardConfig(ResourceLocation type, Reward instance) {
        this.type = type;
        this.instance = instance;
    }

    public static Result<SkillRewardConfig, Error> parse(JsonElementWrapper rootElement) {
        return rootElement.getAsObject().andThen(SkillRewardConfig::parse);
    }

    public static Result<SkillRewardConfig, Error> parse(JsonObjectWrapper rootObject) {
        ArrayList<Error> errors = new ArrayList<Error>();
        Optional<JsonElementWrapper> optTypeElement = rootObject.get("type").ifFailure(errors::add).getSuccess();
        Optional optType = optTypeElement.flatMap(typeElement -> JsonParseUtils.parseIdentifier(typeElement).ifFailure(errors::add).getSuccess());
        Result<JsonElementWrapper, Error> maybeDataElement = rootObject.get("data");
        if (errors.isEmpty()) {
            return SkillRewardConfig.build((ResourceLocation)optType.orElseThrow(), maybeDataElement, rootObject.getPath().thenObject("type"));
        }
        return Result.failure(ManyErrors.ofList(errors));
    }

    private static Result<SkillRewardConfig, Error> build(ResourceLocation type, Result<JsonElementWrapper, Error> maybeDataElement, JsonPath typePath) {
        return RewardRegistry.getFactory(type).map(factory -> factory.create(maybeDataElement).mapSuccess(instance -> new SkillRewardConfig(type, (Reward)instance))).orElseGet(() -> Result.failure(typePath.errorAt("Expected a valid reward type")));
    }

    public void dispose(MinecraftServer server) {
        this.instance.dispose(server);
    }

    public ResourceLocation getType() {
        return this.type;
    }

    public Reward getInstance() {
        return this.instance;
    }
}

