/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.experience.builtin;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.HolderSet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.puffish.skillsmod.SkillsAPI;
import net.puffish.skillsmod.SkillsMod;
import net.puffish.skillsmod.experience.ExperienceSource;
import net.puffish.skillsmod.json.JsonElementWrapper;
import net.puffish.skillsmod.json.JsonObjectWrapper;
import net.puffish.skillsmod.json.JsonPath;
import net.puffish.skillsmod.utils.JsonParseUtils;
import net.puffish.skillsmod.utils.Result;
import net.puffish.skillsmod.utils.error.Error;
import net.puffish.skillsmod.utils.error.ManyErrors;

public class MineBlockExperienceSource
implements ExperienceSource {
    public static final ResourceLocation ID = SkillsMod.createIdentifier("mine_block");
    private final List<Modifier> modifiers;

    private MineBlockExperienceSource(List<Modifier> modifiers) {
        this.modifiers = modifiers;
    }

    public static void register() {
        SkillsAPI.registerExperienceSource(ID, MineBlockExperienceSource::create);
    }

    private static Result<MineBlockExperienceSource, Error> create(Result<JsonElementWrapper, Error> maybeDataElement) {
        return maybeDataElement.andThen(MineBlockExperienceSource::create);
    }

    private static Result<MineBlockExperienceSource, Error> create(JsonElementWrapper rootElement) {
        return rootElement.getAsObject().andThen(MineBlockExperienceSource::create);
    }

    private static Result<MineBlockExperienceSource, Error> create(JsonObjectWrapper rootObject) {
        ArrayList<Error> errors = new ArrayList<Error>();
        List modifiers = rootObject.getArray("modifiers").getSuccess().flatMap(array -> array.getAsList((i, element) -> Modifier.parse(element)).mapFailure(ManyErrors::ofList).ifFailure(errors::add).getSuccess()).orElseGet(List::of);
        if (errors.isEmpty()) {
            return Result.success(new MineBlockExperienceSource(modifiers));
        }
        return Result.failure(ManyErrors.ofList(errors));
    }

    @Override
    public void dispose(MinecraftServer server) {
    }

    public int getValue(BlockState blockState) {
        float value = 0.0f;
        for (Modifier modifier : this.modifiers) {
            value = modifier.testAndApply(blockState, value);
        }
        return Math.round(value);
    }

    private static abstract class Modifier {
        private final List<Condition> conditions;

        private Modifier(List<Condition> conditions) {
            this.conditions = conditions;
        }

        public static Result<Modifier, Error> parse(JsonElementWrapper rootElement) {
            return rootElement.getAsObject().andThen(Modifier::parse);
        }

        public static Result<Modifier, Error> parse(JsonObjectWrapper rootObject) {
            ArrayList<Error> errors = new ArrayList<Error>();
            List conditions = rootObject.getArray("conditions").getSuccess().flatMap(array -> array.getAsList((i, element) -> Condition.parse(element)).mapFailure(ManyErrors::ofList).ifFailure(errors::add).getSuccess()).orElseGet(List::of);
            Optional<JsonElementWrapper> optTypeElement = rootObject.get("type").ifFailure(errors::add).getSuccess();
            Optional optType = optTypeElement.flatMap(typeElement -> typeElement.getAsString().ifFailure(errors::add).getSuccess());
            Result<JsonElementWrapper, Error> maybeDataElement = rootObject.get("data");
            if (errors.isEmpty()) {
                return Modifier.build(conditions, (String)optType.orElseThrow(), maybeDataElement, optTypeElement.orElseThrow().getPath());
            }
            return Result.failure(ManyErrors.ofList(errors));
        }

        private static Result<Modifier, Error> build(List<Condition> conditions, String type, Result<JsonElementWrapper, Error> maybeDataElement, JsonPath typeElementPath) {
            return switch (type) {
                case "addition" -> maybeDataElement.andThen(dataElement -> AdditionModifier.parseInternal(conditions, dataElement).mapSuccess(tmp -> tmp));
                case "multiply" -> maybeDataElement.andThen(dataElement -> MultiplyModifier.parseInternal(conditions, dataElement).mapSuccess(tmp -> tmp));
                case "fixed" -> maybeDataElement.andThen(dataElement -> FixedModifier.parseInternal(conditions, dataElement).mapSuccess(tmp -> tmp));
                default -> Result.failure(typeElementPath.errorAt("Expected a valid modifier type"));
            };
        }

        protected abstract float apply(float var1);

        public float testAndApply(BlockState blockState, float value) {
            if (this.conditions.stream().anyMatch(condition -> condition.test(blockState))) {
                return this.apply(value);
            }
            return value;
        }

        public static final class FixedModifier
        extends Modifier {
            private final float value;

            private FixedModifier(List<Condition> conditions, float value) {
                super(conditions);
                this.value = value;
            }

            public static Result<FixedModifier, Error> parseInternal(List<Condition> conditions, JsonElementWrapper rootElement) {
                return rootElement.getAsObject().andThen(rootObject -> FixedModifier.parseInternal(conditions, rootObject));
            }

            public static Result<FixedModifier, Error> parseInternal(List<Condition> conditions, JsonObjectWrapper rootObject) {
                ArrayList<Error> errors = new ArrayList<Error>();
                Optional<Float> optValue = rootObject.getFloat("value").ifFailure(errors::add).getSuccess();
                if (errors.isEmpty()) {
                    return Result.success(new FixedModifier(conditions, optValue.orElseThrow().floatValue()));
                }
                return Result.failure(ManyErrors.ofList(errors));
            }

            @Override
            public float apply(float value) {
                return this.value;
            }
        }

        public static final class MultiplyModifier
        extends Modifier {
            private final float value;

            private MultiplyModifier(List<Condition> conditions, float value) {
                super(conditions);
                this.value = value;
            }

            public static Result<MultiplyModifier, Error> parseInternal(List<Condition> conditions, JsonElementWrapper rootElement) {
                return rootElement.getAsObject().andThen(rootObject -> MultiplyModifier.parseInternal(conditions, rootObject));
            }

            public static Result<MultiplyModifier, Error> parseInternal(List<Condition> conditions, JsonObjectWrapper rootObject) {
                ArrayList<Error> errors = new ArrayList<Error>();
                Optional<Float> optValue = rootObject.getFloat("value").ifFailure(errors::add).getSuccess();
                if (errors.isEmpty()) {
                    return Result.success(new MultiplyModifier(conditions, optValue.orElseThrow().floatValue()));
                }
                return Result.failure(ManyErrors.ofList(errors));
            }

            @Override
            public float apply(float value) {
                return this.value * value;
            }
        }

        public static final class AdditionModifier
        extends Modifier {
            private final float value;

            private AdditionModifier(List<Condition> conditions, float value) {
                super(conditions);
                this.value = value;
            }

            public static Result<AdditionModifier, Error> parseInternal(List<Condition> conditions, JsonElementWrapper rootElement) {
                return rootElement.getAsObject().andThen(rootObject -> AdditionModifier.parseInternal(conditions, rootObject));
            }

            public static Result<AdditionModifier, Error> parseInternal(List<Condition> conditions, JsonObjectWrapper rootObject) {
                ArrayList<Error> errors = new ArrayList<Error>();
                Optional<Float> optValue = rootObject.getFloat("value").ifFailure(errors::add).getSuccess();
                if (errors.isEmpty()) {
                    return Result.success(new AdditionModifier(conditions, optValue.orElseThrow().floatValue()));
                }
                return Result.failure(ManyErrors.ofList(errors));
            }

            @Override
            public float apply(float value) {
                return this.value + value;
            }
        }
    }

    private static interface Condition {
        public boolean test(BlockState var1);

        public static Result<Condition, Error> parse(JsonElementWrapper rootElement) {
            return rootElement.getAsObject().andThen(Condition::parse);
        }

        public static Result<Condition, Error> parse(JsonObjectWrapper rootObject) {
            ArrayList<Error> errors = new ArrayList<Error>();
            Optional<String> optType = rootObject.getString("type").ifFailure(errors::add).getSuccess();
            Result<JsonElementWrapper, Error> maybeDataElement = rootObject.get("data");
            if (errors.isEmpty()) {
                return Condition.build(optType.orElseThrow(), maybeDataElement, rootObject.getPath().thenObject("type"));
            }
            return Result.failure(ManyErrors.ofList(errors));
        }

        private static Result<Condition, Error> build(String type, Result<JsonElementWrapper, Error> maybeDataElement, JsonPath typeElementPath) {
            return switch (type) {
                case "block" -> maybeDataElement.andThen(EntityCondition::parseInternal).mapSuccess(tmp -> tmp);
                case "tag" -> maybeDataElement.andThen(BlockTagCondition::parseInternal).mapSuccess(tmp -> tmp);
                default -> Result.failure(typeElementPath.errorAt("Expected a valid condition type"));
            };
        }

        public static final class BlockTagCondition
        implements Condition {
            private final HolderSet.Named<Block> entries;

            private BlockTagCondition(HolderSet.Named<Block> entries) {
                this.entries = entries;
            }

            public static Result<BlockTagCondition, Error> parseInternal(JsonElementWrapper rootElement) {
                return rootElement.getAsObject().andThen(BlockTagCondition::parseInternal);
            }

            public static Result<BlockTagCondition, Error> parseInternal(JsonObjectWrapper rootObject) {
                ArrayList<Error> errors = new ArrayList<Error>();
                Optional optTag = rootObject.get("tag").andThen(JsonParseUtils::parseBlockTag).ifFailure(errors::add).getSuccess();
                if (errors.isEmpty()) {
                    return Result.success(new BlockTagCondition((HolderSet.Named<Block>)((HolderSet.Named)optTag.orElseThrow())));
                }
                return Result.failure(ManyErrors.ofList(errors));
            }

            @Override
            public boolean test(BlockState blockState) {
                return blockState.m_204341_(this.entries);
            }
        }

        public static final class EntityCondition
        implements Condition {
            private final Block block;
            private final StatePropertiesPredicate state;

            public EntityCondition(Block block, StatePropertiesPredicate state) {
                this.block = block;
                this.state = state;
            }

            public static Result<EntityCondition, Error> parseInternal(JsonElementWrapper rootElement) {
                return rootElement.getAsObject().andThen(EntityCondition::parseInternal);
            }

            public static Result<EntityCondition, Error> parseInternal(JsonObjectWrapper rootObject) {
                ArrayList<Error> errors = new ArrayList<Error>();
                Optional optBlock = rootObject.get("block").andThen(JsonParseUtils::parseBlock).ifFailure(errors::add).getSuccess();
                StatePropertiesPredicate state = rootObject.get("state").getSuccess().flatMap(stateElement -> JsonParseUtils.parseStatePredicate(stateElement).ifFailure(errors::add).getSuccess()).orElseGet(() -> StatePropertiesPredicate.Builder.m_67693_().m_67706_());
                if (errors.isEmpty()) {
                    return Result.success(new EntityCondition((Block)optBlock.orElseThrow(), state));
                }
                return Result.failure(ManyErrors.ofList(errors));
            }

            @Override
            public boolean test(BlockState blockState) {
                return blockState.m_60713_(this.block) && this.state.m_67667_(blockState);
            }
        }
    }
}

