/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.server.data;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.puffish.skillsmod.config.CategoryConfig;
import net.puffish.skillsmod.server.data.CategoryData;

public class PlayerData {
    private final Map<String, CategoryData> categories;

    private PlayerData(Map<String, CategoryData> categories) {
        this.categories = categories;
    }

    public static PlayerData empty() {
        return new PlayerData(new HashMap<String, CategoryData>());
    }

    public static PlayerData read(CompoundTag nbt) {
        HashMap<String, CategoryData> categories = new HashMap<String, CategoryData>();
        CompoundTag categoriesNbt = nbt.m_128469_("categories");
        for (String id : categoriesNbt.m_128431_()) {
            Tag elementNbt = categoriesNbt.m_128423_(id);
            if (!(elementNbt instanceof CompoundTag)) continue;
            CompoundTag categoryNbt = (CompoundTag)elementNbt;
            categories.put(id, CategoryData.read(categoryNbt));
        }
        return new PlayerData(categories);
    }

    public CompoundTag writeNbt(CompoundTag nbt) {
        CompoundTag categoriesNbt = new CompoundTag();
        for (Map.Entry<String, CategoryData> entry : this.categories.entrySet()) {
            categoriesNbt.m_128365_(entry.getKey(), (Tag)entry.getValue().writeNbt(new CompoundTag()));
        }
        nbt.m_128365_("categories", (Tag)categoriesNbt);
        return nbt;
    }

    public void unlockCategory(CategoryConfig category) {
        this.getCategoryData(category).setUnlocked(true);
    }

    public void lockCategory(CategoryConfig category) {
        this.getCategoryData(category).setUnlocked(false);
    }

    public boolean isCategoryUnlocked(CategoryConfig category) {
        CategoryData categoryData = this.categories.get(category.getId());
        if (categoryData != null) {
            return categoryData.isUnlocked();
        }
        return category.getGeneral().isUnlockedByDefault();
    }

    public CategoryData getCategoryData(CategoryConfig category) {
        return this.categories.compute(category.getId(), (key, value) -> {
            if (value == null) {
                value = CategoryData.create(category.getGeneral().isUnlockedByDefault());
            }
            return value;
        });
    }

    public void removeCategoryData(CategoryConfig category) {
        this.categories.remove(category.getId());
    }
}

