/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.server.network.packets.out;

import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.puffish.skillsmod.config.CategoryConfig;
import net.puffish.skillsmod.config.GeneralConfig;
import net.puffish.skillsmod.config.IconConfig;
import net.puffish.skillsmod.config.experience.ExperienceConfig;
import net.puffish.skillsmod.config.skill.SkillConfig;
import net.puffish.skillsmod.config.skill.SkillConnectionConfig;
import net.puffish.skillsmod.config.skill.SkillConnectionsConfig;
import net.puffish.skillsmod.config.skill.SkillDefinitionConfig;
import net.puffish.skillsmod.config.skill.SkillDefinitionsConfig;
import net.puffish.skillsmod.config.skill.SkillsConfig;
import net.puffish.skillsmod.network.OutPacket;
import net.puffish.skillsmod.network.Packets;
import net.puffish.skillsmod.server.data.CategoryData;

public class ShowCategoryOutPacket
extends OutPacket {
    public ShowCategoryOutPacket(CategoryConfig category, CategoryData categoryData) {
        this.write(category, categoryData);
    }

    private void write(CategoryConfig category, CategoryData categoryData) {
        this.buf.m_130070_(category.getId());
        this.buf.writeInt(category.getIndex());
        this.write(category.getGeneral());
        this.write(category.getDefinitions());
        this.write(category.getSkills(), category, categoryData);
        this.write(category.getConnections());
        this.write(category.getExperience(), categoryData);
    }

    private void write(SkillDefinitionsConfig definitions) {
        this.buf.m_236828_(definitions.getAll(), (buf2, definition) -> this.write((SkillDefinitionConfig)definition));
    }

    private void write(GeneralConfig general) {
        this.buf.m_130083_(general.getTitle());
        this.write(general.getIcon());
        this.buf.m_130085_(general.getBackground());
    }

    private void write(SkillDefinitionConfig definition) {
        this.buf.m_130070_(definition.getId());
        this.buf.m_130083_(definition.getTitle());
        this.buf.m_130083_(definition.getDescription());
        this.buf.m_130068_((Enum)definition.getFrame());
        this.write(definition.getIcon());
    }

    private void write(ExperienceConfig experience, CategoryData categoryData) {
        this.buf.writeInt(categoryData.getPointsLeft(experience));
        if (experience.isEnabled()) {
            this.buf.m_236835_(Optional.of(Float.valueOf(experience.getProgress(categoryData))), FriendlyByteBuf::writeFloat);
        } else {
            this.buf.m_236835_(Optional.empty(), FriendlyByteBuf::writeFloat);
        }
    }

    private void write(SkillsConfig skills, CategoryConfig category, CategoryData categoryData) {
        this.buf.m_236828_(skills.getAll(), (buf2, skill) -> this.write((SkillConfig)skill, category, categoryData));
    }

    private void write(SkillConnectionsConfig connections) {
        this.buf.m_236828_(connections.getAll(), (buf2, connection) -> this.write((SkillConnectionConfig)connection));
    }

    private void write(SkillConfig skill, CategoryConfig category, CategoryData categoryData) {
        this.buf.m_130070_(skill.getId());
        this.buf.writeInt(skill.getX());
        this.buf.writeInt(skill.getY());
        this.buf.m_130070_(skill.getDefinitionId());
        this.buf.writeBoolean(skill.isRoot());
        this.buf.m_130068_((Enum)skill.getStateFor(category, categoryData));
    }

    private void write(SkillConnectionConfig skill) {
        this.buf.m_130070_(skill.getSkillAId());
        this.buf.m_130070_(skill.getSkillBId());
    }

    private void write(IconConfig icon) {
        this.buf.m_130070_(icon.getType());
        this.buf.m_236821_((Object)icon.getData(), (buf1, element) -> buf1.m_130070_(element.toString()));
    }

    @Override
    public ResourceLocation getIdentifier() {
        return Packets.SHOW_CATEGORY;
    }
}

