/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.config.skill;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_189;
import net.minecraft.class_2561;
import net.minecraft.server.MinecraftServer;
import net.puffish.skillsmod.config.IconConfig;
import net.puffish.skillsmod.config.skill.SkillRewardConfig;
import net.puffish.skillsmod.json.JsonElementWrapper;
import net.puffish.skillsmod.json.JsonObjectWrapper;
import net.puffish.skillsmod.utils.JsonParseUtils;
import net.puffish.skillsmod.utils.Result;
import net.puffish.skillsmod.utils.error.Error;
import net.puffish.skillsmod.utils.error.ManyErrors;

public class SkillDefinitionConfig {
    private final String id;
    private final class_2561 title;
    private final class_2561 description;
    private final IconConfig icon;
    private final class_189 frame;
    private final List<SkillRewardConfig> rewards;

    private SkillDefinitionConfig(String id, class_2561 title, class_2561 description, IconConfig icon, class_189 frame, List<SkillRewardConfig> rewards) {
        this.id = id;
        this.title = title;
        this.description = description;
        this.icon = icon;
        this.frame = frame;
        this.rewards = rewards;
    }

    public static Result<SkillDefinitionConfig, Error> parse(String id, JsonElementWrapper rootElement) {
        return rootElement.getAsObject().andThen(rootObject -> SkillDefinitionConfig.parse(id, rootObject));
    }

    public static Result<SkillDefinitionConfig, Error> parse(String id, JsonObjectWrapper rootObject) {
        ArrayList<Error> errors = new ArrayList<Error>();
        Optional optTitle = rootObject.get("title").andThen(JsonParseUtils::parseText).ifFailure(errors::add).getSuccess();
        class_2561 optDescription = rootObject.get("description").getSuccess().flatMap(descriptionElement -> JsonParseUtils.parseText(descriptionElement).ifFailure(errors::add).getSuccess()).orElseGet(class_2561::method_43473);
        Optional optIcon = rootObject.get("icon").andThen(IconConfig::parse).ifFailure(errors::add).getSuccess();
        class_189 frame = rootObject.get("frame").getSuccess().flatMap(frameElement -> JsonParseUtils.parseFrame(frameElement).ifFailure(errors::add).getSuccess()).orElse(class_189.field_1254);
        List rewards = rootObject.getArray("rewards").andThen(array -> array.getAsList((i, element) -> SkillRewardConfig.parse(element)).mapFailure(ManyErrors::ofList)).ifFailure(errors::add).getSuccess().orElseGet(List::of);
        if (errors.isEmpty()) {
            return Result.success(new SkillDefinitionConfig(id, (class_2561)optTitle.orElseThrow(), optDescription, (IconConfig)optIcon.orElseThrow(), frame, rewards));
        }
        return Result.failure(ManyErrors.ofList(errors));
    }

    public void dispose(MinecraftServer server) {
        for (SkillRewardConfig reward : this.rewards) {
            reward.dispose(server);
        }
    }

    public String getId() {
        return this.id;
    }

    public class_2561 getTitle() {
        return this.title;
    }

    public class_2561 getDescription() {
        return this.description;
    }

    public class_189 getFrame() {
        return this.frame;
    }

    public IconConfig getIcon() {
        return this.icon;
    }

    public List<SkillRewardConfig> getRewards() {
        return this.rewards;
    }
}

