/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.main;

import com.mojang.brigadier.CommandDispatcher;
import java.util.function.Function;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2168;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.puffish.skillsmod.SkillsMod;
import net.puffish.skillsmod.network.InPacket;
import net.puffish.skillsmod.network.OutPacket;
import net.puffish.skillsmod.server.event.ServerEventListener;
import net.puffish.skillsmod.server.event.ServerEventReceiver;
import net.puffish.skillsmod.server.network.ServerPacketHandler;
import net.puffish.skillsmod.server.network.ServerPacketReceiver;
import net.puffish.skillsmod.server.network.ServerPacketSender;

public class FabricMain
implements ModInitializer {
    public void onInitialize() {
        SkillsMod.setup(FabricLoader.getInstance().getConfigDir(), class_2378::method_10230, new ServerEventReceiverImpl(), new ServerPacketSenderImpl(), new ServerPacketReceiverImpl());
    }

    private static class ServerEventReceiverImpl
    implements ServerEventReceiver {
        private ServerEventReceiverImpl() {
        }

        @Override
        public void registerListener(ServerEventListener eventListener) {
            ServerLifecycleEvents.SERVER_STARTING.register(eventListener::onServerStarting);
            ServerLifecycleEvents.END_DATA_PACK_RELOAD.register((server, resourceManager, success) -> eventListener.onServerReload(server));
            ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> eventListener.onPlayerJoin(handler.field_14140));
            CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> eventListener.onCommandsRegister((CommandDispatcher<class_2168>)dispatcher));
        }
    }

    private static class ServerPacketSenderImpl
    implements ServerPacketSender {
        private ServerPacketSenderImpl() {
        }

        @Override
        public void send(class_3222 player, OutPacket packet) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)packet.getIdentifier(), (class_2540)packet.getBuf());
        }
    }

    private static class ServerPacketReceiverImpl
    implements ServerPacketReceiver {
        private ServerPacketReceiverImpl() {
        }

        @Override
        public <T extends InPacket> void registerPacket(class_2960 identifier, Function<class_2540, T> reader, ServerPacketHandler<T> handler) {
            ServerPlayNetworking.registerGlobalReceiver((class_2960)identifier, (server, player, handler2, buf, responseSender) -> {
                InPacket packet = (InPacket)reader.apply(buf);
                server.execute(() -> handler.handle(player, packet));
            });
        }
    }
}

