/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.utils;

import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.puffish.skillsmod.SkillsMod;
import org.apache.commons.io.FileUtils;

public class PathUtils {
    public static void createFileIfMissing(Path path) {
        if (!Files.exists(path, new LinkOption[0])) {
            try {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                Files.createFile(path, new FileAttribute[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static boolean isDirectoryEmpty(Path path) {
        try {
            return FileUtils.isEmptyDirectory((File)path.toFile());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void copyFileFromJar(Path source, Path target) {
        try {
            FileUtils.copyInputStreamToFile((InputStream)Objects.requireNonNull(SkillsMod.getInstance().getClass().getResourceAsStream(StreamSupport.stream(source.spliterator(), false).map(Path::toString).collect(Collectors.joining("/", "/", "")))), (File)target.toFile());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

