/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.utils.error;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.puffish.skillsmod.utils.error.Error;

public class ManyErrors
implements Error {
    private final List<Error> errors;

    private ManyErrors(List<Error> errors) {
        this.errors = errors;
    }

    public static ManyErrors ofList(List<Error> errors) {
        ArrayList<Error> tmp = new ArrayList<Error>();
        for (Error error : errors) {
            if (error instanceof ManyErrors) {
                ManyErrors manyErrors = (ManyErrors)error;
                tmp.addAll(manyErrors.errors);
                continue;
            }
            tmp.add(error);
        }
        return new ManyErrors(tmp);
    }

    public List<Error> get() {
        return this.errors;
    }

    @Override
    public String getMessage() {
        return this.errors.stream().map(Error::getMessage).collect(Collectors.joining(System.lineSeparator()));
    }
}

